<?php
require_once 'config.php';

main();

function main() {
 header('content-type: text/xml; charset=utf-8');

 $channel = array(
  'about' => BLOG_ROOT_URL.'rss.php',
  'title' => BLOG_NAME,
  'link' => BLOG_ROOT_URL,
  'description' => BLOG_DISC,
  'creator' => BLOG_ADMIN
 );

 $items = array();
 foreach (get_recent_entry_list() as $item) {
  $description = strip_tags(render_entry_body($item));
  $description = mb_substr($description, 0, 255);

  $items[] = array(
   'link' => BLOG_ROOT_URL.'entry.php/'.$item['filename'],
   'date' => date('Y-m-d\TH:i:s+09:00', $item['date']),
   'title' => $item['title'],
   'description' => $description,
  );
 }

 show_template('rss.tmpl', array(
  'channel' => to_utf8($channel, 'UTF-8'),
  'items' => to_utf8($items, 'UTF-8'),
 ));
}