<?php

require_once 'config.php';

if (! POP3PWD == '') {
 require_once 'Net/POP3.php';
 require_once 'Mail/mimeDecode.php';
 define('MAILCHECK_AVAILABLE', '1');
 define('CHECK_MAIL_TOUCH_FILE', './mailcheck.tmp');
 define('CHECK_MAIL_TIME', 60);

 main();
} else {
 die(MAILCHECK_NOTDEFINED);
}

function main() {
 if (!check_time_elapsed(CHECK_MAIL_TOUCH_FILE, CHECK_MAIL_TIME)) {
  die(MSG_MAILCHECK_TOOSHORT1.CHECK_MAIL_TIME.MSG_MAILCHECK_TOOSHORT2);
 }

 $pop3 =& new Net_POP3();
 $pop3->connect(POP3HOST);
 $pop3->login(POP3ID, POP3PWD);
 $list = $pop3->getListing();
 echo MSG_MAILCHECK_MAILALLNUMBER1.count($list).MSG_MAILCHECK_MAILALLNUMBER2."\n";
 foreach ($list as $item) {
  $msg_id = $item['msg_id'];
  echo MSG_MAILCHECK_MAILNOWNUMBER1.$msg_id.MSG_MAILCHECK_MAILNOWNUMBER2."\n";
  $maildata = $pop3->getMsg($msg_id);
  post_entry($maildata, $msg_id);
  $pop3->deleteMsg($msg_id);
 }
 $pop3->disconnect();
}

function post_entry($maildata, $msg_id) {
 $parsed = parse_mail($maildata);
 if (!$parsed) {
  echo MSG_MAILCHECK_PARSE."\n";
  return;
 }

 $filename = date('YmdHis').'_'.$msg_id;

 $parsed['body'] = text_to_html(rtrim($parsed['body']));

 if (isset($parsed['image']) && is_resource($parsed['image'])) {
  $parsed['body'] .=
   "\n".'<br><a href="'.BLOG_IMG_URL.$filename.'.jpg" class="a_mailedimg"><img src="'.BLOG_IMG_URL.$filename.'.jpg" class="img_mailedimg"></a>';

  imagejpeg($parsed['image'], IMG_DATA_DIR.'/'.$filename.'.jpg');
  echo MSG_FILEUPLOAD_SENT.$filename."\n";
 }

 if (!POP_ALLOWSTRING == '') {
  if (mb_strpos($parsed['subject'], POP_ALLOWSTRING) === FALSE) {
   die('');
  }
 }

 $entry_data = array(
  'cmd' => 'new',
  'filename' => $filename.'.txt',
  'title' => $parsed['subject'],
  'date' => time(),
  'format' => 'HTML',
  'ping_urls' => '',
  'body' => $parsed['body'],
 );

 save_entry_data($entry_data);
 echo MSG_ENTRY_SAVED.$filename."\n";
}

function parse_mail($mail) {
 $result = array();

 $decoder =& new Mail_mimeDecode($mail);
 $option = array(
  'include_bodies' => TRUE,
  'decode_bodies' => TRUE,
  'decode_headers' => TRUE
 );
 $structure = $decoder->decode($option);
 if (!$structure) {return $result;}

 $result['from'] = $structure->headers['from'];
 $result['subject'] = $structure->headers['subject'];
 if (isset($structure->parts)) {
  $result['body'] = $structure->parts[0]->body;
  if (isset($structure->parts[1])) {
   $image_data = $structure->parts[1]->body;
   $result['image'] = @imagecreatefromstring($image_data);
  }
 } else {
  $result['body'] = $structure->body;
 }
 foreach (array('from', 'subject', 'body') as $key) {
  $result[$key] = mb_convert_encoding($result[$key], 'UTF-8', 'jis');
 }

 return $result;
}

function check_time_elapsed($filename, $seconds = 600) {
 $filemtime = filemtime($filename);
 if (time() > $filemtime + $seconds) {
  touch($filename);
  return TRUE;
 }
 return FALSE;
}