<?php

function send_update_ping($ping_url) {
    $request_xml = get_update_ping_request();

    $request_length = strlen($request_xml);

    $ch = curl_init($ping_url);
    $urlinfo = parse_url($ping_url);
    $header = 'POST '.$urlinfo['path'].' HTTP/1.1'."\r\n";
    $header .= 'HOST: '.$urlinfo['host']."\r\n";
    $header .= 'Content-Type: text/xml; charset=UTF-8'."\r\n";
    $header .= 'Content-Length: '.$request_length."\r\n";
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $header."\r\n".$request_xml);

    ob_start();
    curl_exec($ch);
    curl_close($ch);
    $result_xml = ob_get_contents();
    ob_end_clean();

debuglog('Info', 'Ping(Send)');

    return get_error_from_result_xml($result_xml);
}

function get_update_ping_request() {
    $blog_name = mb_convert_encoding(BLOG_NAME, 'utf8', 'UTF-8');
    $blog_url = BLOG_ROOT_URL;

    $request_xml  = '<'.'?xml version="1.0" encoding="utf-8" ?'.'>'."\n";
    $request_xml .= '<methodCall>'."\n";
    $request_xml .= '<methodName>weblogUpdates.ping</methodName>'."\n";
    $request_xml .= '<params>'."\n";
    $request_xml .= '<param><value>'
                    .htmlspecialchars($blog_name)
                    .'</value></param>'."\n";
    $request_xml .= '<param><value>'
                    .htmlspecialchars($blog_url)
                    .'</value></param>'."\n";
    $request_xml .= '</params>'."\n";
    $request_xml .= '</methodCall>'."\n";

    return $request_xml;
}

function get_error_from_result_xml($result_xml) {
    $pattern = '|<name>faultCode</name>\s*<value>\s*<int>(.*?)</int>\s*</value>|';
    if (preg_match($pattern, $result_xml, $matches)) {
        $faultCode = intval($matches[1]);
        if ($faultCode == 0) {
            return NULL;
        } else {
            if (preg_match('|<name>faultString</name>\s*<value>\s*<string>(.*)</string>\s*</value>|m', $result_xml, $matches)) {
                return 'ERROR: '.$matches[1];
            } else {
                return 'ERROR: UNKNOWN ERROR';
            }
        }
    } else {
        return 'ERROR: UNKNOWN ERROR';
    }
}
