<?php

function load_comment_data($filename) {
    if (!file_exists(COMMENT_DATA_DIR.'/'.$filename)) {return array();}
    $fp = fopen(COMMENT_DATA_DIR.'/'.$filename, 'r');
    if (!$fp) {die(LIB_COMMENTLIB_CANNOTOPEN);};
    if (!flock($fp, LOCK_SH)) {die(LIB_COMMENTLIB_CANNOTLOCK);}

    $comments = array();
    while (!feof($fp)) {
        $line = fgets($fp);
        $line = rtrim($line);
        if ($line == '') {continue;}
        list($date, $deleted, $name, $url, $comment) = explode("\t", $line, 5);

        $comments[] = array(
            'date' => $date,
            'deleted' => $deleted,
            'name' => $name,
            'url' => $url,
            'comment' => $comment,
        );
    }

     fclose($fp);
     return $comments;
}

function import_comment_data() {
    $fields = array('name', 'url', 'comment', 'filename');
    $comment_data = array();
    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            $comment_data[$field] = rtrim($_POST[$field]);
        } else {
            $comment_data[$field] = NULL;
        }
    }
    $comment_data['comment'] = str_replace("\n", '<br>', htmlspecialchars($comment_data['comment']));
    foreach (array('name', 'url', 'comment', 'filename') as $field) {
        $comment_data[$field] = preg_replace('/[\n\r\t\0]/', ' ', $comment_data[$field]);
    }

    $entry_data = load_entry_data($comment_data['filename']);

    return $comment_data;
}

function is_valid_comment_data($comment_data) {
    $result = array();

    $fields = array(
        'name' => LIB_COMMENTLIB_ISVALID_NAME,
        'url' => LIB_COMMENTLIB_ISVALID_URI,
        'comment' => LIB_COMMENTLIB_ISVALID_COMMENT,
        'filename' => LIB_COMMENTLIB_ISVALID_FILENAME,
    );

    $requires = array('name', 'comment', 'filename');
    foreach ($requires as $field) {
        if ($comment_data[$field] == '') {
            $result[] = LIB_COMMENTLIB_BLANK1.$fields[$field].LIB_COMMENTLIB_BLANK2;
        }
    }
    if (count($result) > 0) {return $result;}

    $lengths = array(
        'name' => 40,
        'url' => 100,
        'comment' => 4000,
    );
    foreach ($lengths as $field => $size) {
        if (strlen($comment_data[$field]) > $size) {
            $result[] = LIB_COMMENTLIB_TOOLONG1.$fields[$field].LIB_COMMENTLIB_TOOLONG2;
        }
    }

    if (!preg_match('/^[0-9A-Za-z\-_]+\.txt$/', $comment_data['filename'])) {
        $result[] = LIB_COMMENTLIB_BADCHAR1.$fields['filename'].LIB_COMMENTLIB_BADCHAR2;
    }

    if (!preg_match('/.+@.+/', $comment_data['url'])) {
        $result[] = LIB_COMMENTLIB_BADURICHAR1.$fields['url'].LIB_COMMENTLIB_BADURICHAR2;
    }

    if (!file_exists(ENTRY_DATA_DIR.'/'.$comment_data['filename'])) {
        $result[] = LIB_COMMENTLIB_NOFILE;
    }

    if (count($result) == 0) {return NULL;}

    return $result;
}

function add_comment_data($comment_data) {
    $filename = $comment_data['filename'];
    $fp = fopen(COMMENT_DATA_DIR.'/'.$filename, 'a');
    if (!$fp) {die(LIB_COMMENTLIB_CANNOTOPEN);}
    if (!flock($fp, LOCK_EX)) {die(LIB_COMMENTLIB_CANNOTLOCK);}

    $now = time();
    $deleted = 0;
    $line = mb_convert_encoding($now."\t".$deleted."\t".$comment_data['name']."\t".$comment_data['url']."\t".$comment_data['comment']."\n", "UTF-8", "auto");

    fwrite($fp, $line);
    fclose($fp);
}
