<?php
require_once 'config.php';

main();

function main() {
    check_index();

    switch ($_SERVER['REQUEST_METHOD']) {
    case 'GET':
        do_get();
        break;
    case 'POST':
        do_post();
        break;
    default:
        die(MSG_ILLEGAL_ACCESS);
    }
}

function do_get() {
    $cmd = isset($_GET['cmd']) ? $_GET['cmd'] : 'list';
    switch ($cmd) {

    case 'new':
        show_new_entry_form();
        break;

    case 'edit':
        show_edit_entry_form();
        break;

    case 'delete':
        do_delete_entry();
        break;

    case 'deletecomment':
        do_delete_entry_comment();
        break;

    case 'deletecomment2':
        show_delete_entry_comment_form();
        break;

    case 'deletetb':
        do_delete_entry_tb();
        break;

    case 'deletetb2':
        show_delete_entry_tb_form();
        break;

    case 'deletereferrer':
        do_delete_entry_referrer();
        break;

    case 'deletereferrer2':
        show_delete_entry_referrer_form();
        break;

    case 'chcss':
        do_change_css();
        break;

    case 'makeindex':
        do_update_index();
        break;

    case 'imgupload':
        show_upload_form();
        break;

    case 'dataupload':
        show_upload_form2();
        break;

    case 'uploadedlist':
        show_uploaded_list();
        break;

    case 'dirimagelist':
        show_dirimage_list();
        break;

    case 'messageform':
        show_message_form();
        break;

    case 'status':
        show_status();
        break;

    case 'status2':
        show_status2();
        break;

    case 'adminlogout':
        do_adminlogout();
        break;

    case 'adminmenulistnopw':
        show_entry_list_for_edit_nopw();
        break;

    default:
        show_entry_list_for_edit();
    }
}

function do_post() {
    $entry_data = import_entry_data();
    if (isset($_POST['save'])) {
        $result = is_valid_entry_data($entry_data);
        if (!$result) {
            save_entry_data($entry_data);
            show_entry_saved($entry_data);
        } else {
            show_entry_save_error($entry_data, $result);
        }
    } elseif (isset($_POST['imgupload'])) {
        do_upload_image();
    } elseif (isset($_POST['dataupload'])) {
        do_upload_data();
    } elseif (isset($_POST['sendmessage'])) {
        do_sendmessage();
    } elseif (isset($_POST['pwd'])) {
        show_entry_list_for_edit();
    } elseif (isset($_POST['chpwd'])) {
        do_changepassword();
    } else {
        die(MSG_ILLEGAL_ACCESS);
    }
}

function do_adminlogout() {
    setcookie('adminloginstatus','',time() - 1800,'/');
    show_template('redirect.tmpl', array(
        'title' => PWD_ADMINLOGOUT_DONE,
        'redirect_url' => BLOG_INDEX_URL,
        'delayed' => 2,
        ));
        debuglog($type = 'Info', $msg = 'AdminLogout');
    exit();
}

function do_changepassword() {
    if (!isset($_POST['chpwd'])) { die(CHPWD_FAIL_INVALID); }

    if ($_POST['chpwd'] == 'RESET') {
        if (file_exists(BLOG_PWD_DIR)) { unlink(BLOG_PWD_DIR); }
            show_template('htmlheader1.tmpl', array('title' => CHPWD_SUCCESSED_DELETE));
            show_template('css.tmpl');
            show_template('htmlheader3.tmpl');
            show_template('blogtool.tmpl');
            show_template('htmlheader5.tmpl');
            show_template('redirect.tmpl', array(
                'title' => CHPWD_SUCCESSED_DELETE,
                'redirect_url' => BLOG_ROOT_URL,
                'delayed' => 2,
            ));
            show_template('htmlfooter.tmpl');
    } else {
        if ($_POST['chpwd'] == $_POST['chpwd2']) {
            if ( !preg_match('/^[0-9A-Za-z]+$/', $_POST['chpwd']) ) { die(CHPWD_FAIL_INVALID); }
            file_put_contents(BLOG_PWD_DIR ,md5($_POST['chpwd']) ,LOCK_EX);
            show_template('htmlheader1.tmpl', array('title' => CHPWD_SUCCESSED));
            show_template('css.tmpl');
            show_template('htmlheader3.tmpl');
            show_template('blogtool.tmpl');
            show_template('htmlheader5.tmpl');
            show_template('redirect.tmpl', array(
                'title' => CHPWD_SUCCESSED.' ... '.h($_POST['chpwd']),
                'redirect_url' => BLOG_ROOT_URL,
                'delayed' => 2,
            ));
            show_template('htmlfooter.tmpl');
        }
    }
    debuglog($type = 'Info', $msg = 'ChangePassword');
}

function do_sendmessage() {
    $to = $_POST["to"];
    $subject = $_POST["subject"];
    $message = $_POST["message"];
    $add_header = 'From:' . $_POST["from"];

    if (mb_send_mail($to,$subject,$message,$add_header)) {
        show_template('redirect.tmpl', array(
            'title' => MSG_SENDMESSAGE_SENT,
            'redirect_url' => BLOG_ROOT_URL,
            'delayed' => 2,
        ));
        debuglog($type = 'Info', $msg = 'SendMessage');
    } else {
        die(MSG_SENDMESSAGE_ERROR);
    }
}

function do_upload_data() {

    if (!isset($_FILES['datafile'])) {
     die(MSG_FILEUPLOAD_NOFILE);
    }

    if ($_FILES['datafile']['size'] > MAX_FILE_SIZE) {
     die(MSG_FILEUPLOAD_TOOLARGE.'('.MSG_FILEUPLOAD_MAX1.MAX_FILE_SIZE.MSG_FILEUPLOAD_MAX2.')');
    }
    if ($_FILES['datafile']['size'] == '0') {
        die(MSG_FILEUPLOAD_NOFILE.MSG_COMMON_OR.MSG_FILEUPLOAD_TOOLARGE);
    }

    if (!preg_match(ALLOW_EXTENSIONS, $_FILES['datafile']['name'], $matches)) {
     die(MSG_FILEUPLOAD_NOTALLOWEXTENSION);
    }

    $dstfile = UPLOAD_DIR.'/'.time().'.'.$matches[1];

    if (!move_uploaded_file($_FILES['datafile']['tmp_name'], $dstfile)) {
     die(MSG_FILEUPLOAD_ERROR);
    }

    debuglog($type = 'Info', $msg = 'UploadDatafile');

    show_template('redirect.tmpl', array(
        'title' => MSG_FILEUPLOAD_SENT.BLOG_UPLOAD_URL.time().'.'.$matches[1],
        'redirect_url' => BLOG_ROOT_URL,
        'delayed' => 2,
    ));
}

function do_upload_image() {
    if (!isset($_FILES['imgfile'])) {die(MSG_FILEUPLOAD_NOFILE);}
    if ($_FILES['imgfile']['size'] > MAX_UPLOAD_SIZE) {die(MSG_FILEUPLOAD_TOOLARGE);}
    if ($_FILES['imgfile']['size'] == '0') {
        die(MSG_FILEUPLOAD_NOFILE.MSG_COMMON_OR.MSG_FILEUPLOAD_TOOLARGE);
    }
    $tmpname = $_FILES['imgfile']['tmp_name'];
    $imageinfo = getimagesize($tmpname);
    if (!$imageinfo || $imageinfo[2] != 2) {
        unlink($tmpname);
        die(MSG_FILEUPLOAD_IMAGE_NOTJPEG);
    }

    $now = time();
    $dstfile = IMG_DATA_DIR . '/' . $now . '.jpg';
    if (!move_uploaded_file($tmpname, $dstfile)) {
        die(MSG_FILEUPLOAD_ERROR);
    }

    debuglog($type = 'Info', $msg = 'UploadImgfile');

    show_template('redirect.tmpl', array(
        'title' => MSG_FILEUPLOAD_SENT . BLOG_IMG_URL . $now . '.jpg',
        'redirect_url' => BLOG_IMG_URL . $now . '.jpg',
        'delayed' => 2,
    ));
}

function do_delete_entry() {
    $filename = isset($_GET['filename']) ? $_GET['filename'] : NULL;
    if (!preg_match('|^[0-9A-Za-z_\-]+\.txt$|', $filename)) {die(MSG_ILLEGAL_FILENAME);}
    $entry_data = load_entry_data($filename);
    if (isset($_GET['confirm'])) {
        delete_entry_data($entry_data);
        debuglog($type = 'Info', $msg = 'DeleteEntry');
        show_template('redirect.tmpl', array(
            'title' => MSG_FILEDELETE_DELETED.$entry_data['title'],
            'redirect_url' => BLOG_ADMIN_URL,
            'delayed' => 2,
        ));
    } else {
        show_template('delete_entry_form.tmpl', $entry_data);
    }
}

function show_delete_entry_comment_form() {
    show_template('selectdelcomment.tmpl');
}

function do_delete_entry_comment() {
    $filename = isset($_GET['filename']) ? $_GET['filename'] : NULL;
    $delcommentnum = isset($_GET['delcommentnum']) ? $_GET['delcommentnum'] : NULL;
    $entry_data = load_entry_data($filename);
    if (file_exists(COMMENT_DATA_DIR.'/'.$filename)) {
        if (!preg_match('|^[0-9A-Za-z_\-]+\.txt$|', $filename)) {die(MSG_ILLEGAL_FILENAME);}
        if (!preg_match('|^[0-9]+$|', $delcommentnum)) {$delcommentnum = "1";}
        $filename = COMMENT_DATA_DIR.'/'.$filename;
        @copy($filename,OLD_DIR.'/comment_'.$filename.date('YmdHis').'.old');
        if ($delcommentnum == "0") { unlink($filename); } else {
            $commentdatas = file($filename);

            array_splice($commentdatas,$delcommentnum - 1,1);
            $fpdc = fopen($filename,'a+b');
            flock($fpdc,LOCK_EX);
            ftruncate($fpdc,0);
            foreach ($commentdatas as $key => $value) {
                fwrite($fpdc,$value."\n");
            }
            fclose($fpdc);
        }

        debuglog($type = 'Info', $msg = 'DeleteEntryComment');

        show_template('redirect.tmpl', array(
            'title' => MSG_FILEDELETE_DELETED_COMMENT.$entry_data['title'],
            'redirect_url' => BLOG_ADMIN_URL,
            'delayed' => 2,
            ));
    } else {
        show_template('redirect.tmpl', array(
            'title' => MSG_FILEDELETE_DELETED_COMMENT_NOFILE.$entry_data['title'],
            'redirect_url' => BLOG_ADMIN_URL,
            'delayed' => 2,
            ));
    }
}

function show_delete_entry_tb_form() {
    show_template('selectdeltb.tmpl');
}

function do_delete_entry_tb() {
    $filename = isset($_GET['filename']) ? $_GET['filename'] : NULL;
    $deltbnum = isset($_GET['deltbnum']) ? $_GET['deltbnum'] : NULL;
    $entry_data = load_entry_data($filename);
    if (file_exists(TRACKBACK_DATA_DIR.'/'.$filename)) {
        if (!preg_match('|^[0-9A-Za-z_\-]+\.txt$|', $filename)) {die(MSG_ILLEGAL_FILENAME);}
        if (!preg_match('|^[0-9]+$|', $deltbnum)) {$deltbnum = "1";}
        $filename = TRACKBACK_DATA_DIR.'/'.$filename;
        @copy($filename,OLD_DIR.'/tb_'.$filename.date('YmdHis').'.old');
        if ($deltbnum == "0") { unlink($filename); } else {
            $tbdatas = file($filename);

            array_splice($tbdatas,$deltbnum - 1,1);
            $fpdc = fopen($filename,'a+b');
            flock($fpdc,LOCK_EX);
            ftruncate($fpdc,0);
            foreach ($tbdatas as $key => $value) {
                fwrite($fpdc,$value."\n");
            }
            fclose($fpdc);
        }

        debuglog($type = 'Info', $msg = 'DeleteEntryTrackback');

        show_template('redirect.tmpl', array(
            'title' => MSG_FILEDELETE_DELETED_TB.$entry_data['title'],
            'redirect_url' => BLOG_ADMIN_URL,
            'delayed' => 2,
            ));
    } else {
        show_template('redirect.tmpl', array(
            'title' => MSG_FILEDELETE_DELETED_TB_NOFILE.$entry_data['title'],
            'redirect_url' => BLOG_ADMIN_URL,
            'delayed' => 2,
            ));
    }
}

function show_delete_entry_referrer_form() {
    show_template('selectdelreferrer.tmpl');
}

function do_delete_entry_referrer() {
    $filename = isset($_GET['filename']) ? $_GET['filename'] : NULL;
    $delreferrernum = isset($_GET['delreferrernum']) ? $_GET['delreferrernum'] : NULL;
    $entry_data = load_entry_data($filename);
    if (file_exists(BLOG_REFERRER_DIR.'/'.$filename)) {
        if (!preg_match('|^[0-9A-Za-z_\-]+\.txt$|', $filename)) {die(MSG_ILLEGAL_FILENAME);}
        if (!preg_match('|^[0-9]+$|', $delreferrernum)) {$delreferrernum = "1";}
        $filename = BLOG_REFERRER_DIR.'/'.$filename;
        @copy($filename,OLD_DIR.'/referrer_'.$filename.date('YmdHis').'.old');
        if ($delreferrernum == "0") { unlink($filename); } else {
            $referrerdatas = file($filename);

            array_splice($referrerdatas,$delreferrernum - 1,1);
            $fpdc = fopen($filename,'a+b');
            flock($fpdc,LOCK_EX);
            ftruncate($fpdc,0);
            foreach ($referrerdatas as $key => $value) {
                fwrite($fpdc,$value."\n");
            }
            fclose($fpdc);
        }

        debuglog($type = 'Info', $msg = 'DeleteEntryReferrer');

        show_template('redirect.tmpl', array(
            'title' => MSG_FILEDELETE_DELETED_REFERRER.$entry_data['title'],
            'redirect_url' => BLOG_ADMIN_URL,
            'delayed' => 2,
            ));
    } else {
        show_template('redirect.tmpl', array(
            'title' => MSG_FILEDELETE_DELETED_REFERRER_NOFILE.$entry_data['title'],
            'redirect_url' => BLOG_ADMIN_URL,
            'delayed' => 2,
            ));
    }
}

function do_change_css() {
    if (!copy($_GET['cssfilename'],TEMPLATE_DIR.'/css.tmpl')) { die(MSG_CSS_NOTCHANGED); }

    debuglog($type = 'Info', $msg = 'ChangeCss');

    show_template('redirect.tmpl', array(
        'title' => MSG_CSS_CHANGED,
        'redirect_url' => BLOG_ADMIN_URL,
        'delayed' => 2,
        ));
}

function show_status() {
    debuglog($type = 'Info', $msg = 'ShowStatus');
    show_template('status.tmpl');
}

function show_status2() {
    debuglog($type = 'Info', $msg = 'ShowStatus2');
    show_template('htmlheader1.tmpl', array('title' => MSG_ADMIN_MENU_UPLOADEDLIST));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    echo '<table width="90%">';

    echo '<tr><th colspan="0">'.STATUS2_PHP_INFO.'</th></tr>';

    echo '<tr><td>'.STATUS2_PHP_VER.'</td><td>'.PHP_VERSION.'</td></tr>';

    echo '<tr><td>'.STATUS2_PHP_OS.'</td><td>'.PHP_OS.'</td></tr>';

    echo '</table>';

    echo '<br /><br />';

    echo '<table width="90%">';

    echo '<tr><th colspan="0">'.STATUS2_WB_INFO.'</th></tr>';

    echo '<tr><th>'.STATUS2_INDEX_FILE.'</th>';
    echo '<th>'.STATUS2_INDEX_SIZE.'</th>';
    echo '<th>'.STATUS2_INDEX_MTIME.'</th>';
    echo '<th>'.STATUS2_INDEX_READ.'</th>';
    echo '<th>'.STATUS2_INDEX_WRITE.'</th></tr>';

    echo '<tr><td colspan="0"><b>'.BLOG_ROOT_URL.'</b></td></tr>';
    status2_fileindex(BLOG_ROOT_DIR);

    echo '<tr><td colspan="0"><b>'.CSS_URL.'</b></td></tr>';
    status2_fileindex(CSS_DIR);

    echo '<tr><td colspan="0"><b>'.BLOG_DATA_URL.'</b></td></tr>';
    status2_fileindex(BLOG_DATA_DIR);

    echo '<tr><td colspan="0"><b>'.COMMENT_DATA_URL.'</b></td></tr>';
    status2_fileindex(COMMENT_DATA_DIR);

    echo '<tr><td colspan="0"><b>'.ENTRY_DATA_URL.'</b></td></tr>';
    status2_fileindex(ENTRY_DATA_DIR);

    echo '<tr><td colspan="0"><b>'.BLOG_IMG_URL.'</b></td></tr>';
    status2_fileindex(IMG_DATA_DIR);

    echo '<tr><td colspan="0"><b>'.BLOG_REFERRER_URL.'</b></td></tr>';
    status2_fileindex(BLOG_REFERRER_DIR);

    echo '<tr><td colspan="0"><b>'.TRACKBACK_DATA_URL.'</b></td></tr>';
    status2_fileindex(TRACKBACK_DATA_DIR);

    echo '<tr><td colspan="0"><b>'.BLOG_UPLOAD_URL.'</b></td></tr>';
    status2_fileindex(UPLOAD_DIR);

    echo '</table>';
    show_template('htmlfooter.tmpl');
}

function show_message_form() {
    show_template('htmlheader1.tmpl', array('title' => 'SendMessage'));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    show_template('message_form.tmpl');
    show_template('htmlfooter.tmpl');
}

function show_upload_form() {
    show_template('htmlheader1.tmpl', array('title' => MSG_FILEUPLOAD_IMAGE));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    show_template('upload_form.tmpl');
    show_template('htmlfooter.tmpl');
}

function show_upload_form2() {
    show_template('htmlheader1.tmpl', array('title' => MSG_FILEUPLOAD));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    show_template('upload_form2.tmpl');
    show_template('htmlfooter.tmpl');
}

function show_new_entry_form() {
    $data = init_entry_data();

    show_template('htmlheader1.tmpl', array('title' => MSG_ENTRY_POST_NEW));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    show_template('entry_form.tmpl', $data);
    show_template('htmlfooter.tmpl');
}

function show_edit_entry_form() {
    $filename = $_GET['filename'];
    $entry_data = load_entry_data($filename);
    $entry_data['cmd'] = 'edit';

    show_template('htmlheader1.tmpl', array('title' => MSG_ENTRY_EDIT.$entry_data['title']));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    show_template('entry_form.tmpl', $entry_data);
    show_template('htmlfooter.tmpl');
}

function show_entry_list_for_edit() {

    $adminloginstatus = isset($_COOKIE['adminloginstatus']) ? $_COOKIE['adminloginstatus'] :'';
    $pwd = isset($_POST['pwd']) ? $_POST['pwd'] :'';
    if (file_exists(BLOG_PWD_DIR)) {
        if ( $adminloginstatus !== file_get_contents(BLOG_PWD_DIR) ){
            if ( filesize(BLOG_PWD_DIR) > '0' ) {
                if ( md5($pwd) !== file_get_contents(BLOG_PWD_DIR) ) {
                    show_template('redirect.tmpl', array(
                        'title' => PWD_WRONG,
                        'redirect_url' => BLOG_INDEX_URL,
                        'delayed' => 2,
                        ));
                        exit();
                }
            } else {
                if ( $pwd !== '' ) {
                    show_template('redirect.tmpl', array(
                        'title' => PWD_WRONG,
                        'redirect_url' => BLOG_INDEX_URL,
                        'delayed' => 2,
                        ));
                        exit();
                }
            }
        }
    } else {
        if ( $pwd !== '' ) {
            show_template('redirect.tmpl', array(
                'title' => PWD_WRONG,
                'redirect_url' => BLOG_INDEX_URL,
                'delayed' => 2,
                ));
            exit();
        }
    }

    if (file_exists(BLOG_PWD_DIR)) {
        if ( $pwd !== '' ) {
            setcookie('adminloginstatus',md5($pwd),time()+1800,'/');
        }
    }

    debuglog($type = 'Info', $msg = 'AdminLogin');

    $index =& new EntryIndex();
    $entry_list = $index->load();
    $css_list = glob(CSS_DIR.'/*.css');

    show_template('htmlheader1.tmpl', array('title' => MSG_ADMIN_MENU));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    show_template('admin_menu.tmpl', array(
        'entry_list' => $entry_list,
        'css_list' => $css_list,
        ));
    show_template('htmlfooter.tmpl');
}

function show_dirimage_list() {
    $dir = dir(IMG_DATA_DIR);
    show_template('htmlheader1.tmpl', array('title' => MSG_ADMIN_MENU_DIRIMAGELIST));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    while (FALSE !== ($fileName = $dir->read())) {
        $path = $dir->path . '/' . $fileName;
        if (@getimagesize($path)) {
            $imageFile = u($fileName);
            echo '<a href="' . BLOG_IMG_URL . $imageFile . '" target="_blank">';
            echo '<img src="' . BLOG_IMG_URL . $imageFile . '" width="100" alt="Image" class="ddimg" />';
            echo '</a>&nbsp;';
        }
    }
    $dir->close();
    show_template('htmlfooter.tmpl');
}

function show_uploaded_list() {
    $uploaded_list     = implode(" \n ", fileindex(UPLOAD_DIR));
    $uploaded_img_list = implode(" \n ", fileindex(IMG_DATA_DIR));

    show_template('htmlheader1.tmpl', array('title' => MSG_ADMIN_MENU_UPLOADEDLIST));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    echo '<br><h3>';
    echo '<a href="'.$_SERVER['PHP_SELF'].'?cmd=uploadedlist">'.MSG_ADMIN_MENU_UPLOADEDLIST.'</a>';
    echo '</h3><br>';
    echo MSG_ADMIN_MENU_UPLOADEDLIST_FILE.'(<a href="'.BLOG_UPLOAD_URL.'">'.BLOG_UPLOAD_URL.'</a>)<br>'." \n ".'<pre>';
    echo $uploaded_list;
    echo '</pre><br><h3>';
    echo '<a href="'.$_SERVER['PHP_SELF'].'?cmd=dirimagelist">'.TMP_ADMINMENU_DIRIMAGELIST.'</a>';
    echo '</h3><br>';
    echo MSG_ADMIN_MENU_UPLOADEDLIST_JPEG.'(<a href="'.BLOG_IMG_URL.'">'.BLOG_IMG_URL.'</a>)<br>'." \n ".'<pre>';
    echo $uploaded_img_list;
    echo '</pre>';
    show_template('htmlfooter.tmpl');
}

function show_entry_saved($entry_data) {
    if (isset($_POST['send_update_ping']) && $_POST['send_update_ping'] == 1) {
        foreach ($GLOBALS['UPDATE_PING_SERVERS'] as $ping_server) {
            send_update_ping($ping_server);
        }
    }

    if (isset($_POST['ping_url']) && $_POST['ping_url'] != '') {
        $tb_result = send_trackback_ping($entry_data, array($_POST['ping_url']));
        if (count($tb_result) > 0) {
        }
    }
    if (isset($_POST['trackback_auto_discovery'])) {
        do_trackback_autodiscovery($entry_data);
    }

    show_template('htmlheader1.tmpl', array('title' => MSG_ENTRY_SAVE));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    show_template('redirect.tmpl', array(
        'title' => MSG_ENTRY_SAVED.$entry_data['title'],
        'redirect_url' => BLOG_ROOT_URL.'entry.php/'.$entry_data['filename'],
        'delayed' => 2,
    ));
    show_template('htmlfooter.tmpl');
}

function do_trackback_autodiscovery($entry_data) {
    $html = render_entry_body($entry_data);
    $html = strip_tags($html, '<a>');
    if (!preg_match_all('/<a .*href="(.*?)">/', $html, $matches)) {return;}
    $ping_urls = array();
    foreach ($matches[1] as $url) {
        $ping_url = trackback_auto_discovery($url);
        if ($ping_url) {$ping_urls[] = $ping_url;}
    }
    if (count($ping_urls) > 0) {
        $tb_result = send_trackback_ping($entry_data, $ping_urls);
        if (count($tb_result) > 0) {
            print_r($tb_result);
        }
    }
}

function show_entry_save_error($entry_data, $msgs) {
    show_template('htmlheader1.tmpl', array('title' => MSG_ENTRY_SAVE));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    show_template('msgs.tmpl', array('title' => MSG_ENTRY_SAVE_ERROR, 'msgs' => $msgs));
    show_template('entry_form.tmpl', $entry_data);
    show_template('htmlfooter.tmpl');
}

function check_index() {
    if (!file_exists(ENTRY_INDEX_FILE)) {
        do_update_index();
        die;
    }
}

function do_update_index() {
    $index =& new EntryIndex();
    $index->sync();
    $index->save();
    show_template('redirect.tmpl', array(
        'title' => MSG_ENTRY_INDEX_RE,
        'redirect_url' => BLOG_INDEX_URL,
        'delayed' => 2,
    ));
}

function show_entry_list_for_edit_nopw() {
    debuglog($type = 'Info', $msg = 'AdminMenuWithoutPassword');
    $index =& new EntryIndex();
    $entry_list = $index->load();
    $css_list = glob(CSS_DIR.'/*.css');

    show_template('htmlheader1.tmpl', array('title' => MSG_ADMIN_MENU));
    show_template('css.tmpl');
    show_template('htmlheader3.tmpl');
    show_template('blogtool.tmpl');
    show_template('htmlheader5.tmpl');
    show_template('admin_menu.tmpl', array(
        'entry_list' => $entry_list,
        'css_list' => $css_list,
        ));
    show_template('htmlfooter.tmpl');
}
