#pragma once

#include "stdafx.h"
#include "SocketX.h"

//////////////////////////////////////////////////////////////////////////

CNetwork::CNetwork()
{
}

CNetwork::~CNetwork()
{
}

BOOL CNetwork::GetIPv4List(DWORD &dwSize, DWORD dwMax, LPIPv4 lpList)
{
	PMIB_IPADDRTABLE pIpAddrTable;
	DWORD dwTbSize = 0;
	DWORD dwRetVal = 0;

	// Get size
	if (GetIpAddrTable(NULL, &dwTbSize, 0) == ERROR_INSUFFICIENT_BUFFER)
	{
		pIpAddrTable = (PMIB_IPADDRTABLE)malloc(dwTbSize);

		if (pIpAddrTable == NULL)
		{
			TRACE1("***** ERROR: malloc(%d) *****\n", GetLastError());
			return FALSE;
		}
	}

	// Get data
	if (GetIpAddrTable(pIpAddrTable, &dwTbSize, 0) == NO_ERROR)
	{
		if (pIpAddrTable->dwNumEntries > 0)
		{
			dwSize = pIpAddrTable->dwNumEntries < dwMax ?
					 pIpAddrTable->dwNumEntries : dwMax;

			for (UINT i = 0; i < (UINT)dwSize; i++)
			{
				lpList[i].dwIndex		 = pIpAddrTable->table[i].dwIndex;
				lpList[i].dwAddress	     = pIpAddrTable->table[i].dwAddr;
				lpList[i].dwNetMask      = pIpAddrTable->table[i].dwMask;
				lpList[i].dwBcastAddress = MakeBcastAddress(lpList[i].dwAddress, lpList[i].dwNetMask);
			}
		}
	}

	free(pIpAddrTable);

	return TRUE;
}

BOOL CNetwork::IsAvailable()
{
	DWORD dwSize;
	IPv4  list[2];

	if (!GetIPv4List(dwSize, 2, list))
	{
		return FALSE;
	}

	// Is not connected to the network. Or just loopback
	if ((dwSize < 1) || (dwSize == 1 && list[0].dwAddress == 0x0100007F))
	{
		return FALSE;
	}

	return TRUE;
}

DWORD CNetwork::MakeBcastAddress(DWORD dwAddress, DWORD dwNetMask)
{
	return ((dwAddress & dwNetMask) | (~dwNetMask));
}

//////////////////////////////////////////////////////////////////////////