#include "StdAfx.h"
#include "DefaultPlugin.h"

//////////////////////////////////////////////////////////////////////////

CDefaultPlugin::CDefaultPlugin()
{
	doConstructor();
}

CDefaultPlugin::~CDefaultPlugin()
{
}

//////////////////////////////////////////////////////////////////////////

BOOL CDefaultPlugin::LoadInitialize()
{
	// ToDo: 
	return doLoadInitialize(), TRUE;
}

void CDefaultPlugin::ReceiveCallBack(const CByteArray &data)
{
	CSingleLock sl(&m_NetLock, TRUE);

	// ToDo:
	CalcReportList list;
	CALCREPORT cr;
			
	API_StopTimer();
	API_StopPlugin(list);
}

//////////////////////////////////////////////////////////////////////////

BOOL CDefaultPlugin::MasterInitialize(const NodeDataList &list, BOOL fSystem)
{
	MASTER_PLUGIN init;
	
	// ToDo:
	init.bSystem   = fSystem;
	init.bFront	   = FALSE;
	init.csWndName = _T("Window Title");
	init.list.Copy(list);

	return doMasterInitialize(init);
}

BOOL CDefaultPlugin::MasterFinalize()
{
	// ToDo:
	return doMasterFinalize(), TRUE;
}

DWORD CDefaultPlugin::MasterTransaction(LPVOID lpParams)
{
	// ToDo:
	LPPLUGIN_PARAMS p = (LPPLUGIN_PARAMS)lpParams;
	CByteArray data;	// Parameters
	
	if (p->fSystem)
	{
		// System mode
		API_StartPlugin(m_PlgInfo.wPluginID, data);
	}
	else
	{
		// Single mode
		double dbRuntime;
		dbRuntime = 0.0;
		SetCalcReport(p->dwIndex, dbRuntime);
	}

	return CPlugin::MasterTransaction();
}

//////////////////////////////////////////////////////////////////////////

BOOL CDefaultPlugin::SlaveInitialize(const SLAVE_PLUGIN &init)
{
	// ToDo:
	return doSlaveInitialize(init);
}

BOOL CDefaultPlugin::SlaveFinalize()
{
	// ToDo:
	return doSlaveFinalize(), TRUE;
}

DWORD CDefaultPlugin::SlaveTransaction(LPVOID lpParams)
{
	// ToDo: 
	LPPLUGIN_PARAMS p = (LPPLUGIN_PARAMS)lpParams;
	
	return CPlugin::SlaveTransaction();
}

//////////////////////////////////////////////////////////////////////////

