#pragma once

#include "stdafx.h"
#include "SocketX.h"

//////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CPeerSocket, IBaseSocket)

CPeerSocket::CPeerSocket()
{
}

CPeerSocket::~CPeerSocket()
{
}

BOOL CPeerSocket::CreateSocket(SOCKMSG SockMsg)
{
	if (!IBaseSocket::CreateSocketWindow())
	{
		return FALSE;
	}

	SetTargetWnd(SockMsg);

	m_hSocket = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

	if (m_hSocket == INVALID_SOCKET)
	{
		TRACE1("***** ERROR: socket(%d) *****\n", GetLastError());
		m_dwError = GetLastError();
		return FALSE;
	}

	SetSendTimeout(m_dwSendTimeout);
	SetRecieveTimeout(m_dwReceiveTimeout);

	return TRUE;
}

void CPeerSocket::OnClose(SOCKET hSocket, int nErrorCode)
{
	NETADDR NetAddr;

	if (nErrorCode != 0)
	{
		TRACE1("***** ERROR: OnClose(%d) *****\n", nErrorCode);
		return;
	}

	if (CloseSocket())
	{
		ConvertSockAddrToNetAddr(&m_PeerAddr, NetAddr);
		m_SockMsg.pTgtObj->OnSocketCloseMessage(m_SockMsg.dwSocketID, NetAddr);
	}	
}

void CPeerSocket::OnSend(SOCKET hSocket, int nErrorCode)
{
	if (nErrorCode != 0)
	{
		TRACE1("***** ERROR: OnSend(%d) *****\n", nErrorCode);
		return;
	}

	m_SockMsg.pTgtObj->OnSocketSendMessage(m_SockMsg.dwSocketID);
}

void CPeerSocket::OnReceive(SOCKET hSocket, int nErrorCode)
{
	CByteArray data;
	SOCKADDR   SockAddr;
	NETADDR	   NetAddr;
	int nLenSA = sizeof(SOCKADDR);

	if (nErrorCode != 0)
	{
		TRACE1("***** ERROR: OnReceive(%d) *****\n", nErrorCode);
		return;
	}

	if (!doReceiveFrom(hSocket, data, &SockAddr, &nLenSA))
	{
		return;
	}

	ConvertSockAddrToNetAddr(&SockAddr, NetAddr);
	m_SockMsg.pTgtObj->OnSocketReceiveFromMessage(m_SockMsg.dwSocketID, NetAddr, data);
}

BOOL CPeerSocket::Initialize(SOCKMSG SockMsg, DWORD dwLocalAddress, WORD wPort)
{
	SOCKADDR_IN siAddr;

	if (!CreateSocket(SockMsg))
	{
		return FALSE;
	}

	if (!Bind(wPort, dwLocalAddress))
	{
		CloseSocket();
		return FALSE;
	}

	if (!(SetSendBufferSize(SX_UDP_BUFSIZE) && SetSendBufferSize(SX_UDP_BUFSIZE)))
	{
		CloseSocket();
		return FALSE;
	}

	siAddr.sin_family	   = AF_INET;
	siAddr.sin_port		   = htons(wPort);
	siAddr.sin_addr.s_addr = dwLocalAddress;
	CopyMemory(&m_LocalAddr, &siAddr, sizeof(m_LocalAddr));

	m_fInit = TRUE;

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////