#pragma once

#include <afxcoll.h>

//////////////////////////////////////////////////////////////////////////

class CStringSplit
{
public:
	CStringSplit() {}
	virtual ~CStringSplit() {}

	CStringArray &Split(const CString &src, TCHAR sep)
	{
		CString str = src;
		UINT    nPrev;
		UINT    nLength = src.GetLength();
		LPTSTR  lpStr   = static_cast<LPTSTR>(str.GetBuffer());

		m_WordList.RemoveAll();
		nPrev = 0;

		for (UINT i = 0; i < nLength; i++)
		{
			if (lpStr[i] == sep)
			{
				CString word;
				UINT    nWordLength = i - nPrev;

				if (nWordLength > 0)
				{
					word.SetString(&lpStr[nPrev], nWordLength);
					m_WordList.Add(word);
					nPrev = i + 1;//
					i++;
				}
			}
		}

		if (nPrev > 0)
		{
			CString word;
			UINT    nWordLength = nLength - nPrev;

			if (nWordLength > 0)
			{
				word.SetString(&lpStr[nPrev], nWordLength);
				m_WordList.Add(word);
			}
		}
		
		str.ReleaseBuffer();

		return m_WordList;
	}

protected:
	CStringArray m_WordList;
};

//////////////////////////////////////////////////////////////////////////