#pragma once

#include "afxwin.h"

//////////////////////////////////////////////////////////////////////////

class CWinCSSetupDlg : public CDialog, CStringConvert
{
	DECLARE_DYNAMIC(CWinCSSetupDlg)

public:
	CWinCSSetupDlg(CWnd* pParent = NULL);
	virtual ~CWinCSSetupDlg();
	enum { IDD = IDD_SETUP_DIALOG };

	void SetWcsStatus(WCS_STATUS wcsStatus) { m_wcsStatus = wcsStatus; }
	void GetWcsStatus(WCS_STATUS &wcsStatus) { wcsStatus = m_wcsStatus; }

protected:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();
	
	afx_msg void OnBnClickedOk();
	afx_msg void OnCbnSelchangeCmbSetupOperation();
	afx_msg void OnBnClickedBtnSetupOption();

	BOOL CheckFormat();
	void OutputSettingsData();

public:
	WCS_STATUS	m_wcsStatus;
	DWORD		m_dwListSize;
	IPv4		m_IPv4List[WCS_MAX_NETSIZE];
	
public:
	CComboBox	m_xCmbInterface;
	CComboBox	m_xCmbOperation;
	CButton		m_xBtnOperation;
	CEdit		m_xEditConnection;
	CEdit		m_xEditUDPClientPort;
	CEdit		m_xEditUDPServerPort;
	CEdit		m_xEditTCPPort;
	CEdit		m_xEditRetry;
	CEdit		m_xEditTimeout;

protected:
	HICON		m_hIcon;
	UINT		m_nSelectInterface;
	UINT		m_nSelectOperation;
};

//////////////////////////////////////////////////////////////////////////
