#include "stdafx.h"
#include "WinCS.h"
#include "WinCSDlg.h"
#include "BMConfirmDlg.h"
#include "MasterSettingDlg.h"
#include "SlaveSettingDlg.h"
#include "EXEConfirmDlg.h"
#include "PluginTransferDlg.h"
#include "APIReportDlg.h"
#include "StructuredException.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////////

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();
	enum { IDD = IDD_ABOUTBOX };

protected:
	DECLARE_MESSAGE_MAP()

	virtual void DoDataExchange(CDataExchange* pDX);
};

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

//////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CWinCSDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDOK, &CWinCSDlg::OnBnClickedOk)
	ON_MESSAGE(WM_SHOW_FOREGROUND, &CWinCSDlg::OnSetForeground)
	ON_MESSAGE(WM_SHOWN, &CWinCSDlg::OnShown)
	ON_MESSAGE(WM_PLUGIN_RELOAD, &CWinCSDlg::OnPluginReload)
	ON_MESSAGE(WM_PLUGIN_CHANGE, &CWinCSDlg::OnPluginChange)
	ON_MESSAGE(WM_PLUGIN_TRANSFER, &CWinCSDlg::OnPluginTransfer)
	ON_MESSAGE(WM_PLUGIN_SENDING, &CWinCSDlg::OnPluginSending)
	ON_MESSAGE(WM_PLUGIN_LOCK, &CWinCSDlg::OnPluginLock)
	ON_MESSAGE(WM_SEND_TEXT, &CWinCSDlg::OnSendText)
	ON_MESSAGE(WM_BMSYSTEM_PROGRESS, &CWinCSDlg::OnBenchmarkProgress)
	ON_COMMAND(IDM_TOOL_RESTART, &CWinCSDlg::OnToolRestart)
	ON_COMMAND(IDM_TOOL_STOP, &CWinCSDlg::OnToolStop)
	ON_COMMAND(IDM_TOOL_EXECUTE, &CWinCSDlg::OnToolExecute)
	ON_COMMAND(IDM_TOOL_BENCHMARK, &CWinCSDlg::OnToolBenchmark)
	ON_COMMAND(IDM_TOOL_SETTING, &CWinCSDlg::OnToolSetting)
	ON_COMMAND(IDM_TOOL_TRANSFER, &CWinCSDlg::OnToolTransfer)
	ON_COMMAND(IDM_TOOL_FREE_PLUGIN, &CWinCSDlg::OnToolFreePlugin)
	ON_COMMAND(IDM_TOOL_REFRESH_NODE_LIST, &CWinCSDlg::OnToolRefreshNodeList)
	ON_COMMAND(IDM_FILE_SAVE_LOG, &CWinCSDlg::OnFileLogoutput)
	ON_COMMAND(IDM_FILE_CONSOLECLEAR, &CWinCSDlg::OnFileConsoleClear)
	ON_COMMAND(IDM_FILE_EXIT, &CWinCSDlg::OnFileExit)
	ON_COMMAND(IDM_HELP_VERSION, &CWinCSDlg::OnHelpVersion)
	ON_COMMAND_EX(IDT_TB_SETTING, &CWinCSDlg::OnToolBarEvent)
	ON_COMMAND_EX(IDT_TB_INFORMATION, &CWinCSDlg::OnToolBarEvent)
	ON_COMMAND_EX(IDT_TB_LOG, &CWinCSDlg::OnToolBarEvent)
	ON_COMMAND_EX(IDT_TB_EXECUTE, &CWinCSDlg::OnToolBarEvent)
	ON_COMMAND_EX(IDT_TB_BENCHMARK, &CWinCSDlg::OnToolBarEvent)
	ON_COMMAND_EX(IDT_TB_STOP, &CWinCSDlg::OnToolBarEvent)
	ON_COMMAND_EX(IDT_TB_TRANSFER, &CWinCSDlg::OnToolBarEvent)
	ON_COMMAND_EX(IDT_TB_RESTART, &CWinCSDlg::OnToolBarEvent)
	ON_WM_CLOSE()
END_MESSAGE_MAP()

CWinCSDlg::CWinCSDlg(CWnd* pParent) : CDialog(CWinCSDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_WINCS);
	ZeroMemory(&m_wcsStatus, sizeof(m_wcsStatus));
	ZeroMemory(&m_MasterSetting, sizeof(m_MasterSetting));
	ZeroMemory(&m_SlaveSetting, sizeof(m_SlaveSetting));
}

CWinCSDlg::~CWinCSDlg()
{
	FreePlugin(FALSE);

	// GDI+ exit
	Gdiplus::GdiplusShutdown(m_ulpGdiToken);
}

void CWinCSDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

//////////////////////////////////////////////////////////////////////////
// WinCS API

BOOL CWinCSDlg::API_StartPlugin(WORD wPluginID, const CByteArray &arg)
{
	CByteArray data;
	TCP_DATA   tData;

	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		CSingleLock sl(&m_NetLock, TRUE);
		ZeroMemory(&tData, TCPHDR_SIZE);
		tData.wMsgType	   = WCS_MSG_PLUGIN_START;
		tData.wSrcNodeType = WCS_NODE_MASTER;
		tData.wDstNodeType = WCS_NODE_SLAVE;
		tData.wSrcNodeID   = m_wcsStatus.wNodeID;
		tData.wDstNodeID   = WCS_DEFAULT_NODE_ID;
		tData.dwOption	   = wPluginID;
		tData.dwDataSize   = arg.GetSize();

		data.SetSize(TCPHDR_SIZE + tData.dwDataSize);
		CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
		CopyMemory(data.GetData() + TCPHDR_SIZE, arg.GetData(), tData.dwDataSize);
		data.FreeExtra();

		return m_pServerSocket->Broadcast(data);
	}

	return FALSE;
}

BOOL CWinCSDlg::API_StopPlugin(double dbRuntime)
{
	CByteArray data;
	TCP_DATA   tData;
	CString	   cs;

	m_wcsStatus.wNodeState = WCS_STATE_WAITING;
	m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);

	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		// Master
		m_PluginList.fRunning = FALSE;
		m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_WAITING);

		if (m_APIWnd.Graphics.IsAPIWindow())
		{
			cs.Format(_T("Runtime: %.4lf sec"), dbRuntime);
			CMsgBox::Information(MC_CStoSTR(cs), _T("Completed"), m_APIWnd.Graphics.m_hWnd);
		}	
	}
	else
	{
		// Slave
		ZeroMemory(&tData, TCPHDR_SIZE);
		tData.wMsgType	   = WCS_MSG_PLUGIN_STOP;
		tData.wSrcNodeType = WCS_NODE_MASTER;
		tData.wDstNodeType = WCS_NODE_SLAVE;
		tData.wSrcNodeID   = m_wcsStatus.wNodeID;
		tData.wDstNodeID   = WCS_MASTER_NODE_ID;
		
		data.SetSize(TCPHDR_SIZE);
		CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
		data.FreeExtra();
		m_pClientSocket->Send(data);
		
		cs.Format(_T("Finish plugin : (%s)\r\n>> %s"), GetNowTime(), 
				  m_PluginList.list[m_PluginList.nSelect].csModuleName);
		m_wndSlaveView.AddConsoleText(cs);
		m_wndSlaveView.EndProgress();
		m_wndSlaveView.SetPluginRuntime(dbRuntime);
	}

	return TRUE;
}

BOOL CWinCSDlg::API_StopPlugin(const CalcReportList &list)
{
	CString cs;

	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		m_PluginList.fRunning  = FALSE;
		m_wcsStatus.wNodeState = WCS_STATE_WAITING;
		m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);

		if (m_APIWnd.Graphics.IsAPIWindow())
		{
			cs.Format(_T("Finish plugin(%s) : (%s)\r\n>> %s"),
					  m_APIWnd.Graphics.IsSystemMode() ? _T("System mode") : _T("Single mode"), 
					  GetNowTime(), m_PluginList.list[m_PluginList.nSelect].csModuleName);
			m_wndMasterView.AddConsoleText(cs);
			m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_WAITING);

			m_APIWnd.Graphics.FinishDrawing();
			m_APIWnd.Graphics.SetReportList(list);
			m_APIWnd.Graphics.SetLog(m_MasterSetting.fLogPlugin);
			m_APIWnd.Graphics.PostMessage(WM_OUTPUT_REPORT);
		}
	}

	return TRUE;
}

BOOL CWinCSDlg::API_Broadcast(const CByteArray &data)
{
	CByteArray snd;
	TCP_DATA   tData;
	
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		CSingleLock sl(&m_NetLock, TRUE);
		ZeroMemory(&tData, TCPHDR_SIZE);
		tData.wMsgType	   = WCS_MSG_PLUGIN_RAWDATA;
		tData.wSrcNodeType = WCS_NODE_MASTER;
		tData.wDstNodeType = WCS_NODE_SLAVE;
		tData.wSrcNodeID   = m_wcsStatus.wNodeID;
		tData.wDstNodeID   = WCS_DEFAULT_NODE_ID;
		tData.dwDataSize   = data.GetSize();

		snd.SetSize(TCPHDR_SIZE + tData.dwDataSize);
		CopyMemory(snd.GetData(), &tData, TCPHDR_SIZE);
		CopyMemory(snd.GetData() + TCPHDR_SIZE, data.GetData(), tData.dwDataSize);
		snd.FreeExtra();

		return m_pServerSocket->Broadcast(snd);
	}

	return FALSE;
}

BOOL CWinCSDlg::API_SendToMaster(const CByteArray &data)
{
	CByteArray snd;
	TCP_DATA   tData;
	
	if (m_wcsStatus.wNodeType == WCS_NODE_SLAVE && m_PluginList.fRunning)
	{
		CSingleLock sl(&m_NetLock, TRUE);
		tData.wMsgType	   = WCS_MSG_PLUGIN_RAWDATA;
		tData.wSrcNodeType = WCS_NODE_SLAVE;
		tData.wDstNodeType = WCS_NODE_MASTER;
		tData.wSrcNodeID   = m_wcsStatus.wNodeID;
		tData.wDstNodeID   = WCS_MASTER_NODE_ID;
		tData.dwDataSize   = data.GetSize();

		snd.SetSize(TCPHDR_SIZE + tData.dwDataSize);
		CopyMemory(snd.GetData(), &tData, TCPHDR_SIZE);
		CopyMemory(snd.GetData() + TCPHDR_SIZE, data.GetData(), tData.dwDataSize);
		snd.FreeExtra();

		return m_pClientSocket->Send(snd);
	}

	return FALSE;
}

BOOL CWinCSDlg::API_CreateGraphWindow(const CString &csName, int cx, int cy, BOOL bFront)
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		return m_APIWnd.Graphics.Create(csName, cx, cy, bFront);
	}

	return FALSE;
}

BOOL CWinCSDlg::API_SetPixel(int x, int y, COLORREF color)
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		return m_APIWnd.Graphics.SetPixel(x, y, color);
	}

	return FALSE;
}

BOOL CWinCSDlg::API_SetXLine(int y, int cx, LPCOLORREF lpColor)
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		return m_APIWnd.Graphics.SetXLine(y, cx, lpColor);
	}

	return FALSE;
}

BOOL CWinCSDlg::API_SetYLine(int x, int cy, LPCOLORREF lpColor)
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		return m_APIWnd.Graphics.SetYLine(x, cy, lpColor);
	}

	return FALSE;
}

BOOL CWinCSDlg::API_SetTaskSchedule(const NodeInitList &list)
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		return TRUE;
	}

	return FALSE;
}

void CWinCSDlg::API_SetProgress(DWORD dwIndex, int nPoint)
{
	if (m_wcsStatus.wNodeType == WCS_NODE_SLAVE && m_PluginList.fRunning)
	{
		nPoint = (nPoint > 100) ? 100 : nPoint;
		m_wndSlaveView.SetProgress(dwIndex, nPoint);
	}
}

void CWinCSDlg::API_InitProgress(DWORD dwProcessors)
{
	if (m_wcsStatus.wNodeType == WCS_NODE_SLAVE && m_PluginList.fRunning)
	{
		m_wndSlaveView.InitProgress(dwProcessors);
	}
}

void CWinCSDlg::API_SetGraphWindowSize(int cx, int cy, int x, int y)
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		m_APIWnd.Graphics.SetWindowSize(cx, cy, x, y);
	}
}

void CWinCSDlg::API_SetCenterWindow()
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		m_APIWnd.Graphics.SetCenterWindow();
	}
}

void CWinCSDlg::API_ResetWindow()
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		m_APIWnd.Graphics.ResetWindow();
	}
}

void CWinCSDlg::API_StartTimer()
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		m_APIWnd.Graphics.StartTimer();
	}
}

void CWinCSDlg::API_StopTimer()
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER && m_PluginList.fRunning)
	{
		m_APIWnd.Graphics.StopTimer();
	}
}

//////////////////////////////////////////////////////////////////////////

LRESULT CWinCSDlg::OnPluginReload(WPARAM wParam, LPARAM lParam)
{
	CString cs;

	if (m_wcsStatus.wNodeState != WCS_STATE_EXECUTING)
	{
		LoadPlugin();
	}
	else
	{
		cs.LoadString(IDS_WCS_ERROR_PLUGIN_LOAD);
		AfxMessageBox(cs);
	}
	
	return TRUE;
}

LRESULT CWinCSDlg::OnPluginChange(WPARAM wParam, LPARAM lParam)
{
	CSingleLock sl(&m_PluginList.cs, TRUE);

	UINT nIndex = static_cast<UINT>(wParam);
	UINT nSize  = static_cast<UINT>(m_PluginList.list.GetSize());

	if (nSize > nIndex)
	{
		m_PluginList.nSelect = nIndex;
		m_wndStatusView.SetPluginInfo(m_PluginList.list[nIndex].plgInfo);

		if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
		{
			m_wndMasterView.SetPluginName(m_PluginList.list[nIndex].csModuleName);
		}
	}

	return TRUE;
}

LRESULT CWinCSDlg::OnPluginLock(WPARAM wParam, LPARAM lParam)
{
	BOOL fLock = static_cast<BOOL>(wParam);
	m_wndStatusView.SetPluginState(fLock);
	return TRUE;
}

LRESULT CWinCSDlg::OnPluginTransfer(WPARAM wParam, LPARAM lParam)
{
	return OnTransfer(), TRUE;
}

LRESULT CWinCSDlg::OnPluginSending(WPARAM wParam, LPARAM lParam)
{
	CSingleLock sl1(&m_NodeList.cs, TRUE);

	CByteArray data;
	TCP_DATA   tData;
	TRANSFER   tf;
	IntList    list;
	CString	   cs1, cs2, csPath, csModule;
	HANDLE	   hFile;
	DWORD	   dwStrSize, dwFileSize, dwReadSize, dwAddress;
	WORD	   wPort, wNodeID;
	UINT	   nNSize, nPSize, nIndex;
	int		   nPoint, nCount, nSum;

	m_dlgTransfer.GetSendList(list);
	nPSize = list.GetSize();
	nNSize = m_NodeList.list.GetSize();
	nCount = 0;
	nSum   = m_sysStatus.dwSlaves * nPSize;

	for (UINT i = 0; i < nPSize; i++)
	{
		nIndex    = list[i];
		csModule  = m_PluginList.list[nIndex].csModuleName;
		dwStrSize = sizeof(TCHAR) * _MAX_FNAME;
		csPath.Format(_T("./Plugin/%s"), csModule);
		hFile = CreateFile(csPath, GENERIC_READ, 0, NULL, OPEN_EXISTING,
						   FILE_ATTRIBUTE_NORMAL, NULL);

		if (hFile != INVALID_HANDLE_VALUE)
		{
			ZeroMemory(&tf, sizeof(tf.dwFileSize) + dwStrSize);
			lstrcpy(tf.szFileName, csModule);
			dwFileSize = GetFileSize(hFile, NULL);
			tf.dwFileSize = dwFileSize;
			tf.data.SetSize(dwFileSize);

			if (ReadFile(hFile, tf.data.GetData(), dwFileSize, &dwReadSize, NULL))
			{
				m_dlgTransfer.SetPlugin(csModule);
				tData.data.SetSize(sizeof(tf.dwFileSize) + dwStrSize + dwFileSize);
				CopyMemory(tData.data.GetData(), &tf.dwFileSize, sizeof(tf.dwFileSize));
				CopyMemory(tData.data.GetData() + sizeof(tf.dwFileSize), tf.szFileName, dwStrSize);
				CopyMemory(tData.data.GetData() + sizeof(tf.dwFileSize) + dwStrSize, tf.data.GetData(), dwFileSize);

				ZeroMemory(&tData, TCPHDR_SIZE);
				tData.wMsgType	   = WCS_MSG_PLUGIN_TRANSFER;
				tData.wSrcNodeType = WCS_NODE_MASTER;
				tData.wDstNodeType = WCS_NODE_SLAVE;
				tData.wSrcNodeID   = m_wcsStatus.wNodeID;
				tData.dwDataSize   = tData.data.GetSize();

				if (m_dlgTransfer.IsSending())
				{
					cs1.Format(_T("Send plugin : (%s)\r\n>> %s"), GetNowTime(), tf.szFileName);
					m_wndMasterView.AddConsoleText(cs1);
				}

				for (UINT j = 1; j < nNSize; j++)
				{
					if (m_dlgTransfer.IsSending())
					{
						wPort     = m_NodeList.list[j].wPort;
						wNodeID	  = m_NodeList.list[j].wNodeID;
						dwAddress = m_NodeList.list[j].dwAddress;
						m_dlgTransfer.SetSendToSlave(wNodeID, dwAddress);

						tData.wDstNodeID = wNodeID;
						data.SetSize(TCPHDR_SIZE + tData.dwDataSize);
						CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
						CopyMemory(data.GetData() + TCPHDR_SIZE, tData.data.GetData(), tData.dwDataSize);
						data.FreeExtra();

						if (m_pServerSocket->SendToClient(data, dwAddress, wPort))
						{
							nCount++;
							nPoint = static_cast<int>(nCount * 100 / nSum);
							m_dlgTransfer.SetProgress(nPoint);
						}
					}
				}
			}

			CloseHandle(hFile);
		}
		else
		{
			m_dlgTransfer.PostMessage(WM_PLUGIN_TRANSFER_ERROR, static_cast<WPARAM>(nIndex));
		}
	}

	return TRUE;
}

LRESULT CWinCSDlg::OnSendText(WPARAM wParam, LPARAM lParam)
{
	CByteArray data;
	TCP_DATA   tData;
	CString	   cs;

	ZeroMemory(&tData, TCPHDR_SIZE);

	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		tData.wMsgType	   = WCS_MSG_PLAINTEXT;
		tData.wSrcNodeType = WCS_NODE_MASTER;
		tData.wDstNodeType = WCS_NODE_SLAVE;
		tData.wSrcNodeID   = m_wcsStatus.wNodeID;
		tData.wDstNodeID   = WCS_DEFAULT_NODE_ID;
		m_wndMasterView.GetSendMessage(cs);
		StringToByteArray(cs, tData.data);
		tData.dwDataSize = tData.data.GetSize();

		data.SetSize(TCPHDR_SIZE + tData.dwDataSize);
		CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
		CopyMemory(data.GetData() + TCPHDR_SIZE, tData.data.GetData(), tData.dwDataSize);
		data.FreeExtra();
		m_pServerSocket->Broadcast(data);
	}
	else
	{
		tData.wMsgType	   = WCS_MSG_PLAINTEXT;
		tData.wSrcNodeType = WCS_NODE_SLAVE;
		tData.wDstNodeType = WCS_NODE_MASTER;
		tData.wSrcNodeID   = m_wcsStatus.wNodeID;
		tData.wDstNodeID   = WCS_MASTER_NODE_ID;
		m_wndSlaveView.GetSendMessage(cs);
		StringToByteArray(cs, tData.data);
		tData.dwDataSize = tData.data.GetSize();

		data.SetSize(TCPHDR_SIZE + tData.dwDataSize);
		CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
		CopyMemory(data.GetData() + TCPHDR_SIZE, tData.data.GetData(), tData.dwDataSize);
		data.FreeExtra();
		m_pClientSocket->Send(data);
	}

	return TRUE;
}

LRESULT CWinCSDlg::OnBenchmarkProgress(WPARAM wParam, LPARAM lParam)
{
	CByteArray data;
	TCP_DATA   tData;
	DWORD dwProgress = static_cast<DWORD>(wParam);

	ZeroMemory(&tData, TCPHDR_SIZE);
	tData.wMsgType	   = WCS_MSG_BENCHMARK_PROGRESS;
	tData.wSrcNodeType = WCS_NODE_SLAVE;
	tData.wDstNodeType = WCS_NODE_MASTER;
	tData.wSrcNodeID   = m_wcsStatus.wNodeID;
	tData.wDstNodeID   = WCS_MASTER_NODE_ID;
	tData.dwOption	   = dwProgress;
	tData.dwDataSize   = 0;

	data.SetSize(TCPHDR_SIZE);
	CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
	data.FreeExtra();
	m_pClientSocket->Send(data);

	return TRUE;
}

LRESULT CWinCSDlg::OnShown(WPARAM wParam, LPARAM lParam)
{
	WORD wNodeType = static_cast<WORD>(wParam);
	m_wndStatusView.SetNodeType(wNodeType);
	return TRUE;
}

LRESULT CWinCSDlg::OnSetForeground(WPARAM wParam, LPARAM lParam)
{
	if (IsIconic())
	{
		ShowWindowAsync(m_hWnd, SW_RESTORE);
	}

	return SetForegroundWindow();
}

BOOL CWinCSDlg::OnToolBarEvent(UINT nID)
{
	switch (nID)
	{
	case IDT_TB_EXECUTE:
		OnMasterExecute();
		break;

	case IDT_TB_STOP:
		OnStop();
		break;

	case IDT_TB_RESTART:
		OnRestart();
		break;

	case IDT_TB_BENCHMARK:
		OnBenchmark();
		break;

	case IDT_TB_SETTING:
		OnSetting();
		break;

	case IDT_TB_LOG:
		OnSaveLog();
		break;

	case IDT_TB_INFORMATION:
		OnHelp();
		break;

	case IDT_TB_TRANSFER:
		OnTransfer();
		break;
	}

	return TRUE;
}

void CWinCSDlg::OnToolRestart()
{
	OnRestart();
}

void CWinCSDlg::OnToolStop()
{
	OnStop();
}

void CWinCSDlg::OnToolExecute()
{
	OnMasterExecute();
}

void CWinCSDlg::OnToolBenchmark()
{
	OnBenchmark();
}

void CWinCSDlg::OnToolSetting()
{
	OnSetting();
}

void CWinCSDlg::OnToolTransfer()
{
	OnTransfer();
}

void CWinCSDlg::OnToolFreePlugin()
{
	OnFreePlugin();
}


void CWinCSDlg::OnToolRefreshNodeList()
{
	OnRefreshNodeList();
}

void CWinCSDlg::OnFileLogoutput()
{
	OnSaveLog();
}

void CWinCSDlg::OnFileConsoleClear()
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		m_wndMasterView.ClearConsoleText();
	}
	else
	{
		m_wndSlaveView.ClearConsoleText();
	}
}

void CWinCSDlg::OnFileExit()
{
	OnExit();
}

void CWinCSDlg::OnHelpVersion()
{
	OnHelp();
}

void CWinCSDlg::OnClose()
{
	int		nRet;
	CString cs;

	cs.LoadString(IDS_WCS_TEXT_SYSTEM_EXIT_CONFIRM);
	nRet = CMsgBox::Question(MC_CStoSTR(cs), _T("WinCS"), m_hWnd);

	if (nRet == IDYES)
	{
		CDialog::OnClose();
	}
}

//////////////////////////////////////////////////////////////////////////

void CWinCSDlg::OnExit()
{
	SendMessage(WM_CLOSE);
}

void CWinCSDlg::OnRestart()
{
	PROCESS_INFORMATION pi;
	STARTUPINFO	si;
	CString	cs;
	BOOL	fRet;
	int		nRet = IDYES;
	TCHAR   szCmdLine[] = _T("Restart.exe");

	cs.LoadString(IDS_WCS_TEXT_RESTART_CONFIRM);
	nRet = CMsgBox::Question(MC_CStoSTR(cs), _T("WinCS"), m_hWnd);

	if (nRet == IDYES)
	{
		ZeroMemory(&si, sizeof(si));
		si.cb = sizeof(si);

		fRet = CreateProcess(NULL,
							 szCmdLine,
							 NULL,
							 NULL,
							 FALSE,
							 NORMAL_PRIORITY_CLASS,
							 NULL,
							 NULL,
							 &si,
							 &pi);

		if (fRet)
		{
			CloseHandle(pi.hThread);
			CloseHandle(pi.hProcess);
			EndDialog(IDOK);
		}
		else
		{
			cs.LoadString(IDS_WCS_ERROR_RESTART);
			AfxMessageBox(cs);
		}

		EndDialog(IDOK);
	}
}

void CWinCSDlg::OnSaveLog()
{
	SYSTEMTIME st;
	CByteArray data;
	CString csPath, csFile, csText, cs;
	HANDLE  hFile;
	DWORD   dwFileSize, dwWriteSize;
	
	GetLocalTime(&st);
	csFile.Format(_T("%04d%02d%02d_%02d%02d%02d.log"),
				  st.wYear, st.wMonth, st.wDay,
				  st.wHour, st.wMinute, st.wSecond);
	csPath.Format(_T("./Log/Console/%s"), csFile);
	
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		m_wndMasterView.GetConsoleText(csText);
	}
	else
	{
		m_wndSlaveView.GetConsoleText(csText);
	}

	hFile = CreateFile(csPath, GENERIC_WRITE, 0, NULL, CREATE_NEW,
					   FILE_ATTRIBUTE_NORMAL, NULL);

	if (hFile != INVALID_HANDLE_VALUE)
	{
		dwFileSize = csText.GetLength() * sizeof(TCHAR);

		if (WriteFile(hFile, csText, dwFileSize, &dwWriteSize, NULL))
		{
			cs.Format(_T("Save complete\r\n%s"), csFile);
			CMsgBox::Information(MC_CStoSTR(cs), _T("WinCS"), m_hWnd);
		}

		CloseHandle(hFile);
	}
	else
	{
		cs.LoadString(IDS_WCS_ERROR_LOGOUTPUT);
		AfxMessageBox(cs);
	}
}

void CWinCSDlg::OnSetting()
{
	CString cs;

	if (m_wcsStatus.wNodeState != WCS_STATE_WAITING)
	{
		cs.LoadString(IDS_WCS_ERROR_CHANGE_SETTING);
		AfxMessageBox(cs);
		return;
	}

	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		CMasterSettingDlg dlg;
		int nIndex;

		dlg.SetSetting(m_MasterSetting);

		if (dlg.DoModal() == IDOK)
		{
			dlg.GetSetting(m_MasterSetting);
			m_pServerSocket->SetConnectionMode(m_MasterSetting.fInternet);
			
			if (m_wcsStatus.dwProcessors != m_MasterSetting.nProcessors)
			{
				m_wcsStatus.dwProcessors = m_MasterSetting.nProcessors;
				nIndex = SearchNodeListIndex(m_wcsStatus.wNodeID);

				if (nIndex != -1)
				{
					m_NodeList.cs.Lock();
					m_NodeList.list[nIndex].dwProcessors = m_wcsStatus.dwProcessors;
					m_NodeList.cs.Unlock();
					m_wndMasterView.SetNodeProcessors(m_wcsStatus.wNodeID, m_wcsStatus.dwProcessors);
				}
			}
		}
	}
	else
	{
		CSlaveSettingDlg dlg;
		CByteArray data;
		TCP_DATA   tData;

		dlg.SetSetting(m_SlaveSetting);

		if (dlg.DoModal() == IDOK)
		{
			dlg.GetSetting(m_SlaveSetting);

			if (m_wcsStatus.dwProcessors != m_SlaveSetting.nProcessors)
			{
				m_wcsStatus.dwProcessors = m_SlaveSetting.nProcessors;
				m_wndSlaveView.SetProcessors(m_wcsStatus.dwProcessors);

				ZeroMemory(&tData, TCPHDR_SIZE);
				tData.wMsgType	   = WCS_MSG_CHANGE_PROCESSOR_COUNT;
				tData.wSrcNodeType = WCS_NODE_SLAVE;
				tData.wDstNodeType = WCS_NODE_MASTER;
				tData.wSrcNodeID   = m_wcsStatus.wNodeID;
				tData.wDstNodeID   = WCS_MASTER_NODE_ID;
				tData.dwOption	   = m_wcsStatus.dwProcessors;
				tData.dwDataSize   = 0;

				data.SetSize(TCPHDR_SIZE);
				CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
				m_pClientSocket->Send(data);
			}
		}
	}
}

void CWinCSDlg::OnRefreshNodeList()
{

}

void CWinCSDlg::OnMasterExecute()
{
	CEXEConfirmDlg dlg;
	NodeDataList   list;
	CByteArray     arg;
	TCP_DATA	   tData;
	CALCSIZE	   size;
	CString        cs, csArg;
	BOOL		   fSystem;

	if (m_wcsStatus.wNodeState == WCS_STATE_EXECUTING && IsWindow(m_APIWnd.Graphics.m_hWnd))
	{
		m_APIWnd.Graphics.SetForegroundWindow();
		return;
	}

	if (m_PluginList.list.GetSize() > 0)
	{
		m_NodeList.cs.Lock();
		list.Copy(m_NodeList.list);
		m_NodeList.cs.Unlock();

		m_PluginList.list[m_PluginList.nSelect].obj->SetAPI(this);
		m_PluginList.list[m_PluginList.nSelect].obj->GetCalcSize(size);
		dlg.SetCalcSize(size);
		dlg.SetPlugin(m_PluginList.list[m_PluginList.nSelect].csModuleName);
		dlg.SetSlaves(m_sysStatus.dwSlaves);
		dlg.SetSystemProcessors(m_sysStatus.dwProcessors);
		dlg.SetSingleProcessors(m_wcsStatus.dwProcessors);
		
		if (dlg.DoModal() == IDOK)
		{
			fSystem = dlg.IsSystemMode();

			if (fSystem && !PluginTransfer(m_PluginList.nSelect))
			{
				cs.LoadString(IDS_WCS_ERROR_PLUGIN_TRANSFER);
				AfxMessageBox(cs);
				return;
			}

			dlg.GetCalcSize(size);
			dlg.GetArgument(csArg);

			m_TaskManager.InitDataQueue();
			m_MasterSetting.nRecvCount  = 0;
			m_MasterSetting.nTotalCount = (size.nHeight % size.nRange == 0) ?
				(size.nHeight / size.nRange) : (size.nHeight / size.nRange) + 1;

			m_APIWnd.Graphics.InitRenderingCount(m_MasterSetting.nTotalCount);
			m_APIWnd.Graphics.SetCalcSize(size);
			m_APIWnd.Graphics.SetMode(fSystem);
			m_APIWnd.Graphics.SetNodeCount(fSystem ? m_sysStatus.dwSlaves : 1);
			m_APIWnd.Graphics.SetProcessros(fSystem ? m_sysStatus.dwProcessors : m_wcsStatus.dwProcessors);
			
			StringToByteArray(csArg, arg);
			m_PluginList.fSystem = fSystem;
			m_PluginList.list[m_PluginList.nSelect].obj->SetCalcSize(size);
			m_PluginList.sw.Start();

			CStructuredException::MapSEtoCE();

			try
			{
				m_PluginList.fRunning  = TRUE;

				if (m_PluginList.list[m_PluginList.nSelect].obj->MasterInitialize(list, fSystem))
				{
					m_wcsStatus.wNodeState = WCS_STATE_EXECUTING;
					m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
					m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_EXECUTING);

					if (m_PluginList.list[m_PluginList.nSelect].obj->StartPlugin(arg))
					{
						m_PluginList.fRunning = TRUE;
						cs.Format(_T("Start plugin(%s) : (%s)\r\n>> %s"),
								  fSystem ? _T("System mode") : _T("Single mode"), GetNowTime(), 
								  m_PluginList.list[m_PluginList.nSelect].csModuleName);
						m_wndMasterView.AddConsoleText(cs);
					}
				}
			}
			catch (CStructuredException se)
			{
				m_PluginList.fRunning  = FALSE;
				m_wcsStatus.wNodeState = WCS_STATE_WAITING;
				m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
				m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_WAITING);
				se.ReportError();
			}
		}
	}
	else
	{
		cs.LoadString(IDS_WCS_ERROR_PLUGIN_EXECUTE);
		AfxMessageBox(cs);
	}
}

BOOL CWinCSDlg::OnSlaveExecute(WORD wPluginID, const CByteArray &arg)
{
	SLAVE_PLUGIN init;
	CString cs;
	int nIndex = SearchPluginIndex(wPluginID);

	if (nIndex != -1)
	{
		ZeroMemory(&init, sizeof(init));
		init.wNodeID      = m_wcsStatus.wNodeID;
		init.dwProcessors = m_wcsStatus.dwProcessors;
		init.dbRuntime	  = 0.0;

		m_PluginList.fRunning  = TRUE;
		m_wcsStatus.wNodeState = WCS_STATE_EXECUTING;
		m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
		m_wndStatusView.SelectPluginList(nIndex);
		m_wndStatusView.SetPluginInfo(m_PluginList.list[nIndex].plgInfo);
		m_wndSlaveView.SetPlugin(m_PluginList.list[nIndex].csModuleName);
		m_wndSlaveView.SetPluginRuntime(0.0);
		m_PluginList.nSelect = nIndex;
		m_PluginList.list[nIndex].obj->SetAPI(this);
		m_PluginList.sw.Start();
		
		if (m_PluginList.list[nIndex].obj->SlaveInitialize(init))
		{
			if (m_PluginList.list[nIndex].obj->StartPlugin(arg))
			{
				
				cs.Format(_T("Start plugin : (%s)\r\n>> %s"), GetNowTime(), 
						  m_PluginList.list[nIndex].csModuleName);
				m_wndSlaveView.AddConsoleText(cs);
				return TRUE;
			}
		}

		m_PluginList.fRunning = FALSE;
	}
	
	return FALSE;
}

void CWinCSDlg::OnBenchmark()
{
	CBMConfirmDlg dlg;
	CByteArray	  data;
	BM_RANKING	  br;
	DWORDList	  dwRankList;
	TCP_DATA	  tData;
	INT_PTR		  nRet;
	CString		  cs;
	DWORD		  dwRanking;
	UINT		  nSize;

	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		// Master event
		dlg.SetSlaves(m_sysStatus.dwSlaves);
		dlg.SetSystemProcessors(m_sysStatus.dwProcessors);
		dlg.SetSingleProcessors(m_wcsStatus.dwProcessors);
		nRet = dlg.DoModal();

		if (nRet == IDOK)
		{
			m_wcsStatus.wNodeState = WCS_STATE_BENCHMARKING;
			m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
			m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_BENCHMARKING);
			m_wndMasterView.ResetBenchmark();

			if (!dlg.IsSystemMode())
			{
				// Single Benchmark Test
				ZeroMemory(&m_bmSingle.bm, sizeof(m_bmSingle.bm));
				cs.Format(_T("Start Benchmark(Single) : (%s)"), GetNowTime());
				m_wndMasterView.AddConsoleText(cs);

				try
				{
					m_bmSingle.dlg = CBMSingleDlgPtr(new CBMSingleDlg());
				}
				catch (std::bad_alloc &)
				{
					TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
					m_wcsStatus.wNodeState = WCS_STATE_WAITING;
					m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
					m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_WAITING);
					return;
				}

				m_bmSingle.dlg->SetNodeType(m_wcsStatus.wNodeType);
				m_bmSingle.dlg->SetProcessors(m_wcsStatus.dwProcessors);
				nRet = m_bmSingle.dlg->DoModal();

				if (nRet == IDOK)
				{	
					m_bmSingle.bm = m_bmSingle.dlg->GetBMData();

					m_wcsStatus.wNodeState = WCS_STATE_WAITING;
					m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
					m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_WAITING);

					cs.Format(_T("Finish Benchmark(Single) : (%s)\r\n>> Score: %.4lf GFLOPS"), 
							  GetNowTime(), m_bmSingle.bm.dbRltAvg);
					m_wndMasterView.AddConsoleText(cs);
					m_wndMasterView.SetBenchmarkNodes(1);
					m_wndMasterView.SetBenchmarkScore(m_bmSingle.bm.dbRltAvg);
					m_wndMasterView.SetBenchmarkRuntime(m_bmSingle.bm.dbRuntime);
					m_wndMasterView.SetBenchmarkTestTime(GetNowTime());
				}
				else
				{
					m_wcsStatus.wNodeState = WCS_STATE_WAITING;
					m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
					m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_WAITING);
					cs.Format(_T("Cancel Benchmark(Single) : (%s)"), GetNowTime());
					m_wndMasterView.AddConsoleText(cs);
				}
			}
			else
			{
				// System Benchmark Test
				m_bmSystem.sw.Start();
				m_bmSystem.ResultIndexList.RemoveAll();
				m_bmSystem.csTestTime	  = STRING_EMPTY;
				m_bmSystem.dbRuntime	  = 0.0;
				m_bmSystem.dbScore		  = 0.0;
				m_bmSystem.dwTestCount	  = m_sysStatus.dwSlaves;	// Remove Master
				m_bmSystem.dwTestCompleted = 0;
				m_bmSystem.dwProgMax	  = m_bmSystem.dwTestCount * 10;	
				m_bmSystem.dwProgPoint	  = 0;

				m_NodeList.cs.Lock();
				nSize = m_NodeList.list.GetSize();

				for (UINT i = 0; i < nSize; i++)
				{
					ZeroMemory(&m_NodeList.list[i].bm, sizeof(m_NodeList.list[i].bm));
				}

				m_NodeList.cs.Unlock();

				cs.Format(_T("Start Benchmark(System) : (%s)"), GetNowTime());
				m_wndMasterView.AddConsoleText(cs);

				ZeroMemory(&tData, TCPHDR_SIZE);
				tData.wMsgType	   = WCS_MSG_BENCHMARK_START;
				tData.wSrcNodeType = WCS_NODE_MASTER;
				tData.wDstNodeType = WCS_NODE_SLAVE;
				tData.wSrcNodeID   = m_wcsStatus.wNodeID;
				tData.wDstNodeID   = WCS_DEFAULT_NODE_ID;
				tData.dwDataSize   = 0;

				data.SetSize(TCPHDR_SIZE);
				CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
				data.FreeExtra();
				m_pServerSocket->Broadcast(data);

				try
				{
					m_bmSystem.dlg = CBMSystemDlgPtr(new CBMSystemDlg());
				}
				catch (std::bad_alloc &)
				{
					TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
					m_wcsStatus.wNodeState = WCS_STATE_WAITING;
					m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
					m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_WAITING);
					return;
				}

				m_NodeList.cs.Lock();
				m_bmSystem.dlg->SetNodeList(m_NodeList.list);
				m_NodeList.cs.Unlock();
				nRet = m_bmSystem.dlg->DoModal();

				if (nRet == IDOK)
				{
					// Benchmark test ranking
					nSize = GetNodeCount();
					m_bmRankList.RemoveAll();
					m_NodeList.cs.Lock();
					
					for (UINT i = 0; i < nSize; i++)
					{
						if (m_NodeList.list[i].wNodeID != WCS_MASTER_NODE_ID)
						{
							br.wRanking = 0;
							br.wNodeID  = m_NodeList.list[i].wNodeID;
							br.dbScore  = m_NodeList.list[i].bm.dbRltAvg;
							m_bmRankList.Add(br);
							TRACE2("NodeID: %d - score %lf\n", br.wNodeID, br.dbScore);
						}
					}

					m_NodeList.cs.Unlock();
					
					m_bmRankList.QuickSort(FALSE);
					nSize = m_bmRankList.GetSize();

					for (UINT i = 0; i < nSize; i++)
					{
						m_bmRankList[i].wRanking = i + 1;
						// MAKELONG(low: NodeID, High: Ranking)
						dwRanking = MAKELONG(m_bmRankList[i].wNodeID, m_bmRankList[i].wRanking);
						dwRankList.Add(dwRanking);
					}

					ZeroMemory(&tData, TCPHDR_SIZE);
					tData.wMsgType	   = WCS_MSG_BENCHMARK_RANKING;
					tData.wSrcNodeType = WCS_NODE_MASTER;
					tData.wDstNodeType = WCS_NODE_SLAVE;
					tData.wSrcNodeID   = m_wcsStatus.wNodeID;
					tData.wDstNodeID   = WCS_DEFAULT_NODE_ID;
					tData.dwDataSize   = dwRankList.GetSize() * sizeof(DWORD);

					data.SetSize(TCPHDR_SIZE + tData.dwDataSize);
					CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
					CopyMemory(data.GetData() + TCPHDR_SIZE, &dwRankList[0], tData.dwDataSize);
					data.FreeExtra();
					m_pServerSocket->Broadcast(data);

					cs.Format(_T("Finish Benchmark(System) : (%s)"), GetNowTime());
					m_wndMasterView.AddConsoleText(cs);
					m_wndMasterView.SetBenchmarkNodes(m_bmSystem.dwTestCount);
					m_wndMasterView.SetBenchmarkScore(m_bmSystem.dbScore);
					m_wndMasterView.SetBenchmarkRuntime(m_bmSystem.dbRuntime);
					m_wndMasterView.SetBenchmarkTestTime(m_bmSystem.csTestTime);
				}
				else
				{
					cs.Format(_T("Cancel Benchmark(System) : (%s)"), GetNowTime());
					m_wndMasterView.AddConsoleText(cs);

					ZeroMemory(&tData, TCPHDR_SIZE);
					tData.wMsgType	   = WCS_MSG_BENCHMARK_CANCEL;
					tData.wSrcNodeType = WCS_NODE_MASTER;
					tData.wDstNodeType = WCS_NODE_SLAVE;
					tData.wSrcNodeID   = m_wcsStatus.wNodeID;
					tData.wDstNodeID   = WCS_DEFAULT_NODE_ID;
					tData.dwDataSize   = 0;

					data.SetSize(TCPHDR_SIZE);
					CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
					data.FreeExtra();
					m_pServerSocket->Broadcast(data);
				}

				m_wcsStatus.wNodeState = WCS_STATE_WAITING;
				m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
				m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_WAITING);
			}
		}
	}
	else
	{
		// Slave event
		ZeroMemory(&m_bmSingle.bm, sizeof(m_bmSingle.bm));
		cs.Format(_T("Start Benchmark : (%s)"), GetNowTime());
		m_wndSlaveView.AddConsoleText(cs);

		m_wcsStatus.wNodeState = WCS_STATE_BENCHMARKING;
		m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
		m_wndSlaveView.ResetBenchmark();

		try
		{
			m_bmSingle.dlg = CBMSingleDlgPtr(new CBMSingleDlg());
		}
		catch (std::bad_alloc &)
		{
			TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
			m_wcsStatus.wNodeState = WCS_STATE_WAITING;
			m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
			return;
		}

		m_bmSingle.dlg->SetNodeType(m_wcsStatus.wNodeType);
		m_bmSingle.dlg->SetProcessors(m_wcsStatus.dwProcessors);
		nRet = m_bmSingle.dlg->DoModal();

		if (nRet == IDOK)
		{
			ZeroMemory(&tData, TCPHDR_SIZE);
			tData.wMsgType	   = WCS_MSG_BENCHMARK_RESULT;
			tData.wSrcNodeType = WCS_NODE_SLAVE;
			tData.wDstNodeType = WCS_NODE_MASTER;
			tData.wSrcNodeID   = m_wcsStatus.wNodeID;
			tData.wDstNodeID   = WCS_MASTER_NODE_ID;
			tData.dwDataSize   = sizeof(m_bmSingle.bm);

			m_bmSingle.bm = m_bmSingle.dlg->GetBMData();
			data.SetSize(TCPHDR_SIZE + sizeof(m_bmSingle.bm));
			CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
			CopyMemory(data.GetData() + TCPHDR_SIZE, &m_bmSingle.bm, sizeof(m_bmSingle.bm));
			data.FreeExtra();
			m_pClientSocket->Send(data);

			cs.Format(_T("Finish Benchmark(Single) : (%s) \r\n>> Score: %.4lf GFLOPS"), 
					  GetNowTime(), m_bmSingle.bm.dbRltAvg);
			m_wndSlaveView.AddConsoleText(cs);
			m_wndSlaveView.SetBenchmarkScore(m_bmSingle.bm.dbRltAvg);
			m_wndSlaveView.SetBenchmarkRuntime(m_bmSingle.bm.dbRuntime);
			m_wndSlaveView.SetBenchmarkTestTime(GetNowTime());
		}

		m_wcsStatus.wNodeState = WCS_STATE_WAITING;
		m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
	}
}

void CWinCSDlg::OnStop()
{
	CByteArray data;
	TCP_DATA   tData;
	CString	   cs;

	if (m_APIWnd.Graphics.ForceClose())
	{
		m_PluginList.fRunning  = FALSE;
		m_wcsStatus.wNodeState = WCS_STATE_WAITING;
		m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
		
		cs.Format(_T("Cancel plugin : (%s) \r\n>> %s"), GetNowTime(), 
				  m_PluginList.list[m_PluginList.nSelect].csModuleName);
		m_wndMasterView.AddConsoleText(cs);
		m_wndMasterView.SetNodeState(m_wcsStatus.wNodeID, WCS_STATE_WAITING);

		if (m_APIWnd.Graphics.IsSystemMode())
		{
			ZeroMemory(&tData, TCPHDR_SIZE);
			tData.wMsgType	   = WCS_MSG_PLUGIN_CANCEL;
			tData.wSrcNodeType = WCS_NODE_MASTER;
			tData.wDstNodeType = WCS_NODE_SLAVE;
			tData.wSrcNodeID   = m_wcsStatus.wNodeID;
			tData.wDstNodeID   = WCS_DEFAULT_NODE_ID; 
			tData.dwDataSize   = 0;

			m_PluginList.cs.Lock();
			tData.dwOption = m_PluginList.list[m_PluginList.nSelect].plgInfo.wPluginID;
			m_PluginList.cs.Unlock();

			data.SetSize(TCPHDR_SIZE);
			CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
			data.FreeExtra();
			m_pServerSocket->Broadcast(data);
		}
	}
}

void CWinCSDlg::OnHelp()
{
	CAboutDlg dlg;
	dlg.DoModal();
}

void CWinCSDlg::OnTransfer()
{
	CString cs;

	if (m_PluginList.list.GetSize() > 0)
	{
		if (m_NodeList.list.GetSize() > 1)
		{
			m_PluginList.cs.Lock();
			m_dlgTransfer.SetPluginList(m_PluginList.list);
			m_PluginList.cs.Unlock();

			m_dlgTransfer.SetTargetWnd(this);
			m_dlgTransfer.DoModal();
		}
		else
		{
			cs.LoadString(IDS_WCS_ERROR_SLAVE_COUNT);
			AfxMessageBox(cs);
		}
	}
	else
	{
		cs.LoadString(IDS_WCS_ERROR_PLUGIN_LOAD);
		AfxMessageBox(cs);
	}
}

void CWinCSDlg::OnFreePlugin()
{
	CString cs;

	if (m_wcsStatus.wNodeState != WCS_STATE_EXECUTING)
	{
		if (m_wndMasterView.IsPluginLocked())
		{
			cs.LoadString(IDS_WCS_ERROR_PLUGIN_LOCKED);
			AfxMessageBox(cs);
		}
		else
		{
			FreePlugin();
		}
	}
	else
	{
		cs.LoadString(IDS_WCS_ERROR_PLUGIN_LOAD);
		AfxMessageBox(cs);
	}
}

//////////////////////////////////////////////////////////////////////////

void CWinCSDlg::OnSocketSendMessage(DWORD dwSocketID)
{

}

void CWinCSDlg::OnSocketReceiveMessage(DWORD dwSocketID, NETADDR NetAddr, const CByteArray &data)
{
	TCP_DATA tData;
	size_t	 size;

	CopyMemory(&tData, data.GetData(), TCPHDR_SIZE);

	if (data.GetSize() > TCPHDR_SIZE)
	{
		size = data.GetSize() - TCPHDR_SIZE;
		tData.data.SetSize(size);
		CopyMemory(tData.data.GetData(), (data.GetData() + TCPHDR_SIZE), size);
		tData.data.FreeExtra();
	}

	if (dwSocketID == WCS_SOCKID_STREAM_SERVER)
	{
		// ServerSocket message
		ServerReceiveMsgTransaction(tData, NetAddr);
	}
	else
	{
		// ClientSocket message
		ClientReceiveMsgTransaction(tData, NetAddr);
	}
}

void CWinCSDlg::OnSocketReceiveFromMessage(DWORD dwSocketID, NETADDR NetAddr, const CByteArray &data)
{
	UDP_DATA uData;

	CopyMemory(&uData, data.GetData(), sizeof(uData));

	if (dwSocketID == WCS_SOCKID_PEER_SERVER)
	{
		ServerPeerMsgTransaction(uData, NetAddr);
	}
	else
	{
		ClientPeerMsgTransaction(uData, NetAddr);
	}
}

void CWinCSDlg::OnSocketAcceptMessage(DWORD dwSocketID, NETADDR NetAddr)
{
	ServerAcceptMsgTransaction(NetAddr);
}

void CWinCSDlg::OnSocketConnectMessage(DWORD dwSocketID)
{

}

void CWinCSDlg::OnSocketCloseMessage(DWORD dwSocketID, NETADDR NetAddr)
{
	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		ServerCloseMsgTransaction(NetAddr);
	}
	else
	{
		ClientCloseMsgTransaction();
	}
}

//////////////////////////////////////////////////////////////////////////

void CWinCSDlg::ServerPeerMsgTransaction(const UDP_DATA &uData, NETADDR NetAddr)
{
	CByteArray data;
	UDP_DATA   uReply;
	SOCKADDR   SockAddr;
	int nLenSA = sizeof(SOCKADDR);

	ZeroMemory(&uReply, sizeof(uReply));
	data.SetSize(sizeof(UDP_DATA));
	data.FreeExtra();

	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		// Master
		switch (uData.wMsgType)
		{
		case WCS_MSG_MASTER_DISCOVER:
			uReply.wMsgType	    = WCS_MSG_MASTER_OFFER;
			uReply.wSrcNodeType = WCS_NODE_MASTER;
			uReply.wDstNodeType = WCS_NODE_SLAVE;
			uReply.wSrcNodeID   = m_wcsStatus.wNodeID;
			uReply.wDstNodeID   = WCS_DEFAULT_NODE_ID;
			CopyMemory(data.GetData(), &uReply, data.GetSize());
			MakeSockAddr(&SockAddr, NetAddr.dwAddress, NetAddr.wPort);
			m_pServerPeerSocket->SendTo(data, &SockAddr, nLenSA);
			break;
		}
	}
}

void CWinCSDlg::ClientPeerMsgTransaction(const UDP_DATA &uData, NETADDR NetAddr)
{
}

void CWinCSDlg::ServerReceiveMsgTransaction(const TCP_DATA &tData, NETADDR NetAddr)
{
	BM_SYSTEMSCORE bmScore;
	CByteArray data;
	NODE_DATA  nd;
	TCP_DATA   tReply;
	CString    cs1, cs2;
	BM_DATA	   bm;
	DWORD	   dwProgPoint, dwProgMax;
	UINT	   nSize;
	int		   nIndex, nPoint, nProcessors;

	switch (tData.wMsgType)
	{
	case WCS_MSG_MASTER_ACCEPT_ACK:
		ZeroMemory(&nd, sizeof(nd));
		nd.dwAddress    = NetAddr.dwAddress;
		nd.wPort	    = NetAddr.wPort;
		nd.wNodeID	    = tData.wSrcNodeID;
		nd.wNodeType    = tData.wSrcNodeType;
		nd.wNodeState   = WCS_STATE_WAITING;
		nd.dwProcessors = tData.dwOption;
		AddNodeList(nd);
		m_wndMasterView.AddNodeList(nd);
		cs1.Format(_T("The Slave(%d) has been connected : (%s)\r\n>> %s"), tData.wSrcNodeID,
				   GetNowTime(), DwToIPAddress(NetAddr.dwAddress));
		m_wndMasterView.AddConsoleText(cs1);
		break;


	case WCS_MSG_BENCHMARK_START_ACK:
		nIndex = SearchNodeListIndex(tData.wSrcNodeID);

		if (nIndex != -1)
		{
			CSingleLock sl(&m_NodeList.cs, TRUE);
			m_NodeList.list[nIndex].wNodeState = WCS_STATE_BENCHMARKING;
			m_wndMasterView.SetNodeState(tData.wSrcNodeID, WCS_STATE_BENCHMARKING);
			cs1.Format(_T("Start Benchmark - Slave(%d) : (%s)"),
					   tData.wSrcNodeID, GetNowTime());
			m_wndMasterView.AddConsoleText(cs1);
		}
		break;


	case WCS_MSG_BENCHMARK_CANCEL_ACK:
		nIndex = SearchNodeListIndex(tData.wSrcNodeID);

		if (nIndex != -1)
		{
			CSingleLock sl(&m_NodeList.cs, TRUE);
			m_NodeList.list[nIndex].wNodeState = WCS_STATE_WAITING;
			m_wndMasterView.SetNodeState(tData.wSrcNodeID, WCS_STATE_WAITING);
			cs1.Format(_T("Cancel Benchmark - Slave(%d) : (%s)"),
					   tData.wSrcNodeID, GetNowTime());
			m_wndMasterView.AddConsoleText(cs1);
		}
		break;


	case WCS_MSG_PLUGIN_START_ACK:
		nIndex = SearchNodeListIndex(tData.wSrcNodeID);

		if (nIndex != -1)
		{
			m_NodeList.cs.Lock();
			m_NodeList.list[nIndex].wNodeState = WCS_STATE_EXECUTING;
			m_NodeList.cs.Unlock();
			m_wndMasterView.SetNodeState(tData.wSrcNodeID, WCS_STATE_EXECUTING);
		}
		break;


	case WCS_MSG_PLUGIN_RAWDATA_ACK:
		break;


	case WCS_MSG_BENCHMARK_RESULT:
		nIndex = SearchNodeListIndex(tData.wSrcNodeID);

		if (nIndex != -1)
		{
			SendAckToSlave(tData.wSrcNodeID, WCS_MSG_BENCHMARK_RESULT_ACK);
			
			m_NodeList.cs.Lock();
			m_NodeList.list[nIndex].wNodeState = WCS_STATE_WAITING;
			m_wndMasterView.SetNodeState(tData.wSrcNodeID, WCS_STATE_WAITING);
			CopyMemory(&bm, tData.data.GetData(), sizeof(bm));
			m_NodeList.list[nIndex].bm = bm;
			m_NodeList.list[nIndex].bm.fSet = TRUE;
			m_NodeList.cs.Unlock();

			m_bmSystem.dlg->SetTestScore(tData.wSrcNodeID, bm);
			cs1.Format(_T("Score of Benchmark - Slave(%d) : (%s)\r\n>> %.4lf GFLOPS"), 
					   tData.wSrcNodeID, GetNowTime(), bm.dbRltAvg);
			m_wndMasterView.AddConsoleText(cs1);

			m_bmSystem.ResultIndexList.Add(nIndex);
			m_bmSystem.dbScore += bm.dbRltAvg;
			m_bmSystem.dwTestCompleted += 1;

			if (m_bmSystem.dwTestCount == m_bmSystem.dwTestCompleted)
			{
				ZeroMemory(&bmScore, sizeof(bmScore));
				bmScore.dbTotal = m_bmSystem.dbScore;
				bmScore.dbAvg	= m_bmSystem.dbScore / m_bmSystem.dwTestCount;
				bmScore.dbHigh  = 0.0;
				bmScore.dbLow	= static_cast<double>(INT_MAX);
				nSize = m_NodeList.list.GetSize();

				for (UINT i = 1; i < nSize; i++)
				{
					if (m_NodeList.list[i].bm.fSet)
					{
						bmScore.dbHigh = max(bmScore.dbHigh, m_NodeList.list[i].bm.dbRltAvg);
						bmScore.dbLow  = min(bmScore.dbLow, m_NodeList.list[i].bm.dbRltAvg);
					}
				}

				m_bmSystem.dbRuntime  = m_bmSystem.sw.NowBySecond();
				m_bmSystem.csTestTime = GetNowTime();
				SaveBenchmarkReport(cs1);
				m_bmSystem.dlg->SetSystemScore(bmScore, cs1);
			}
		}
		break;


	case WCS_MSG_BENCHMARK_PROGRESS:
		if (tData.dwOption > 0)
		{
			m_bmSystem.dwProgPoint += 1;
			nPoint = (m_bmSystem.dwProgPoint * 100 / m_bmSystem.dwProgMax);
			dwProgPoint = m_bmSystem.dwProgPoint;
			dwProgMax = m_bmSystem.dwProgMax;
			m_bmSystem.dlg->SetProgressPoint(tData.wSrcNodeID, tData.dwOption * 10);
			m_bmSystem.dlg->SetProgress(nPoint);
		}
		break;


	case WCS_MSG_PLAINTEXT:
		data.SetSize(tData.dwDataSize);
		CopyMemory(data.GetData(), tData.data.GetData(), tData.dwDataSize);
		ByteArrayToString(data, cs1);
		cs2.Format(_T("Message from the Slave(%d) : (%s)\r\n>> %s"),
				   tData.wSrcNodeID, GetNowTime(), cs1);
		m_wndMasterView.AddConsoleText(cs2);
		break;


	case WCS_MSG_PLUGIN_RAWDATA:
		if (m_wcsStatus.wNodeState == WCS_STATE_EXECUTING)
		{
			SendAckToSlave(tData.wSrcNodeID, WCS_MSG_PLUGIN_RAWDATA_ACK);
			m_APIWnd.Graphics.AddRenderingCount();

			if (m_MasterSetting.fRtRendering)
			{
				m_PluginList.list[m_PluginList.nSelect].obj->ReceiveCallBack(tData.data);
			}
			else
			{
				m_TaskManager.DataEnqueue(tData.data);
				m_MasterSetting.nRecvCount++;

				if (m_MasterSetting.nRecvCount == m_MasterSetting.nTotalCount)
				{
					while (TRUE)
					{
						if (m_TaskManager.DataDequeue(data))
						{
							m_PluginList.list[m_PluginList.nSelect].obj->ReceiveCallBack(data);
						}
						else
						{
							break;
						}
					}
				}
			}
		}
		break;


	case WCS_MSG_CHANGE_PROCESSOR_COUNT:
		nIndex = SearchNodeListIndex(tData.wSrcNodeID);

		if (nIndex != -1)
		{
			m_NodeList.cs.Lock();
			nProcessors = static_cast<int>(m_NodeList.list[nIndex].dwProcessors);
			m_NodeList.list[nIndex].dwProcessors = tData.dwOption;
			nProcessors = static_cast<int>(tData.dwOption) - nProcessors;
			m_NodeList.cs.Unlock();
			m_sysStatus.dwProcessors = m_sysStatus.dwProcessors + nProcessors;
			m_wndMasterView.SetNodeProcessors(tData.wSrcNodeID, tData.dwOption);
			m_wndMasterView.SetProcessors(m_sysStatus.dwProcessors);
		}
		break;


	case WCS_MSG_PLUGIN_STOP:
	case WCS_MSG_PLUGIN_CANCEL_ACK:
		nIndex = SearchNodeListIndex(tData.wSrcNodeID);

		if (nIndex != -1)
		{
			m_NodeList.cs.Lock();
			m_NodeList.list[nIndex].wNodeState = WCS_STATE_WAITING;
			m_NodeList.cs.Unlock();
			m_wndMasterView.SetNodeState(tData.wSrcNodeID, WCS_STATE_WAITING);
		}
		break;
	}
}

void CWinCSDlg::ClientReceiveMsgTransaction(const TCP_DATA &tData, NETADDR NetAddr)
{
	CByteArray data;
	TRANSFER   tf;
	CString	   cs1, cs2, csPath;
	HANDLE	   hFile;
	DWORD	   dwRanking, dwStrSize, dwWriteSize, dwTimeout;
	WORD	   wPluginID;
	UINT	   nSize;
	int		   nRet, nLenSA = sizeof(SOCKADDR);

	switch (tData.wMsgType)
	{
	case WCS_MSG_MASTER_ACCEPT:
		m_wcsStatus.wNodeID   = tData.wDstNodeID;
		m_wcsStatus.wNodeType = WCS_NODE_SLAVE;
		SendAckToMaster(WCS_MSG_MASTER_ACCEPT_ACK, m_wcsStatus.dwProcessors);
		m_wndStatusView.SetNodeID(m_wcsStatus.wNodeID);
		cs1.Format(_T("Connected to the Master : (%s)\r\n>> %s"), 
				   GetNowTime(), DwToIPAddress(NetAddr.dwAddress));
		m_wndSlaveView.AddConsoleText(cs1);
		break;


	case WCS_MSG_BENCHMARK_START:
		SendAckToMaster(WCS_MSG_BENCHMARK_START_ACK);
		OnBenchmark();
		break;


	case WCS_MSG_BENCHMARK_CANCEL:
		if (m_wcsStatus.wNodeState == WCS_STATE_BENCHMARKING)
		{
			m_bmSingle.dlg->CancelBenchmarkTest();
			cs1.Format(_T("Cancel Benchmark : (%s)"), GetNowTime());
			m_wndSlaveView.AddConsoleText(cs1);
			SendAckToMaster(WCS_MSG_BENCHMARK_CANCEL_ACK);
		}
		break;


	case WCS_MSG_BENCHMARK_RANKING:
		nSize = tData.dwDataSize / sizeof(DWORD);

		for (UINT i = 0; i < nSize; i++)
		{
			CopyMemory(&dwRanking, tData.data.GetData() + (sizeof(DWORD) * i), sizeof(DWORD));

			if (LOWORD(dwRanking) == m_wcsStatus.wNodeID)
			{
				m_wndSlaveView.SetBenchmarkRanking(HIWORD(dwRanking), nSize);
				break;
			}
		}
		break;


	case WCS_MSG_PLAINTEXT:
		data.SetSize(tData.dwDataSize);
		CopyMemory(data.GetData(), tData.data.GetData(), tData.dwDataSize);
		ByteArrayToString(data, cs1);
		cs2.Format(_T("Message from the Master : (%s)\r\n>> %s"), GetNowTime(), cs1);
		m_wndSlaveView.AddConsoleText(cs2);
		break;


	case WCS_MSG_PLUGIN_RAWDATA:
		if (m_wcsStatus.wNodeState == WCS_STATE_EXECUTING)
		{
			SendAckToMaster(WCS_MSG_PLUGIN_RAWDATA_ACK);
			m_PluginList.cs.Lock();
			m_PluginList.list[m_PluginList.nSelect].obj->ReceiveCallBack(tData.data);
			m_PluginList.cs.Unlock();
		}
		break;


	case WCS_MSG_PLUGIN_RAWDATA_ACK:
		break;


	case WCS_MSG_PLUGIN_START:
		if (m_wcsStatus.wNodeState == WCS_STATE_WAITING)
		{
			wPluginID = static_cast<WORD>(tData.dwOption);

			if (OnSlaveExecute(wPluginID, tData.data))
			{
				SendAckToMaster(WCS_MSG_PLUGIN_START_ACK);
			}
		}
		break;


	case WCS_MSG_PLUGIN_CANCEL:
		if (m_wcsStatus.wNodeState == WCS_STATE_EXECUTING)
		{
			wPluginID = static_cast<WORD>(tData.dwOption);
			m_PluginList.fRunning = FALSE;

			if (m_PluginList.list[m_PluginList.nSelect].plgInfo.wPluginID == wPluginID)
			{
				dwTimeout = m_PluginList.list[m_PluginList.nSelect].plgInfo.dwTimeout;

				if (m_PluginList.list[m_PluginList.nSelect].obj->CancelPlugin(dwTimeout))
				{
					SendAckToMaster(WCS_MSG_PLUGIN_CANCEL_ACK);
					m_wcsStatus.wNodeState = WCS_STATE_WAITING;
					m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);

					cs1.Format(_T("Cancel plugin : (%s) \r\n>> %s"), GetNowTime(), 
							   m_PluginList.list[m_PluginList.nSelect].csModuleName);
					m_wndSlaveView.AddConsoleText(cs1);
					m_wndSlaveView.CancelPlugin();
				}
			}
		}
		break;


	case WCS_MSG_PLUGIN_TRANSFER:
		if (m_wcsStatus.wNodeState == WCS_STATE_WAITING)
		{
			CopyMemory(&tf.dwFileSize, tData.data.GetData(), sizeof(tf.dwFileSize));
			dwStrSize = sizeof(TCHAR) * _MAX_FNAME;
			CopyMemory(tf.szFileName, tData.data.GetData() + sizeof(tf.dwFileSize), dwStrSize);
			tf.data.SetSize(tf.dwFileSize);
			CopyMemory(tf.data.GetData(), tData.data.GetData() + sizeof(tf.dwFileSize) + dwStrSize, tf.dwFileSize);
			csPath.Format(_T("./Plugin/%s"), tf.szFileName);

			if (!m_SlaveSetting.fAutoDownload)
			{
				cs1.LoadStringW(IDS_WCS_TEXT_PLUGIN_DOWNLOAD_CONFIRM);
				cs2.Format(_T("%s\r\nPlugin: %s"), cs1, tf.szFileName);
				nRet = CMsgBox::Question(MC_CStoSTR(cs2), _T("Plugin download"), m_hWnd);

				if (nRet == IDNO)
				{
					return;
				}
			}
			
			FreePlugin();

			hFile = CreateFile(csPath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
							   FILE_ATTRIBUTE_NORMAL, NULL);

			if (hFile != INVALID_HANDLE_VALUE)
			{
				WriteFile(hFile, tf.data.GetData(), tf.dwFileSize, &dwWriteSize, NULL);
				CloseHandle(hFile);
				cs1.Format(_T("Update plugin : (%s)\r\n>> %s"), GetNowTime(), tf.szFileName);
				m_wndSlaveView.AddConsoleText(cs1);
			}

			LoadPlugin();
		}
		break;
	}
}

void CWinCSDlg::ServerAcceptMsgTransaction(NETADDR NetAddr)
{
	CByteArray data;
	TCP_DATA   tData;

	ZeroMemory(&tData, TCPHDR_SIZE);
	tData.wMsgType	   = WCS_MSG_MASTER_ACCEPT;
	tData.wSrcNodeType = WCS_NODE_MASTER;
	tData.wDstNodeType = WCS_NODE_SLAVE;
	tData.wSrcNodeID   = m_wcsStatus.wNodeID;	// Master(0)
	tData.wDstNodeID   = ++m_sysStatus.wNodeIndex;
	tData.dwDataSize   = 0;
	
	data.SetSize(TCPHDR_SIZE);
	CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);

#ifdef _DEBUG
	if (!m_pServerSocket->SendToClient(data, NetAddr.dwAddress, NetAddr.wPort))
	{
		TRACE0("***** ERROR: ServerAcceptMsgTransaction *****\n");
	}
#else
	m_pServerSocket->SendToClient(data, NetAddr.dwAddress, NetAddr.wPort);
#endif
}

void CWinCSDlg::ServerCloseMsgTransaction(NETADDR NetAddr)
{
	CString cs;
	WORD wNodeID = SearchNodeID(NetAddr.dwAddress, NetAddr.wPort);
	
	if (wNodeID != WCS_DEFAULT_NODE_ID)
	{
		RemoveNodeList(wNodeID);
		cs.Format(_T("The Slave(%d) has been disconnected : (%s)\r\n>> %s"), 
				  wNodeID, GetNowTime(), DwToIPAddress(NetAddr.dwAddress));
		m_wndMasterView.RemoveNodeList(wNodeID);
		m_wndMasterView.AddConsoleText(cs);
	}
}

void CWinCSDlg::ClientCloseMsgTransaction()
{
	CString cs;

	m_wcsStatus.dwMasterAddress = 0;
	m_wcsStatus.wNodeID	   = WCS_DEFAULT_NODE_ID;
	m_wcsStatus.wNodeType  = WCS_NODE_UNDEFINED;
	m_wcsStatus.wNodeState = WCS_STATE_WAITING;
	m_wndStatusView.ResetMasterAddress();
	m_wndStatusView.ResetNodeID();
	m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);

	// Automatic exit settings
	CreateTimerQueueTimer(&m_hSlaveExit, NULL, doAutoExitTimer, this, WCS_SLAVE_AUTOEXIT_TIME, 1000, 0);

	cs.LoadString(IDS_WCS_TEXT_MASTER_DISCONNECTED);
	CMsgBox::Information(MC_CStoSTR(cs), _T("WinCS Exit"), m_hWnd);

	DeleteTimerQueueTimer(NULL, m_hSlaveExit, NULL);

	if (m_wcsStatus.wNodeState == WCS_STATE_WAITING)
	{
		EndDialog(IDOK);
	}
}

//////////////////////////////////////////////////////////////////////////

UINT CWinCSDlg::GetNodeCount()
{
	return static_cast<UINT>(m_NodeList.list.GetSize());
}

void CWinCSDlg::AddNodeList(NODE_DATA nd)
{
	CSingleLock sl(&m_NodeList.cs, TRUE);
	m_NodeList.list.Add(nd);
	++m_sysStatus.dwSlaves;
	m_sysStatus.dwProcessors += nd.dwProcessors;
	m_wndMasterView.SetSlaves(m_sysStatus.dwSlaves);
	m_wndMasterView.SetProcessors(m_sysStatus.dwProcessors);

	if (m_sysStatus.dwSlaves >= m_MasterSetting.nConnections)
	{
		m_pServerSocket->SetAccept(FALSE);
	}
}

BOOL CWinCSDlg::RemoveNodeList(WORD wNodeID)
{
	int nIndex = SearchNodeListIndex(wNodeID);

	if (nIndex != -1)
	{
		CSingleLock sl(&m_NodeList.cs, TRUE);
		--m_sysStatus.dwSlaves;
		m_sysStatus.dwProcessors -= m_NodeList.list[nIndex].dwProcessors;
		m_wndMasterView.SetSlaves(m_sysStatus.dwSlaves);
		m_wndMasterView.SetProcessors(m_sysStatus.dwProcessors);
		m_NodeList.list.RemoveAt(nIndex);

		if (m_sysStatus.dwSlaves < m_MasterSetting.nConnections)
		{
			m_pServerSocket->SetAccept(TRUE);
		}

		return TRUE;
	}

	return FALSE;
}

void CWinCSDlg::RemoveAllNodeList()
{
	CSingleLock sl(&m_NodeList.cs, TRUE);
	m_NodeList.list.RemoveAll();
	m_sysStatus.dwSlaves = 0;
	m_sysStatus.dwProcessors = 0;
	m_wndMasterView.SetSlaves(m_sysStatus.dwSlaves);
	m_wndMasterView.SetProcessors(m_sysStatus.dwProcessors);
	m_pServerSocket->SetAccept(TRUE);
}

int CWinCSDlg::SearchNodeListIndex(WORD wNodeID)
{
	CSingleLock sl(&m_NodeList.cs, TRUE);
	UINT nSize  = GetNodeCount();
	int  nIndex = -1;

	for (UINT i = 0; i < nSize; i++)
	{
		if (m_NodeList.list[i].wNodeID == wNodeID)
		{
			nIndex = i;
			break;
		}
	}

	return nIndex;
}

WORD CWinCSDlg::SearchNodeID(DWORD dwAddress, WORD wPort)
{
	CSingleLock sl(&m_NodeList.cs, TRUE);
	WORD wNodeID = WCS_DEFAULT_NODE_ID;
	UINT nSize	 = GetNodeCount();

	for (UINT i = 0; i < nSize; i++)
	{
		if ((m_NodeList.list[i].dwAddress == dwAddress) &&
			(m_NodeList.list[i].wPort == wPort))
		{
			wNodeID = m_NodeList.list[i].wNodeID;
			break;
		}
	}

	return wNodeID;
}

DWORD CWinCSDlg::GetSAddrBySockAddr(const LPSOCKADDR lpSockAddr)
{
	SOCKADDR_IN siAddr;
	CopyMemory(&siAddr, lpSockAddr, sizeof(siAddr));
	return siAddr.sin_addr.s_addr;
}

WORD CWinCSDlg::GetPortBySockAddr(const LPSOCKADDR lpSockAddr)
{
	SOCKADDR_IN siAddr;
	CopyMemory(&siAddr, lpSockAddr, sizeof(siAddr));
	return ntohs(siAddr.sin_port);
}

//////////////////////////////////////////////////////////////////////////

BOOL CWinCSDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	//////////////////////////////////////////////////////////////////////////

	// GDI+ Initialization
	Gdiplus::GdiplusStartupInput gdiplusStartupInput;
	Gdiplus::GdiplusStartup(&m_ulpGdiToken, &gdiplusStartupInput, NULL);

	// Initialization
	//CWinCSSetupDlg *pdlg;
	CWinCSSetupDlgPtr pdlg;
	NODE_DATA nd;
	CNetwork  net;
	IPv4	  ipv4List[WCS_MAX_NETSIZE];
	TBITEM	  tbItem[8];
	CString   cs, csLoad;
	CString   csTbName[8];
	DWORD	  dwSize = 0;
	INT_PTR   nRet = -1;
	CRect	  cr;
	int		  nTbSize;

	m_sysStatus.wNodeIndex	 = 0;
	m_sysStatus.dwSlaves	 = 0;
	m_sysStatus.dwProcessors = 0;

	if (!CreateWcsDirectory())
	{
		TRACE1("***** ERROR: CreateWcsDirectory(%d)\n", GetLastError());
		cs.LoadString(IDS_WCS_ERROR_CREATE_DIRECTORY);
		AfxMessageBox(cs);
		return EndDialog(IDCANCEL), FALSE;
	}

	if (!net.GetIPv4List(dwSize, WCS_MAX_NETSIZE, ipv4List))
	{
		TRACE1("***** ERROR: GetIPv4List(%d)\n", GetLastError());
		cs.LoadString(IDS_WCS_ERROR_GET_LOCAL_ADDRESS);
		AfxMessageBox(cs);
		return EndDialog(IDCANCEL), FALSE;
	}

	// Set WinCS status
	SetWcsStatus();

	try
	{
		pdlg = CWinCSSetupDlgPtr(new CWinCSSetupDlg());
	}
	catch (std::bad_alloc &)
	{
		TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
		return EndDialog(IDCANCEL), FALSE;
	}

	CopyMemory(pdlg->m_IPv4List, ipv4List, sizeof(pdlg->m_IPv4List));
	pdlg->m_dwListSize = dwSize;

	while (TRUE)
	{
		pdlg->SetWcsStatus(m_wcsStatus);
		nRet = pdlg->DoModal();

		if (nRet == IDOK)
		{
			pdlg->GetWcsStatus(m_wcsStatus);

			if (!ClientPeerSocketInitialize())
			{
				return EndDialog(IDCANCEL), FALSE;
			}

			if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
			{
				// Master
				if (StartMaster())
				{
					break;
				}
			}
			else
			{
				// Slave
				if (StartSlave())
				{
					break;
				}
			}
		}
		else
		{
			return EndDialog(IDCANCEL), FALSE;
		}
	}

	// Save settings
	SaveWcsSettings();

	// Status view setting
	if (!m_wndStatusView.Create(CStatusView::IDD, this))
	{
		TRACE1("***** ERROR: StatusView create(%d)\n", GetLastError());
		return EndDialog(IDCANCEL), FALSE;
	}

	m_wndStatusView.GetClientRect(&cr);
	cr.OffsetRect(0, 50);
	m_wndStatusView.MoveWindow(&cr, FALSE);
	m_wndStatusView.ShowWindow(SW_SHOW);

	if (m_wcsStatus.wNodeType == WCS_NODE_SLAVE)
	{
		// Slave view setting
		m_SlaveSetting.fAutoDownload = TRUE;
		m_SlaveSetting.nProcessors   = m_wcsStatus.dwProcessors;

		if (!m_wndSlaveView.Create(CSlaveView::IDD, this))
		{
			TRACE1("***** ERROR: SlaveView create(%d)\n", GetLastError());
			return EndDialog(IDCANCEL), FALSE;
		}

		m_wndSlaveView.GetClientRect(&cr);
		cr.OffsetRect(250, 50);
		m_wndSlaveView.MoveWindow(&cr, FALSE);
		m_wndSlaveView.ShowWindow(SW_SHOW);

		// Tool bar
		csTbName[0].LoadString(IDT_TB_RESTART);
		tbItem[0].nIndex   = 0;
		tbItem[0].nImageID = IDB_TB_RESTART;
		tbItem[0].nInfoID  = IDT_TB_RESTART;
		tbItem[0].crMask   = RGB(255, 255, 255);
		tbItem[0].nStyle   = TBBS_BUTTON;
		tbItem[0].lpText   = MC_CStoSTR(csTbName[0]);

		csTbName[1].LoadString(IDT_TB_SETTING);
		tbItem[1].nIndex   = 1;
		tbItem[1].nImageID = IDB_TB_SETTING;
		tbItem[1].nInfoID  = IDT_TB_SETTING;
		tbItem[1].crMask   = RGB(255, 255, 255);
		tbItem[1].nStyle   = TBBS_BUTTON;
		tbItem[1].lpText   = MC_CStoSTR(csTbName[1]);

		csTbName[2].LoadString(IDT_TB_LOG);
		tbItem[2].nIndex   = 2;
		tbItem[2].nImageID = IDB_TB_LOG;
		tbItem[2].nInfoID  = IDT_TB_LOG;
		tbItem[2].crMask   = RGB(255, 255, 255);
		tbItem[2].nStyle   = TBBS_BUTTON;
		tbItem[2].lpText   = MC_CStoSTR(csTbName[2]);

		csTbName[3].LoadString(IDT_TB_INFORMATION);
		tbItem[3].nIndex   = 3;
		tbItem[3].nImageID = IDB_TB_INFORMATION;
		tbItem[3].nInfoID  = IDT_TB_INFORMATION;
		tbItem[3].crMask   = RGB(255, 255, 255);
		tbItem[3].nStyle   = TBBS_BUTTON;
		tbItem[3].lpText   = MC_CStoSTR(csTbName[3]);

		// ToolBar size
		nTbSize = 4;

		// Unable Plugin reload button
		m_wndStatusView.SetReloadBtn(FALSE);

		// Remove menu
		GetMenu()->GetSubMenu(1)->RemoveMenu(IDM_TOOL_EXECUTE, MF_BYCOMMAND);
		GetMenu()->GetSubMenu(1)->RemoveMenu(IDM_TOOL_STOP, MF_BYCOMMAND);
		GetMenu()->GetSubMenu(1)->RemoveMenu(IDM_TOOL_BENCHMARK, MF_BYCOMMAND);
		GetMenu()->GetSubMenu(1)->RemoveMenu(IDM_TOOL_TRANSFER, MF_BYCOMMAND);
		GetMenu()->GetSubMenu(1)->RemoveMenu(IDM_TOOL_FREE_PLUGIN, MF_BYCOMMAND);
		GetMenu()->GetSubMenu(1)->RemoveMenu(IDM_TOOL_REFRESH_NODE_LIST, MF_BYCOMMAND);
		GetMenu()->GetSubMenu(1)->RemoveMenu(3, MF_BYPOSITION);
	}
	else
	{
		// Master
		m_wcsStatus.wNodeID = 0;
		m_MasterSetting.fInternet	  = TRUE;
		m_MasterSetting.fRtRendering  = TRUE;
		m_MasterSetting.fLogPlugin	  = TRUE;
		m_MasterSetting.nConnections  = UINT_MAX;
		m_MasterSetting.nProcessors   = m_wcsStatus.dwProcessors;
		m_MasterSetting.nTotalCount	  = 0;
		m_MasterSetting.nRecvCount	  = 0;

		// Master view setting
		if (!m_wndMasterView.Create(CMasterView::IDD, this))
		{
			TRACE1("***** ERROR: MasterView create(%d)\n", GetLastError());
			return EndDialog(IDCANCEL), FALSE;
		}

		m_wndMasterView.GetClientRect(&cr);
		cr.OffsetRect(250, 50);
		m_wndMasterView.MoveWindow(&cr, FALSE);
		m_wndMasterView.ShowWindow(SW_SHOW);

		// Tool bar
		csTbName[0].LoadString(IDT_TB_EXECUTE);
		tbItem[0].nIndex   = 0;
		tbItem[0].nImageID = IDB_TB_EXECUTE;
		tbItem[0].nInfoID  = IDT_TB_EXECUTE;
		tbItem[0].crMask   = RGB(255, 255, 255);
		tbItem[0].nStyle   = TBBS_BUTTON;
		tbItem[0].lpText   = MC_CStoSTR(csTbName[0]);

		csTbName[1].LoadString(IDT_TB_STOP);
		tbItem[1].nIndex   = 1;
		tbItem[1].nImageID = IDB_TB_STOP;
		tbItem[1].nInfoID  = IDT_TB_STOP;
		tbItem[1].crMask   = RGB(255, 255, 255);
		tbItem[1].nStyle   = TBBS_BUTTON;
		tbItem[1].lpText   = MC_CStoSTR(csTbName[1]);

		csTbName[2].LoadString(IDT_TB_RESTART);
		tbItem[2].nIndex   = 2;
		tbItem[2].nImageID = IDB_TB_RESTART;
		tbItem[2].nInfoID  = IDT_TB_RESTART;
		tbItem[2].crMask   = RGB(255, 255, 255);
		tbItem[2].nStyle   = TBBS_BUTTON;
		tbItem[2].lpText   = MC_CStoSTR(csTbName[2]);

		csTbName[3].LoadString(IDT_TB_BENCHMARK);
		tbItem[3].nIndex   = 3;
		tbItem[3].nImageID = IDB_TB_BENCHMARK;
		tbItem[3].nInfoID  = IDT_TB_BENCHMARK;
		tbItem[3].crMask   = RGB(255, 255, 255);
		tbItem[3].nStyle   = TBBS_BUTTON;
		tbItem[3].lpText   = MC_CStoSTR(csTbName[3]);

		csTbName[4].LoadString(IDT_TB_SETTING);
		tbItem[4].nIndex   = 4;
		tbItem[4].nImageID = IDB_TB_SETTING;
		tbItem[4].nInfoID  = IDT_TB_SETTING;
		tbItem[4].crMask   = RGB(255, 255, 255);
		tbItem[4].nStyle   = TBBS_BUTTON;
		tbItem[4].lpText   = MC_CStoSTR(csTbName[4]);

		csTbName[5].LoadString(IDT_TB_LOG);
		tbItem[5].nIndex   = 5;
		tbItem[5].nImageID = IDB_TB_LOG;
		tbItem[5].nInfoID  = IDT_TB_LOG;
		tbItem[5].crMask   = RGB(255, 255, 255);
		tbItem[5].nStyle   = TBBS_BUTTON;
		tbItem[5].lpText   = MC_CStoSTR(csTbName[5]);

		csTbName[6].LoadString(IDT_TB_TRANSFER);
		tbItem[6].nIndex   = 6;
		tbItem[6].nImageID = IDB_TB_TRANSFER;
		tbItem[6].nInfoID  = IDT_TB_TRANSFER;
		tbItem[6].crMask   = RGB(255, 255, 255);
		tbItem[6].nStyle   = TBBS_BUTTON;
		tbItem[6].lpText   = MC_CStoSTR(csTbName[6]);

		csTbName[7].LoadString(IDT_TB_INFORMATION);
		tbItem[7].nIndex   = 7;
		tbItem[7].nImageID = IDB_TB_INFORMATION;
		tbItem[7].nInfoID  = IDT_TB_INFORMATION;
		tbItem[7].crMask   = RGB(255, 255, 255);
		tbItem[7].nStyle   = TBBS_BUTTON;
		tbItem[7].lpText   = MC_CStoSTR(csTbName[7]);

		// ToolBar size
		nTbSize = 8;

		// Add node list
		nd.dwAddress  = m_wcsStatus.dwLocalAddress;
		nd.wPort	  = m_wcsStatus.wTCPPort;
		nd.wNodeID	  = m_wcsStatus.wNodeID;
		nd.wNodeState = m_wcsStatus.wNodeState;
		nd.wNodeType  = m_wcsStatus.wNodeType;
		nd.dwProcessors = m_wcsStatus.dwProcessors;
		m_NodeList.list.Add(nd);
		m_wndMasterView.AddNodeList(nd);
		
		cs.Format(_T("Start WinCS : (%s)"), GetNowTime());
		m_wndMasterView.AddConsoleText(cs);
	}

	// ToolBar setting
	if (!CreateToolBar(tbItem, CSize(22, 22), nTbSize))
	{
		TRACE1("***** ERROR: ToolBar create(%d)\n", GetLastError());
		return EndDialog(IDCANCEL), FALSE;
	}

	// Status bar
	if (!m_wndStatusBar.Create(this))
	{
		TRACE1("***** ERROR: StatusBar create(%d)\n", GetLastError());
		return EndDialog(IDCANCEL), FALSE;
	}

	RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, 0);

	// Data setting
	OutputNodeData();

	// Load plugin
	if (!LoadPlugin())
	{
		return EndDialog(IDCANCEL), FALSE;
	}

	m_fInit = TRUE;

	// Set NodeType image
	PostMessage(WM_SHOWN, (WPARAM)m_wcsStatus.wNodeType, 0);

	return FALSE;
}

void CWinCSDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		OnHelp();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CWinCSDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();

		if (m_fInit)
		{
			// Repaint
			PostMessage(WM_SHOWN, (WPARAM)m_wcsStatus.wNodeType, 0);
		}
	}
}

HCURSOR CWinCSDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

BOOL CWinCSDlg::StartMaster()
{
	SOCKADDR_IN siAddr;
	LOCALNET net;
	SOCKMSG  SockMsg;
	CString  cs, csIP;
	int nLenSA = sizeof(SOCKADDR);

	if (SearchMaster((LPSOCKADDR)&siAddr, &nLenSA))
	{
		cs.LoadString(IDS_WCS_ERROR_MASTER_DUPLICATED);
		csIP.Format(_T("\r\nIP: %s"), DwToIPAddress(siAddr.sin_addr.s_addr));
		cs += csIP;
		AfxMessageBox(cs);
		return FALSE;
	}

	// ClientPeerSocket
	if (!m_pClientBcastSocket->AsyncSelect(FD_PEER))
	{
		m_pClientBcastSocket->CloseSocket();
		return FALSE;
	}

	if (!ServerPeerSocketInitialize())
	{
		m_pClientBcastSocket->CloseSocket();
		return FALSE;
	}

	// ServerSocket
	try
	{
		m_pServerSocket = CServerSocketPtr(new CServerSocket());
	}
	catch (std::bad_alloc &)
	{
		TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
		return FALSE;
	}

	SockMsg.pTgtObj    = this;
	SockMsg.dwSocketID = WCS_SOCKID_STREAM_SERVER;

	if (!m_pServerSocket->Initialize(SockMsg, m_wcsStatus.wTCPPort, m_wcsStatus.dwLocalAddress))
	{
		m_pClientBcastSocket->CloseSocket();
		m_pServerPeerSocket->CloseSocket();
		return FALSE;
	}

	if (!m_pServerSocket->SetKeepAlive())
	{
		m_pClientBcastSocket->CloseSocket();
		m_pServerPeerSocket->CloseSocket();
		return FALSE;
	}

	m_wcsStatus.dwMasterAddress = m_wcsStatus.dwLocalAddress;
	net.dwAddress = m_wcsStatus.dwLocalAddress;
	net.dwMask	  = m_wcsStatus.dwMaskAddress;
	net.dwNet	  = (net.dwAddress & net.dwMask);
	m_pServerSocket->SetLocalNet(net);

	return TRUE;
}

BOOL CWinCSDlg::StartSlave()
{
	SOCKADDR_IN siAddr;
	LOCALNET net;
	SOCKMSG  SockMsg;
	CString  cs, csIP;
	int nLenSA = sizeof(SOCKADDR);

	if (m_wcsStatus.fDynamic)
	{
		if (!SearchMaster((LPSOCKADDR)&siAddr, &nLenSA))
		{
			// Master can't discover the network.
			cs.LoadString(IDS_WCS_ERROR_MASTER_DISCOVERY);
			AfxMessageBox(cs);
			return FALSE;
		}
		else
		{
			siAddr.sin_family = AF_INET;
			siAddr.sin_port	  = htons(m_wcsStatus.wTCPPort);
		}
	}
	else
	{
		siAddr.sin_family	   = AF_INET;
		siAddr.sin_port		   = htons(m_wcsStatus.wTCPPort);
		siAddr.sin_addr.s_addr = m_wcsStatus.dwMasterAddress;
	}

	// ClientSocket initialize
	try
	{
		m_pClientSocket = CClientSocketPtr(new CClientSocket());
	}
	catch (std::bad_alloc &)
	{
		TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
		return FALSE;
	}

	SockMsg.pTgtObj    = this;
	SockMsg.dwSocketID = WCS_SOCKID_STREAM_CLIENT;

	if (!m_pClientSocket->Initialize(SockMsg))
	{
		return FALSE;
	}

	if (!ConnectMaster((LPSOCKADDR)&siAddr))
	{
		m_pClientBcastSocket->CloseSocket();
		m_pClientSocket->CloseSocket();

		cs.LoadString(IDS_WCS_ERROR_MASTER_CONNECT);
		csIP.Format(_T("\r\nIP: %s"), DwToIPAddress(siAddr.sin_addr.s_addr));
		cs += csIP;
		AfxMessageBox(cs);	
		return FALSE;
	}

	if (!m_pClientSocket->SetKeepAlive())
	{
		m_pClientBcastSocket->CloseSocket();
		m_pClientSocket->CloseSocket();
		return FALSE;
	}

	if (!m_pClientSocket->AsyncSelect(FD_CLIENT))
	{
		m_pClientBcastSocket->CloseSocket();
		m_pClientSocket->CloseSocket();
		return FALSE;
	}

	// PeerSocket setting
	if (!m_pClientBcastSocket->AsyncSelect(FD_PEER))
	{
		m_pClientBcastSocket->CloseSocket();
		m_pClientSocket->CloseSocket();
		return FALSE;
	}

	m_wcsStatus.dwMasterAddress = siAddr.sin_addr.s_addr;
	net.dwAddress = m_wcsStatus.dwLocalAddress;
	net.dwMask	  = m_wcsStatus.dwMaskAddress;
	net.dwNet	  = (net.dwAddress & net.dwMask);
	m_pClientSocket->SetLocalNet(net);

	return TRUE;
}

int CWinCSDlg::SearchPluginIndex(WORD wPluginID)
{
	CSingleLock sl(&m_PluginList.cs, TRUE);
	UINT nSize = m_PluginList.list.GetSize();
	int  nIndex = -1;
	
	for (UINT i = 0; i < nSize; i++)
	{
		if (m_PluginList.list[i].plgInfo.wPluginID == wPluginID)
		{
			nIndex = i;
			break;
		}
	}

	m_PluginList.nSelect = nIndex;

	return nIndex;
}

void CWinCSDlg::SetWcsStatus()
{
	SYSTEM_INFO si;

	// Load settings
	LoadWcsSettings();

	GetSystemInfo(&si);
	m_wcsStatus.dwProcessors = si.dwNumberOfProcessors;
	m_wcsStatus.wNodeState   = WCS_STATE_WAITING;
	m_wcsStatus.wNodeID	     = WCS_DEFAULT_NODE_ID;
}

DWORD CWinCSDlg::MakeBcastAddress(DWORD dwAddress, DWORD dwNetMask)
{
	return ((dwAddress & dwNetMask) | (~dwNetMask));
}

BOOL CWinCSDlg::ClientPeerSocketInitialize()
{
	// ClientPeerSocket
	SOCKMSG SockMsg;

	try
	{
		m_pClientBcastSocket = CBcastSocketPtr(new CBcastSocket());
	}
	catch (std::bad_alloc &)
	{
		TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
		return FALSE;
	}

	SockMsg.pTgtObj    = this;
	SockMsg.dwSocketID = WCS_SOCKID_PEER_CLIENT;

	if (!m_pClientBcastSocket->Initialize(SockMsg, m_wcsStatus.dwLocalAddress, m_wcsStatus.wUDPClientPort))
	{
		return FALSE;
	}

	if (!m_pClientBcastSocket->SetSendTimeout(m_wcsStatus.dwTimeout) ||
		!m_pClientBcastSocket->SetRecieveTimeout(m_wcsStatus.dwTimeout))
	{
		m_pClientBcastSocket->CloseSocket();
		return FALSE;
	}

	if (!m_pClientBcastSocket->SetBroadcast(m_wcsStatus.dwBcastAddress, m_wcsStatus.wUDPServerPort))
	{
		m_pClientBcastSocket->CloseSocket();
		return FALSE;
	}

	return TRUE;
}

BOOL CWinCSDlg::ServerPeerSocketInitialize()
{
	// ServerPeerSocket
	SOCKMSG SockMsg;

	try
	{
		m_pServerPeerSocket = CPeerSocketPtr(new CPeerSocket());
	}
	catch (std::bad_alloc &)
	{
		TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
		return FALSE;
	}

	SockMsg.pTgtObj    = this;
	SockMsg.dwSocketID = WCS_SOCKID_PEER_SERVER;

	if (!m_pServerPeerSocket->Initialize(SockMsg, m_wcsStatus.dwLocalAddress, m_wcsStatus.wUDPServerPort))
	{
		return FALSE;
	}

	if (!m_pServerPeerSocket->SetSendTimeout(m_wcsStatus.dwTimeout) ||
		!m_pServerPeerSocket->SetRecieveTimeout(m_wcsStatus.dwTimeout))
	{
		m_pServerPeerSocket->CloseSocket();
		return FALSE;
	}

	if (!m_pServerPeerSocket->AsyncSelect(FD_PEER))
	{
		m_pServerPeerSocket->CloseSocket();
		return FALSE;
	}

	return TRUE;
}

BOOL CWinCSDlg::CreateToolBar(LPTBITEM lpTbItem, SIZE size, UINT nBtnNum)
{
	int		   nBtnX, nBtnY;
	BOOL	   fRet;
	DWORD	   dwTBStyle, dwStyle; 
	CRect	   cr;
	CSize	   cs;
	CBitmap	   bmp;
	CImageList *pImgList;

	nBtnX	  = size.cx;
	nBtnY	  = size.cy;
	dwTBStyle = TBSTYLE_FLAT;
	dwStyle   = WS_CHILD | WS_VISIBLE | 
				CBRS_TOP |CBRS_TOOLTIPS | 
				CBRS_FLYBY | CBRS_SIZE_DYNAMIC;

	fRet =  m_wndToolBar.CreateEx(this, dwTBStyle, dwStyle);
	fRet &= m_wndToolBar.LoadToolBar(IDR_MAINFRAME);

	if (!fRet)
	{
		return FALSE;
	}

	pImgList = m_wndToolBar.GetToolBarCtrl().GetImageList();
	pImgList->DeleteImageList();
	fRet = pImgList->Create(nBtnX, nBtnY, ILC_COLOR16 | ILC_MASK, 1, 1);

	if (!fRet)
	{
		return FALSE;
	}

	for (UINT i = 0; i < nBtnNum; i++)
	{
		if (lpTbItem[i].nStyle == TBBS_BUTTON)
		{
			fRet = bmp.LoadBitmap(lpTbItem[i].nImageID);

			if (fRet)
			{
				pImgList->Add(&bmp, lpTbItem[i].crMask);
				bmp.DeleteObject();
			}
		}
		else
		{
			// Create dumy bitmap
			bmp.CreateBitmap(nBtnX, nBtnY, 1, 1, NULL);
			pImgList->Add(&bmp, RGB(0, 0, 0));
			bmp.DeleteObject();
		}
	}
	m_wndToolBar.GetToolBarCtrl().SetImageList(pImgList);
	m_wndToolBar.GetItemRect(0, &cr);
	m_wndToolBar.SetSizes(CSize(cr.Width(), cr.Height() * 2),
						  CSize(nBtnX, nBtnY));

	// ToolBar button setting
	m_wndToolBar.SetButtons(NULL, nBtnNum);
	for (UINT i = 0; i < nBtnNum; i++)
	{
		m_wndToolBar.SetButtonInfo(i, lpTbItem[i].nInfoID, 
			lpTbItem[i].nStyle,
			lpTbItem[i].nIndex);

		if (lpTbItem[i].nStyle == TBBS_BUTTON)
		{
			m_wndToolBar.SetButtonText(i, lpTbItem[i].lpText);
		}
	}

	return TRUE;
}

void CWinCSDlg::EnableToolBarBtn(int nCtlID, BOOL fEnable)
{
	m_wndToolBar.GetToolBarCtrl().EnableButton(nCtlID, fEnable);
}

BOOL CWinCSDlg::SendAckToMaster(WORD wMsg, DWORD dwOption)
{
	CByteArray data;
	TCP_DATA   tReply;

	ZeroMemory(&tReply, TCPHDR_SIZE);
	tReply.wMsgType	    = wMsg;
	tReply.wSrcNodeType = WCS_NODE_SLAVE;
	tReply.wDstNodeType = WCS_NODE_MASTER;
	tReply.wSrcNodeID   = m_wcsStatus.wNodeID;
	tReply.wDstNodeID   = WCS_MASTER_NODE_ID;
	tReply.dwOption		= dwOption;
	tReply.dwDataSize   = 0;
	data.SetSize(TCPHDR_SIZE);
	CopyMemory(data.GetData(), &tReply, TCPHDR_SIZE);
	data.FreeExtra();

	return m_pClientSocket->Send(data);
}

BOOL CWinCSDlg::SendAckToSlave(WORD wNodeID, WORD wMsg, DWORD dwOption)
{
	CByteArray data;
	TCP_DATA   tReply;
	int nIndex = SearchNodeListIndex(wNodeID);

	if (nIndex != -1)
	{
		ZeroMemory(&tReply, TCPHDR_SIZE);
		tReply.wMsgType	    = wMsg;
		tReply.wSrcNodeType = WCS_NODE_MASTER;
		tReply.wDstNodeType = WCS_NODE_SLAVE;
		tReply.wSrcNodeID   = m_wcsStatus.wNodeID;
		tReply.wDstNodeID   = wNodeID;
		tReply.dwOption		= dwOption;
		tReply.dwDataSize   = 0;
		data.SetSize(TCPHDR_SIZE);
		CopyMemory(data.GetData(), &tReply, TCPHDR_SIZE);
		data.FreeExtra();
		
		return m_pServerSocket->SendToClient(data, m_NodeList.list[nIndex].dwAddress, m_NodeList.list[nIndex].wPort);
	}

	return FALSE;
}

BOOL CWinCSDlg::SaveBenchmarkReport(CString &csLogPath)
{
	SYSTEMTIME  st;
	CString     cs, csRuntime, csTotal, csReport, csText, csTime, csTxtPath;
	HANDLE		hFile;
	double		dbAvg, dbMax, dbMin, dbScore;
	DWORD		dwFileSize, dwWriteSize;
	UINT		nSize, nSlaves, nProcessors;
	TCHAR		szFilePath[_MAX_PATH * 2];

	GetLocalTime(&st);
	csTxtPath.Format(_T("./Log/Benchmark/System_%04d%02d%02d%02d%02d%02d.html"), 
					 st.wYear, st.wMonth, st.wDay,
					 st.wHour, st.wMinute, st.wSecond);

	_tfullpath(szFilePath, csTxtPath, MC_ARYSIZE(szFilePath) - sizeof(TCHAR));
	csLogPath.Format(_T("%s"), szFilePath);
	nProcessors = m_sysStatus.dwProcessors;
	nSlaves		= m_sysStatus.dwSlaves;
	dbScore		= m_bmSystem.dbScore;

	dbAvg = m_bmSystem.dbScore / m_bmSystem.dwTestCount;
	dbMax = 0.0;
	dbMin = static_cast<double>(INT_MAX);
	nSize = m_NodeList.list.GetSize();
	csReport += LOG_TEMPLATE_HTML_BENCHMARK_SYSTEM_CAPTION;

	for (UINT i = 1; i < nSize; i++)
	{
		if (m_NodeList.list[i].bm.fSet)
		{
			cs.Format(LOG_TEMPLATE_HTML_BENCHMARK_SYSTEM_DATA,
					  m_NodeList.list[i].wNodeID,
					  DwToIPAddress(m_NodeList.list[i].dwAddress),
					  m_NodeList.list[i].bm.dbRltAvg);
			csReport += cs;
			dbMax = max(dbMax, m_NodeList.list[i].bm.dbRltAvg);
			dbMin = min(dbMin, m_NodeList.list[i].bm.dbRltAvg);
		}
	}

	m_bmSystem.dlg->GetRuntimeText(csRuntime);
	csTime.Format(_T("%04d/%02d/%02d %02d:%02d:%02d"),
				  st.wYear, st.wMonth, st.wDay,
				  st.wHour, st.wMinute, st.wSecond);
	csTotal.Format(LOG_TEMPLATE_HTML_BENCHMARK_SYSTEM_TOTAL, dbScore);
	csText.Format(LOG_TEMPLATE_HTML_BENCHMARK_CONTAINER,
				  _T("System"),								// Mode
				  csTime,									// DateTime
				  nSlaves,									// Nodes
				  nProcessors,								// Processors
				  csRuntime,								// Runtime
				  csTotal,									// Total
				  dbAvg,									// Average
				  dbMax,									// High score
				  dbMin,									// Low score
				  csReport);								// Report data

	hFile = CreateFile(csTxtPath, GENERIC_WRITE, 0, NULL, CREATE_NEW,
					   FILE_ATTRIBUTE_NORMAL, NULL);

	if (hFile != INVALID_HANDLE_VALUE)
	{
		dwFileSize = csText.GetLength() * sizeof(TCHAR);
		WriteFile(hFile, csText, dwFileSize, &dwWriteSize, NULL);
		CloseHandle(hFile);
		return TRUE;
	}

	return FALSE;
}

void CWinCSDlg::MakeSockAddr(LPSOCKADDR lpSockAddr, DWORD dwAddress, WORD wPort, int nAF)
{
	SOCKADDR_IN addr;
	addr.sin_port		 = htons(wPort);
	addr.sin_family		 = nAF;
	addr.sin_addr.s_addr = dwAddress;
	CopyMemory(lpSockAddr, &addr, sizeof(SOCKADDR));
}

void CWinCSDlg::MakeINetAddr(LPDWORD lpAddress, LPWORD lpPort, const LPSOCKADDR lpSockAddr)
{
	SOCKADDR_IN addr;
	CopyMemory(&addr, lpSockAddr, sizeof(addr));
	*lpAddress = addr.sin_addr.s_addr;
	*lpPort	   = ntohs(addr.sin_port);
}

BOOL CWinCSDlg::SaveSettings(CString csName, int nValue)
{
	CWinApp* pApp = AfxGetApp();
	CString  csSection = _T("Settings");

	ASSERT(pApp);
	return pApp->WriteProfileInt(csSection, csName, nValue);
}

UINT CWinCSDlg::LoadSettings(CString csName, int nDefault)
{
	CWinApp* pApp = AfxGetApp();
	CString  csSection = _T("Settings");

	ASSERT(pApp);
	return pApp->GetProfileInt(csSection, csName, nDefault);
}

void CWinCSDlg::LoadWcsSettings()
{
	m_wcsStatus.dwMasterAddress = static_cast<DWORD>(LoadSettings(_T("MasterAddress"), WCS_DEFAULT_MASTER_ADDRESS));
	m_wcsStatus.dwBcastAddress  = static_cast<DWORD>(LoadSettings(_T("BcastAddress"), WCS_DEFAULT_BCAST_ADDRESS));	
	m_wcsStatus.dwTimeout		= static_cast<DWORD>(LoadSettings(_T("Timeout"), WCS_DEFAULT_TIMEOUT));
	m_wcsStatus.wUDPClientPort	= static_cast<WORD>(LoadSettings(_T("UDPPortU"), WCS_DEFAULT_UDP_CLIENT_PORT));
	m_wcsStatus.wUDPServerPort	= static_cast<WORD>(LoadSettings(_T("UDPPortB"), WCS_DEFAULT_UDP_SERVER_PORT));
	m_wcsStatus.wTCPPort		= static_cast<WORD>(LoadSettings(_T("TCPPort"), WCS_DEFAULT_TCP_PORT));
	m_wcsStatus.wRetry			= static_cast<WORD>(LoadSettings(_T("Retry"), WCS_DEFAULT_RETRY));
	m_wcsStatus.fDynamic		= static_cast<BOOL>(LoadSettings(_T("Dynamic"), TRUE));
}

void CWinCSDlg::SaveWcsSettings()
{
	SaveSettings(_T("Dynamic"), m_wcsStatus.fDynamic);
	SaveSettings(_T("MasterAddress"), m_wcsStatus.dwMasterAddress);
	SaveSettings(_T("BcastAddress"), m_wcsStatus.dwBcastAddress);
	SaveSettings(_T("UDPPortU"), m_wcsStatus.wUDPClientPort);
	SaveSettings(_T("UDPPortB"), m_wcsStatus.wUDPServerPort);
	SaveSettings(_T("TCPPort"), m_wcsStatus.wTCPPort);
	SaveSettings(_T("Timeout"), m_wcsStatus.dwTimeout);
	SaveSettings(_T("Retry"), m_wcsStatus.wRetry);
}

BOOL CWinCSDlg::SearchMaster(LPSOCKADDR lpSockAddr, int *lpSockAddrLen)
{
	CByteArray snd, rcv;
	UDP_DATA uData;

	uData.wMsgType	   = WCS_MSG_MASTER_DISCOVER;
	uData.wSrcNodeType = WCS_NODE_UNDEFINED;
	uData.wDstNodeType = WCS_NODE_MASTER;
	uData.wSrcNodeID   = m_wcsStatus.wNodeID;
	uData.wDstNodeID   = WCS_MASTER_NODE_ID;

	snd.SetSize(sizeof(uData));
	CopyMemory(snd.GetData(), &uData, snd.GetSize());

	if (!m_pClientBcastSocket->Broadcast(snd))
	{
		return FALSE;
	}

	if (!m_pClientBcastSocket->ReceiveFrom(rcv, lpSockAddr, lpSockAddrLen))
	{
		return FALSE;
	}

	ZeroMemory(&uData, sizeof(uData));
	CopyMemory(&uData, rcv.GetData(), UDPHDR_SIZE);

	if (!(uData.wMsgType == WCS_MSG_MASTER_OFFER && uData.wSrcNodeType == WCS_NODE_MASTER))
	{
		return FALSE;
	}

	return TRUE;
}

BOOL CWinCSDlg::ConnectMaster(const LPSOCKADDR lpMasterAddr)
{
	int nLenSA = sizeof(SOCKADDR);

	if (!m_pClientSocket->SyncConnect(lpMasterAddr, nLenSA, m_wcsStatus.dwTimeout))
	{
		return FALSE;
	}

	return TRUE;
}

void CWinCSDlg::OutputNodeData()
{
	m_wndStatusView.SetNodeID(m_wcsStatus.wNodeID);
	m_wndStatusView.SetNodeState(m_wcsStatus.wNodeState);
	m_wndStatusView.SetMasterAddress(m_wcsStatus.dwMasterAddress);
	m_wndStatusView.SetLocalAddress(m_wcsStatus.dwLocalAddress);
	m_wndStatusView.SetTCPPort(m_wcsStatus.wTCPPort);

	if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
	{
		m_wndStatusView.SetUDPPort(m_wcsStatus.wUDPServerPort);
	}
	else
	{
		m_wndStatusView.SetUDPPort(m_wcsStatus.wUDPClientPort);
	}
}

BOOL CWinCSDlg::CreateWcsDirectory()
{
	CString cs[5];
	cs[0] = _T("./Log");
	cs[1] = _T("./Log/Console");
	cs[2] = _T("./Log/Benchmark");
	cs[3] = _T("./Log/Plugin");
	cs[4] = _T("./Plugin");

	for (UINT i = 0; i < 5; i++)
	{
		if (!(PathFileExists(cs[i]) && PathIsDirectory(cs[i])))
		{
			if (!CreateDirectory(cs[i], NULL))
			{
				return FALSE;
			}
		}
	}

	return TRUE;
}

void CWinCSDlg::FreePlugin(BOOL fRefresh)
{
	CSingleLock sl(&m_PluginList.cs, TRUE);
	UINT nSize = static_cast<UINT>(m_PluginList.list.GetSize());

	// Initialization
	if (nSize > 0)
	{
		for (UINT i = 0; i < nSize; i++)
		{
			if (m_PluginList.list[i].obj != NULL)
			{
				m_PluginList.list[i].fpRelease(m_PluginList.list[i].obj);
			}

			FreeLibrary(m_PluginList.list[i].hModule);
		}

		if (fRefresh)
		{
			m_PluginList.list.RemoveAll();
			m_wndStatusView.DeletePluginList();
			m_wndStatusView.PluginInfoClear();

			if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
			{
				m_wndMasterView.SetPluginName(STRING_NONE);
			}
		}
	}
}

BOOL CWinCSDlg::LoadPlugin()
{
	// DLL plugin loading
	CFileFind finder;
	CString	  csProgMsg;
	CString	  csDLL = _T("./Plugin/*.dll");
	BOOL	  flag;
	UINT	  nSize;

	FreePlugin();

	if (m_wcsStatus.wNodeState != WCS_STATE_WAITING)
	{
		return FALSE;
	}

	CSingleLock sl(&m_PluginList.cs, TRUE);

	flag = finder.FindFile(csDLL);

	while (flag)
	{
		flag = finder.FindNextFile();
		if (!finder.IsDots())
		{
			LoadExcutionPlugin(finder.GetFilePath());
		}
	}

	nSize = static_cast<UINT>(m_PluginList.list.GetSize());

	if (nSize > 0)
	{
		for (UINT i = 0; i < nSize; i++)
		{
			m_wndStatusView.AddPluginList(m_PluginList.list[i].csModuleName);
		}

		m_PluginList.nSelect  = 0;
		m_PluginList.fRunning = FALSE;
		m_wndStatusView.SelectPluginList(0);
		m_wndStatusView.SetPluginInfo(m_PluginList.list[0].plgInfo);

		if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
		{
			m_wndMasterView.SetPluginName(m_PluginList.list[0].csModuleName);
		}
	}
	else
	{
		if (m_wcsStatus.wNodeType == WCS_NODE_MASTER)
		{
			m_wndMasterView.SetPluginName(STRING_NONE);
		}
	}

	return TRUE;
}

BOOL CWinCSDlg::LoadExcutionPlugin(const CString &csFilePath)
{
	CString  csFileName;
	PLUGIN   pin;
	UINT     nSize;
	BOOL	 fBuild;

	ZeroMemory(&pin.plgInfo, sizeof(pin.plgInfo));
	pin.obj		= NULL;
	csFileName  = PathFindFileName(csFilePath);
	pin.hModule = LoadLibrary(csFilePath);

	if (pin.hModule == NULL)
	{
		return FALSE;
	}

	pin.fpCreate = (CREATE_PLUGIN)GetProcAddress(pin.hModule, "CreatePlugin");

	if (pin.fpCreate == NULL)
	{
		TRACE0("***** ERROR: Couldn't get function(CreatePlugin) *****\n");
		FreeLibrary(pin.hModule);
		return FALSE;
	}

	pin.fpRelease = (RELEASE_PLUGIN)GetProcAddress(pin.hModule, "ReleasePlugin");

	if (pin.fpRelease == NULL)
	{
		TRACE0("***** ERROR: Couldn't get function(ReleasePlugin) *****\n");
		FreeLibrary(pin.hModule);
		return FALSE;
	}
	
	pin.obj = pin.fpCreate();
	
	if (pin.obj == NULL)
	{
		TRACE0("***** ERROR: Create Plugin instance(bad_alloc) *****\n");
		FreeLibrary(pin.hModule);
		return FALSE;
	}

	CStructuredException::MapSEtoCE();

	try
	{
		// Plugin initialization
		pin.obj->SetAPI(this);
		pin.obj->LoadInitialize();
		pin.obj->GetPluginInfo(&pin.plgInfo);
	}
	catch (CStructuredException)
	{
		TRACE0("***** ERROR: Plugin initialization *****\n");
		pin.fpRelease(pin.obj);
		FreeLibrary(pin.hModule);
		return FALSE;
	}

#ifndef _DEBUG
	fBuild = (pin.plgInfo.nBuildType == WCS_BUILD_TYPE_RELEASE);
#else
	fBuild = (pin.plgInfo.nBuildType == WCS_BUILD_TYPE_DEBUG);
#endif

	if (!fBuild)
	{
		TRACE0("***** ERROR: Type of plugin build *****\n");
		pin.fpRelease(pin.obj);
		FreeLibrary(pin.hModule);
		return FALSE;
	}

	nSize = m_PluginList.list.GetSize();

	for (UINT i = 0; i < nSize; i++)
	{
		if (m_PluginList.list[i].plgInfo.wPluginID == pin.plgInfo.wPluginID)
		{
			FreeLibrary(pin.hModule);
			TRACE1("***** MESSAGE: Duplicate plugin(%s) *****\n", csFileName);
			return FALSE;
		}
	}

	pin.csModulePath = csFilePath;
	pin.csModuleName = csFileName;
	pin.dwIndex		 = m_PluginList.list.GetSize();
	m_PluginList.list.Add(pin);

	return TRUE;
}

BOOL CWinCSDlg::PluginTransfer(UINT nIndex)
{
	CByteArray data;
	TCP_DATA   tData;
	TRANSFER   tf;
	IntList    list;
	CString	   cs1, cs2, csPath, csModule;
	HANDLE	   hFile;
	DWORD	   dwStrSize, dwFileSize, dwReadSize, dwAddress;
	WORD	   wPort, wNodeID;
	UINT	   nSize;
	BOOL	   fRet = TRUE;

	nSize     = m_NodeList.list.GetSize();
	csPath    = m_PluginList.list[nIndex].csModulePath;
	csModule  = m_PluginList.list[nIndex].csModuleName;
	dwStrSize = sizeof(TCHAR) * _MAX_FNAME;
	
	hFile = CreateFile(csPath, GENERIC_READ, 0, NULL, OPEN_EXISTING,
					   FILE_ATTRIBUTE_NORMAL, NULL);

	if (hFile != INVALID_HANDLE_VALUE)
	{
		ZeroMemory(&tf, sizeof(tf.dwFileSize) + dwStrSize);
		lstrcpy(tf.szFileName, csModule);
		dwFileSize = GetFileSize(hFile, NULL);
		tf.dwFileSize = dwFileSize;
		tf.data.SetSize(dwFileSize);

		if (ReadFile(hFile, tf.data.GetData(), dwFileSize, &dwReadSize, NULL))
		{
			tData.data.SetSize(sizeof(tf.dwFileSize) + dwStrSize + dwFileSize);
			CopyMemory(tData.data.GetData(), &tf.dwFileSize, sizeof(tf.dwFileSize));
			CopyMemory(tData.data.GetData() + sizeof(tf.dwFileSize), tf.szFileName, dwStrSize);
			CopyMemory(tData.data.GetData() + sizeof(tf.dwFileSize) + dwStrSize, tf.data.GetData(), dwFileSize);

			ZeroMemory(&tData, TCPHDR_SIZE);
			tData.wMsgType	   = WCS_MSG_PLUGIN_TRANSFER;
			tData.wSrcNodeType = WCS_NODE_MASTER;
			tData.wDstNodeType = WCS_NODE_SLAVE;
			tData.wSrcNodeID   = m_wcsStatus.wNodeID;
			tData.dwDataSize   = tData.data.GetSize();

			for (UINT j = 1; j < nSize; j++)
			{
				wPort     = m_NodeList.list[j].wPort;
				wNodeID	  = m_NodeList.list[j].wNodeID;
				dwAddress = m_NodeList.list[j].dwAddress;

				tData.wDstNodeID = wNodeID;
				data.SetSize(TCPHDR_SIZE + tData.dwDataSize);
				CopyMemory(data.GetData(), &tData, TCPHDR_SIZE);
				CopyMemory(data.GetData() + TCPHDR_SIZE, tData.data.GetData(), tData.dwDataSize);
				data.FreeExtra();
				
				if (!m_pServerSocket->SendToClient(data, dwAddress, wPort))
				{
					fRet = FALSE;
					break;
				}
			}
		}

		CloseHandle(hFile);

		return fRet;
	}
	else
	{
		cs1.LoadString(IDS_WCS_ERROR_PLUGIN_TRANSFER);
		cs2.Format(_T("%s\r\nPlugin : %s"), cs1, csModule);
		AfxMessageBox(cs2);
	}

	return FALSE;
}

void CWinCSDlg::AutoExitTimer()
{
	// Slave window
	CWnd *pWnd = CWnd::FindWindow(NULL, _T("WinCS Exit"));

	if (pWnd)
	{
		pWnd->PostMessage(WM_CLOSE);
	}
}

// static
void WINAPI CWinCSDlg::doAutoExitTimer(LPVOID pvContext, BOOLEAN fTimeout)
{
	((CWinCSDlg *)pvContext)->AutoExitTimer();
}

//////////////////////////////////////////////////////////////////////////
