#pragma once

//////////////////////////////////////////////////////////////////////////

#define STRING_EMPTY	_T("")
#define STRING_NONE		_T("---")
#define STRING_ZERO		_T("0")
#define STRING_RETURN	_T("\r\n")

// Function pointer (Using DLL module load)
typedef CPlugin *(*CREATE_PLUGIN)();					// Create instance
typedef void  (*RELEASE_PLUGIN)(CPlugin *);				// Release instance

//////////////////////////////////////////////////////////////////////////

// Structure
typedef struct _HEADER
{
	size_t size;
}
HEADER, *LPHEADER;

typedef struct _WCS_STATUS
{
	DWORD dwMasterAddress;
	DWORD dwBcastAddress;
	DWORD dwLocalAddress;
	DWORD dwMaskAddress;
	DWORD dwTimeout;
	DWORD dwProcessors;
	WORD  wTCPPort;
	WORD  wUDPClientPort;
	WORD  wUDPServerPort;
	WORD  wNodeID;
	WORD  wNodeType;
	WORD  wNodeState;
	WORD  wRetry;
	BOOL  fDynamic;
}
WCS_STATUS, *LPWCS_STATUS;

typedef struct _TCP_DATA
{
	DWORD dwDataSize;
	WORD  wMsgType;
	WORD  wSrcNodeType;
	WORD  wDstNodeType;
	WORD  wSrcNodeID;
	WORD  wDstNodeID;
	DWORD dwOption;
	CByteArray data;
}
TCP_DATA, *LPTCP_DATA;

// 4 KByte
typedef struct _UDP_DATA
{
	WORD wMsgType;
	WORD wSrcNodeType;
	WORD wDstNodeType;
	WORD wSrcNodeID;
	WORD wDstNodeID;
	BYTE data[4086];
}
UDP_DATA, *LPUDP_DATA;

typedef struct _PLUGIN
{
	DWORD	  dwIndex;
	HINSTANCE hModule;
	CString	  csModuleName;
	CString   csModulePath;
	CPlugin	  *obj;
	PLUGIN_INFO	   plgInfo;
	CREATE_PLUGIN  fpCreate;
	RELEASE_PLUGIN fpRelease;
}
PLUGIN, *LPPLUGIN;

typedef struct _TBITEM
{
	UINT     nIndex;
	UINT     nImageID;
	UINT	 nStyle;
	UINT	 nInfoID;
	COLORREF crMask;
	LPCTSTR	 lpText;
}
TBITEM, *LPTBITEM;

typedef struct _BM_PROCESS
{
	int	   nIndex;
	double dbError;
	double dbRuntime;
	double dbGFLOPS;
}
BM_PROCESS, *LPBM_PROCESS;

typedef struct _LOCKTIMER
{
	CCriticalSection cs;
	HANDLE hTimer;
}
LOCKTIMER, *LPLOCKTIMER;

typedef struct _TRANSFER
{
	DWORD dwFileSize;
	TCHAR szFileName[_MAX_FNAME];
	CByteArray data;
}
TRANSFER, *LPTRANSFER;

typedef struct _BM_RANKING
{
	WORD   wNodeID;
	WORD   wRanking;
	double dbScore;

	BOOL operator < (const _BM_RANKING &br) const
	{
		return (dbScore < br.dbScore);
	}

	BOOL operator > (const _BM_RANKING &br) const
	{
		return (dbScore > br.dbScore);
	}
}
BM_RANKING, *LPBM_RANKING;

typedef struct _BM_SYSTEMSCORE
{
	double dbTotal;
	double dbAvg;
	double dbHigh;
	double dbLow;
}
BM_SYSTEMSCORE, *LPBM_SYSTEMSCORE;

//////////////////////////////////////////////////////////////////////////

typedef CSortArray<BM_RANKING>	BMRankList;
typedef CArray<BM_DATA>			BMDataList;
typedef CArray<PLUGIN>			PluginList;
typedef CArray<int>				IntList;

//////////////////////////////////////////////////////////////////////////
