#include "StdAfx.h"
#include "TaskManager.h"

//////////////////////////////////////////////////////////////////////////

CTaskManager::CTaskManager()
{
	m_hTimer = NULL;
	m_DataQueue.nCount = 0;
	m_DataQueue.nIndex = 0;
	m_DataQueue.nPoint = 0;
}

CTaskManager::~CTaskManager()
{
}

void CTaskManager::InitDataQueue()
{
	CSingleLock sl(&m_DataQueue.cs, TRUE);
	
	m_DataQueue.nCount = 0;
	m_DataQueue.nIndex = 0;
	m_DataQueue.nPoint = 0;

	for (UINT i = 0; i < 1000; i++)
	{
		m_DataQueue.Queue[i].RemoveAll();
	}
}

BOOL CTaskManager::DataEnqueue(const CByteArray &data)
{
	CSingleLock sl(&m_DataQueue.cs, TRUE);

	if (m_DataQueue.nCount < WCS_QUEUE_SIZE)
	{
		m_DataQueue.Queue[m_DataQueue.nIndex].Copy(data);
		m_DataQueue.nCount++;
		m_DataQueue.nIndex = (m_DataQueue.nIndex + 1) % WCS_QUEUE_SIZE;
		return TRUE;
	}

	return FALSE;
}

BOOL CTaskManager::DataDequeue(CByteArray &data)
{
	CSingleLock sl(&m_DataQueue.cs, TRUE);

	if (m_DataQueue.nCount > 0)
	{
		data.Copy(m_DataQueue.Queue[m_DataQueue.nPoint]);
		m_DataQueue.Queue[m_DataQueue.nPoint].RemoveAll();
		m_DataQueue.nCount--;
		m_DataQueue.nPoint = (m_DataQueue.nPoint + 1) % WCS_QUEUE_SIZE;
		return TRUE;
	}

	return FALSE;
}

int CTaskManager::GetQueueSize()
{
	CSingleLock sl(&m_DataQueue.cs, TRUE);
	return m_DataQueue.nCount;
}

//////////////////////////////////////////////////////////////////////////
