#pragma once

#include <eh.h>

//////////////////////////////////////////////////////////////////////////

class CStructuredException
{
public:
	static void MapSEtoCE()
	{
		_set_se_translator(TranslateSEtoCE);
	}

	void ReportError()
	{
		CString err;
		UINT    nErrCode = m_ErrRecord.ExceptionCode;

		switch (nErrCode)
		{
		case EXCEPTION_ACCESS_VIOLATION:
			err.Format(_T("MemoryAccessViolation(%d)"), nErrCode);
			break;

		case EXCEPTION_DATATYPE_MISALIGNMENT:
			err.Format(_T("MemoryDatatypeMisalignment(%d)"), nErrCode);
			break;

		case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
			err.Format(_T("MemoryArrayBoundsExceeded(%d)"), nErrCode);
			break;

		case EXCEPTION_IN_PAGE_ERROR:
			err.Format(_T("MemoryInPageError(%d)"), nErrCode);
			break;

		case EXCEPTION_GUARD_PAGE:
			err.Format(_T("MemoryGuardPage(%d)"), nErrCode);
			break;

		case EXCEPTION_STACK_OVERFLOW:
			err.Format(_T("MemoryStackOverflow(%d)"), nErrCode);
			break;

		case EXCEPTION_ILLEGAL_INSTRUCTION:
			err.Format(_T("MemoryIllegalInstruction(%d)"), nErrCode);
			break;

		case EXCEPTION_PRIV_INSTRUCTION:
			err.Format(_T("MemoryPrivInstruction(%d)"), nErrCode);
			break;

		case EXCEPTION_INVALID_DISPOSITION:
			err.Format(_T("ExceptionInvalidDisposition(%d)"), nErrCode);
			break;

		case EXCEPTION_NONCONTINUABLE_EXCEPTION:
			err.Format(_T("ExceptionNoncontinuableException(%d)"), nErrCode);
			break;

		case EXCEPTION_BREAKPOINT:
			err.Format(_T("DebugBreakPoint(%d)"), nErrCode);
			break;

		case EXCEPTION_SINGLE_STEP:
			err.Format(_T("DebugSingleStep(%d)"), nErrCode);
			break;

		case EXCEPTION_INVALID_HANDLE:
			err.Format(_T("DebugInvalidHandle(%d)"), nErrCode);
			break;

		case EXCEPTION_INT_DIVIDE_BY_ZERO:
			err.Format(_T("IntegerIntDivideByZero(%d)"), nErrCode);
			break;

		case EXCEPTION_INT_OVERFLOW:
			err.Format(_T("IntegerIntOverflow(%d)"), nErrCode);
			break;

		case EXCEPTION_FLT_DENORMAL_OPERAND:
			err.Format(_T("FloatDenormalOperand(%d)"), nErrCode);
			break;

		case EXCEPTION_FLT_DIVIDE_BY_ZERO:
			err.Format(_T("FloatDivideByZero(%d)"), nErrCode);
			break;

		case EXCEPTION_FLT_INEXACT_RESULT:
			err.Format(_T("FloatInexactResult(%d)"), nErrCode);
			break;

		case EXCEPTION_FLT_INVALID_OPERATION:
			err.Format(_T("FloatInvalidOperation(%d)"), nErrCode);
			break;

		case EXCEPTION_FLT_OVERFLOW:
			err.Format(_T("FloatOverflow(%d)"), nErrCode);
			break;

		case EXCEPTION_FLT_STACK_CHECK:
			err.Format(_T("FloatStackCheck(%d)"), nErrCode);
			break;

		case EXCEPTION_FLT_UNDERFLOW:
			err.Format(_T("FloatUnderflow(%d)"), nErrCode);
			break;
		}

		if (err.GetLength() > 0)
		{
			AfxMessageBox(err);
		}
	}

	DWORD GetErorrCode() { return m_ErrRecord.ExceptionCode; }
	operator DWORD() { return m_ErrRecord.ExceptionCode; }

private:
	CStructuredException(PEXCEPTION_POINTERS pep)
	{
		m_ErrRecord = *pep->ExceptionRecord;
		m_Context	= *pep->ContextRecord;
	}

	static void __cdecl TranslateSEtoCE(UINT nErrCode, PEXCEPTION_POINTERS pep)
	{
		throw CStructuredException(pep);
	}

private:
	EXCEPTION_RECORD m_ErrRecord;
	CONTEXT			 m_Context;
};

//////////////////////////////////////////////////////////////////////////