#pragma once

#include "afxwin.h"
#include "ImageEx.h"

//////////////////////////////////////////////////////////////////////////

class CStatusView : public CDialog, CStringConvert
{
	DECLARE_DYNAMIC(CStatusView)

public:
	CStatusView(CWnd* pParent = NULL);
	virtual ~CStatusView();
	enum { IDD = IDD_STATUS_VIEW };

	void SetNodeType(WORD wNodeType);
	void SetNodeID(WORD wNodeID);
	void SetNodeState(WORD wNodeState);
	void SetLocalAddress(DWORD dwAddress);
	void SetMasterAddress(DWORD dwAddress);
	void SetUDPPort(WORD wPort);
	void SetTCPPort(WORD wPort);

	void SetPluginInfo(const PLUGIN_INFO &info);
	void SetPluginState(BOOL fLock);
	void PluginInfoClear();
	void ResetMasterAddress();
	void ResetNodeID();
	void DeletePluginList();
	void AddPluginList(const CString &csModule);
	void SelectPluginList(UINT nIndex);
	void SetReloadBtn(BOOL fEnable);

protected:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();

	afx_msg void OnBnClickedOk() {}
	afx_msg void OnBnClickedBtnStatusPluginReload();
	afx_msg void OnCbnSelchangeCmbStatusPlugin();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);

	void RuntimeTimer();
	static void WINAPI doRuntimeTimer(LPVOID pvContext, BOOLEAN fTimeout);

public:
	CComboBox m_xCmbPlugin;
	CButton	  m_xBtnPluginReload;
	CStatic   m_xImageType;
	CEdit	  m_xEditNodeID;
	CEdit     m_xEditPluginVersion;
	CEdit	  m_xEditPluginType;
	CEdit     m_xEditPluginText;
	CEdit     m_xEditNodeState;
	CEdit     m_xEditLocalAddress;
	CEdit     m_xEditMasterAddress;
	CEdit     m_xEditUDPClientPort;
	CEdit     m_xEditTCPPort;
	CEdit	  m_xEditRuntime;

protected:
	typedef std::tr1::shared_ptr<CImageExResource> CImgExResPtr;

	WORD	   m_wNodeType;
	DWORD	   m_dwStartTime;
	HICON	   m_hBtnIcon;
	HANDLE	   m_hTimer;
	WCS_STATUS m_wcsStatus;
	CStopwatch m_Stopwatch;
};

//////////////////////////////////////////////////////////////////////////
