#pragma once

#define  WM_SHOW_FOREGROUND		(WM_USER + 1000)

//////////////////////////////////////////////////////////////////////////

class CStartupOption
{
public:
	CStartupOption();
	virtual ~CStartupOption();

	BOOL SingleStartup(const CString &csWndName, BOOL bFront = TRUE);

private:
	CString m_csWndName;
	HANDLE  m_hMutex;
};

//////////////////////////////////////////////////////////////////////////

inline CStartupOption::CStartupOption()
{
	m_hMutex = NULL;
}

inline CStartupOption::~CStartupOption()
{
	if (m_hMutex != NULL)
	{
		ReleaseMutex(m_hMutex);
		CloseHandle(m_hMutex);
	}
}

inline BOOL CStartupOption::SingleStartup(const CString &csWndName, BOOL bFront)
{
	m_csWndName = csWndName;
	m_hMutex    = CreateMutex(NULL, TRUE, csWndName);

	if ((GetLastError() == ERROR_ALREADY_EXISTS)) 
	{
		if (bFront)
		{
			CWnd *pWnd = CWnd::FindWindow(NULL, m_csWndName);

			if (pWnd)
			{
				pWnd->SendMessage(WM_SHOW_FOREGROUND, 0, 0);
			}
		}

		return FALSE;
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////
