#pragma once

//////////////////////////////////////////////////////////////////////////

template <class TYPE, class ARG_TYPE = TYPE> 
class CSortArray : public CArray <TYPE, ARG_TYPE>
{
public:
	CSortArray() {}
	virtual ~CSortArray() {}

	void QuickSort(BOOL bAscending = TRUE);

protected:
	BOOL doQuickSort(TYPE *pArr, int nSize, BOOL bAscending = TRUE);
	void doQuickSortRecursive(TYPE *pArr, int d, int h, BOOL bAscending);
};

//////////////////////////////////////////////////////////////////////////

template <class TYPE, class ARG_TYPE> 
inline void CSortArray<TYPE, ARG_TYPE>::doQuickSortRecursive(TYPE *pArr, int d, int h, BOOL bAscending)
{
	int  i, j, pvt;
	TYPE src, tmp;

	i   = h;
	j   = d;
	pvt = static_cast<UINT>((d + h) / 2);
	src = pArr[pvt];

	do
	{
		if (bAscending)
		{
			while (pArr[j] < src) j++;
			while (pArr[i] > src) i--;
		}
		else
		{
			while (pArr[j] > src) j++;
			while (pArr[i] < src) i--;
		}

		if (i >= j)
		{

			if (i != j)
			{
				tmp = pArr[i];
				pArr[i] = pArr[j];
				pArr[j] = tmp;

			}

			i--;
			j++;
		}
	}
	while (j <= i);

	if (d < i) doQuickSortRecursive(pArr, d, i, bAscending);
	if (j < h) doQuickSortRecursive(pArr, j, h, bAscending);
}

//////////////////////////////////////////////////////////////////////////

template <class TYPE, class ARG_TYPE> 
inline BOOL CSortArray<TYPE, ARG_TYPE>::doQuickSort(TYPE *pArr, int nSize, BOOL bAscending)
{
	BOOL rc = TRUE;
	int  low, high;

	if (nSize > 1)
	{
		try
		{
			low  = 0;
			high = nSize - 1;

			doQuickSortRecursive(pArr, low, high, bAscending);
		}
		catch (...)
		{
			::SetLastError(ERROR_INVALID_PARAMETER);
			rc = FALSE;
		}
	}
	else
	{
		::SetLastError(ERROR_INVALID_PARAMETER);
		rc = FALSE;
	}

	return rc;
}

//////////////////////////////////////////////////////////////////////////

template <class TYPE, class ARG_TYPE> 
inline void CSortArray<TYPE, ARG_TYPE>::QuickSort(BOOL bAscending/* = TRUE*/)
{
	if (GetSize() > 1)
	{
		doQuickSort(GetData(), GetSize(), bAscending);
	}
}

//////////////////////////////////////////////////////////////////////////
