#include "stdafx.h"
#include "WinCS.h"
#include "SlaveView.h"
#include "WinCSDlg.h"
#include <atlimage.h>

IMPLEMENT_DYNAMIC(CSlaveView, CDialog)

BEGIN_MESSAGE_MAP(CSlaveView, CDialog)
	ON_BN_CLICKED(IDOK, &CSlaveView::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BTN_SLAVE_SEND, &CSlaveView::OnBnClickedBtnSlaveSend)
	ON_WM_CTLCOLOR()
	ON_CBN_SELCHANGE(IDC_CMB_SLAVE_USAGE, &CSlaveView::OnCbnSelchangeCmbSlaveUsage)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CSlaveView::CSlaveView(CWnd* pParent /*=NULL*/)
	: CDialog(CSlaveView::IDD, pParent),
	m_hSystem(NULL),
	m_nUsageMode(0)
{
}

CSlaveView::~CSlaveView()
{
	if (m_hSystem != NULL)
	{
		DeleteTimerQueueTimer(NULL, m_hSystem, NULL);
	}
}

void CSlaveView::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_SLAVE_CONSOLE, m_xEditConsole);
	DDX_Control(pDX, IDC_EDIT_SLAVE_INPUT, m_xEditInput);
	DDX_Control(pDX, IDC_EDIT_SLAVE_PHYSICAL_MEMORY1, m_xEditAvailPhys);
	DDX_Control(pDX, IDC_EDIT_SLAVE_PHYSICAL_MEMORY2, m_xEditTotalPhys);
	DDX_Control(pDX, IDC_EDIT_SLAVE_VIRTUAL_MEMORY1, m_xEditAvailVirtual);
	DDX_Control(pDX, IDC_EDIT_SLAVE_VIRTUAL_MEMORY2, m_xEditTotalVirtual);
	DDX_Control(pDX, IDC_EDIT_SLAVE_USAGE_RATE, m_xEditUsageRate);
	DDX_Control(pDX, IDC_CMB_SLAVE_USAGE, m_xCmbUsageMode);
	DDX_Control(pDX, IDC_EDIT_SLAVE_PROCESSORS1, m_xEditProcessors1);
	DDX_Control(pDX, IDC_EDIT_SLAVE_PROCESSORS2, m_xEditProcessors2);
	DDX_Control(pDX, IDC_EDIT_MASTER_PLUGIN, m_xEditPlugin);
	DDX_Control(pDX, IDC_EDIT_SLAVE_PLUGIN_RUNTIME, m_xEditRuntime1);
	DDX_Control(pDX, IDC_EDIT_SLAVE_BENCHMARK_SCORE, m_xEditScore);
	DDX_Control(pDX, IDC_EDIT_SLAVE_BENCHMARK_RUNTIME, m_xEditRuntime2);
	DDX_Control(pDX, IDC_EDIT_SLAVE_BENCHMARK_TESTTIME, m_xEditTestTime);
	DDX_Control(pDX, IDC_EDIT_SLAVE_BENCHMARK_RANKING1, m_xEditRanking1);
	DDX_Control(pDX, IDC_EDIT_SLAVE_BENCHMARK_RANKING2, m_xEditRanking2);
	DDX_Control(pDX, IDC_EDIT_SLAVE_PLUGIN_STATUS, m_xEditStatus);
	DDX_Control(pDX, IDC_TXT_SLAVE_PLUGIN_PERCENT, m_xTxtPercent);
	DDX_Control(pDX, IDC_PRG_SLAVE_PLUGIN_PROGRESS, m_xProgress);
}

HBRUSH CSlaveView::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_SLAVE_CONSOLE:
	case IDC_EDIT_SLAVE_PHYSICAL_MEMORY1:
	case IDC_EDIT_SLAVE_PHYSICAL_MEMORY2:
	case IDC_EDIT_SLAVE_VIRTUAL_MEMORY1:
	case IDC_EDIT_SLAVE_VIRTUAL_MEMORY2:
	case IDC_EDIT_SLAVE_USAGE_RATE:
	case IDC_EDIT_SLAVE_PROCESSORS1:
	case IDC_EDIT_SLAVE_PROCESSORS2:
	case IDC_EDIT_MASTER_PLUGIN:
	case IDC_EDIT_SLAVE_PLUGIN_STATUS:
	case IDC_EDIT_SLAVE_PLUGIN_RUNTIME:
	case IDC_EDIT_SLAVE_BENCHMARK_SCORE:
	case IDC_EDIT_SLAVE_BENCHMARK_RUNTIME:
	case IDC_EDIT_SLAVE_BENCHMARK_TESTTIME:
	case IDC_EDIT_SLAVE_BENCHMARK_RANKING1:
	case IDC_EDIT_SLAVE_BENCHMARK_RANKING2:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

BOOL CSlaveView::OnInitDialog()
{
	CDialog::OnInitDialog();

	SYSTEM_INFO si;

	GetSystemInfo(&si);
	InitProgress(si.dwNumberOfProcessors);
	SetProcessors(si.dwNumberOfProcessors);
	m_xEditProcessors2.SetWindowText(DwToString(si.dwNumberOfProcessors));
	m_xCmbUsageMode.AddString(_T("Total"));
	m_xCmbUsageMode.AddString(_T("WinCS"));
	m_xCmbUsageMode.SetCurSel(0);
	m_xProgress.SetRange(0, 100);
	m_xEditInput.SetFocus();

	m_xEditAvailPhys.SetWindowText(STRING_NONE);
	m_xEditTotalPhys.SetWindowText(STRING_NONE);
	m_xEditAvailVirtual.SetWindowText(STRING_NONE);
	m_xEditTotalVirtual.SetWindowText(STRING_NONE);
	m_xEditUsageRate.SetWindowText(STRING_NONE);
	m_xEditPlugin.SetWindowText(STRING_NONE);
	m_xEditRuntime1.SetWindowText(STRING_NONE);
	m_xEditScore.SetWindowText(STRING_NONE);
	m_xEditRuntime2.SetWindowText(STRING_NONE);
	m_xEditTestTime.SetWindowText(STRING_NONE);
	m_xEditRanking1.SetWindowText(STRING_NONE);
	m_xEditRanking2.SetWindowText(STRING_NONE);

	if (!CreateTimerQueueTimer(&m_hSystem, NULL, doRefreshSystemInfo, this, 0, 5000, 0))
	{
		m_hSystem = FALSE;
	}

	return FALSE;
}

BOOL CSlaveView::PreTranslateMessage(MSG* pMsg)
{
	if ((pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_RETURN) &&
		(GetFocus() != NULL && GetFocus() == GetDlgItem(IDC_EDIT_SLAVE_INPUT))) 
	{
		SendTextMessage();
		return TRUE;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CSlaveView::SetBenchmarkScore(double dbScore)
{
	CString cs;
	cs.Format(_T("%.4lf GFLOPS"), dbScore);
	m_xEditScore.SetWindowText(cs);
}

void CSlaveView::SetBenchmarkRanking(DWORD dwPosition, DWORD dwAll)
{
	m_xEditRanking1.SetWindowText(DwToString(dwPosition));
	m_xEditRanking2.SetWindowText(DwToString(dwAll));
}

void CSlaveView::SetProgress(DWORD dwIndex, int nPoint)
{
	CSingleLock sl(&m_cs, TRUE);
	CString cs;
	DWORD	dwMinIndex = 0;

	if (dwIndex < m_dwProcessors)
	{
		m_dwPrgList[dwIndex] = nPoint;

		for (UINT i = 0; i < m_dwProcessors; i++)
		{
			dwMinIndex = (m_dwPrgList[dwMinIndex] > m_dwPrgList[i]) ? i : dwMinIndex;
		}

		if (dwMinIndex == dwIndex)
		{
			// Update progress point
			m_xEditStatus.SetWindowText(_T("Running"));
			cs.Format(_T("%d%%"), nPoint);
			m_xTxtPercent.SetWindowText(cs);
			m_xProgress.SetPos(nPoint);
		}
	}
}

void CSlaveView::InitProgress(DWORD dwProcessors)
{
	m_dwProcessors = dwProcessors;
	m_dwPrgList.SetSize(dwProcessors);

	for (UINT i = 0; i < dwProcessors; i++)
	{
		m_dwPrgList[i] = 100;
	}
}

void CSlaveView::EndProgress()
{
	m_xEditStatus.SetWindowText(_T("Finish"));
	m_xTxtPercent.SetWindowText(_T("100%"));
	m_xProgress.SetPos(100);
}

void CSlaveView::SetPluginRuntime(double dbRuntime)
{
	CString cs;

	if (dbRuntime == 0.0)
	{
		cs = STRING_NONE;
	}
	else
	{
		cs.Format(_T("%.4lf sec"), dbRuntime);
	}

	m_xEditRuntime1.SetWindowText(cs);
}

void CSlaveView::ResetBenchmark()
{
	m_xEditScore.SetWindowText(STRING_NONE);
	m_xEditRuntime2.SetWindowText(STRING_NONE);
	m_xEditTestTime.SetWindowText(STRING_NONE);
	m_xEditRanking1.SetWindowText(STRING_NONE);
	m_xEditRanking2.SetWindowText(STRING_NONE);
}

void CSlaveView::OnBnClickedBtnSlaveSend()
{
	SendTextMessage();
}

void CSlaveView::SendTextMessage()
{
	CString cs;
	m_xEditInput.GetWindowText(m_MsgString);

	if (m_MsgString.GetLength() > 0)
	{
		cs.Format(_T("Local message : (%s)\r\n>> %s"), GetNowTime(), m_MsgString);
		AddConsoleText(cs);
		GetParent()->SendMessage(WM_SEND_TEXT);
		m_xEditInput.SetWindowText(STRING_EMPTY);
	}

	m_xEditInput.SetFocus();
}

void CSlaveView::AddConsoleText(const CString &csText, BOOL fReturn)
{
	CString cs;
	BOOL	bFocus;
	int		nLastPos;

	if (csText.GetLength() < 1)
	{
		return;
	}

	cs.Format(_T("%s%s"), csText, fReturn ? STRING_RETURN : STRING_EMPTY);
	nLastPos = m_xEditConsole.GetWindowTextLength();
	bFocus   = FALSE;

	if (::GetFocus() == m_xEditConsole.m_hWnd)
	{
		bFocus = TRUE;
		GetParent()->SetFocus();
	}

	m_xEditConsole.SetSel(nLastPos, nLastPos);
	m_xEditConsole.ReplaceSel(cs);

	if (bFocus)
	{
		m_xEditConsole.SetFocus();
	}
}

// static
void WINAPI CSlaveView::doRefreshSystemInfo(LPVOID pvContext, BOOLEAN fTimeout)
{
	((CSlaveView *)pvContext)->RefreshSystemInfo();
}

void CSlaveView::RefreshSystemInfo()
{
	MEMORYSTATUSEX ms = { sizeof(ms) };
	PDH_HQUERY	   hQuery;
	PDH_HCOUNTER   hCounter;
	CString		   cs;
	PDH_FMT_COUNTERVALUE fntValue;

	GlobalMemoryStatusEx(&ms);

	cs.Format(_T("%I64d"), ms.ullTotalPhys / 1000);
	BigNumToString(cs);
	m_xEditTotalPhys.SetWindowText(cs + _T(" KB"));

	cs.Format(_T("%I64d"), ms.ullAvailPhys / 1000);
	BigNumToString(cs);
	m_xEditAvailPhys.SetWindowText(cs + _T(" KB"));

	cs.Format(_T("%I64d"), ms.ullTotalVirtual / 1000);
	BigNumToString(cs);
	m_xEditTotalVirtual.SetWindowText(cs + _T(" KB"));

	cs.Format(_T("%I64d"), ms.ullAvailVirtual / 1000);
	BigNumToString(cs);
	m_xEditAvailVirtual.SetWindowText(cs + _T(" KB"));


	// Usage rate of processor
	if (PdhOpenQuery(NULL, 0, &hQuery) == ERROR_SUCCESS)
	{
		if (m_nUsageMode == 0)
		{
			PdhAddCounter(hQuery ,_T("\\Processor(_Total)\\% Processor Time"),
						  0, &hCounter);
		}
		else
		{
			PdhAddCounter(hQuery, _T("\\Process(WinCS#0)\\% Processor Time"),
						  0, &hCounter);
		}

		PdhCollectQueryData(hQuery);
		Sleep(1000);
		PdhCollectQueryData(hQuery);
		PdhGetFormattedCounterValue(hCounter, PDH_FMT_LONG, NULL, &fntValue);
		cs.Format(_T("%u %%"), fntValue.longValue);
		m_xEditUsageRate.SetWindowText(cs);
		PdhCloseQuery(hQuery);
	}
}

void CSlaveView::OnCbnSelchangeCmbSlaveUsage()
{
	m_nUsageMode = m_xCmbUsageMode.GetCurSel();
}

void CSlaveView::CancelPlugin()
{
	m_xProgress.SetPos(0);
	m_xTxtPercent.SetWindowText(_T("0%"));
	m_xEditStatus.SetWindowText(_T("Cancel"));
}

//////////////////////////////////////////////////////////////////////////
