#pragma once

#include "afxwin.h"
#include "afxcmn.h"

//////////////////////////////////////////////////////////////////////////

class CPluginTransferDlg : public CDialog, CStringConvert
{
	DECLARE_DYNAMIC(CPluginTransferDlg)

public:
	CPluginTransferDlg(CWnd* pParent = NULL);
	virtual ~CPluginTransferDlg();
	enum { IDD = IDD_PLUGIN_TRANSFER_DIALOG };

	void SetPluginList(const PluginList &list) { m_Pluginlist.Copy(list); }
	void SetPlugin(const CString &cs) { m_xEditPlugin.SetWindowText(cs); }
	void SetSendToSlave(WORD wNodeID, DWORD dwAddress);
	void SetProgress(int nPoint);
	void SetTargetWnd(CWnd *wnd) { m_pTgtWnd = wnd; }
	void GetSendList(IntList &list) { list.Copy(m_SendList); }
	BOOL IsSending() { return m_fSending; }

protected:
	DECLARE_MESSAGE_MAP()
	virtual BOOL OnInitDialog();
	virtual void DoDataExchange(CDataExchange* pDX);

	afx_msg void OnClose();
	afx_msg void OnBnClickedOk() {}
	afx_msg void OnBnClickedBtnPluginTransferSend();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg LRESULT OnPluginTransferError(WPARAM wParam, LPARAM lParam);

public:
	CCheckListBox m_xListPlugin;
	CProgressCtrl m_xProgress;
	CButton		  m_xBtnSend;
	CStatic		  m_xTxtState;
	CStatic		  m_xTxtPercent;
	CEdit		  m_xEditPlugin;
	CEdit		  m_xEditSendTo;

protected:
	PluginList	  m_Pluginlist;
	IntList		  m_SendList;
	HICON		  m_hIcon;
	BOOL		  m_fSending;
	CWnd		  *m_pTgtWnd;
};

//////////////////////////////////////////////////////////////////////////
