#include "stdafx.h"
#include "WinCS.h"
#include "PluginTransferDlg.h"

IMPLEMENT_DYNAMIC(CPluginTransferDlg, CDialog)

BEGIN_MESSAGE_MAP(CPluginTransferDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CPluginTransferDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BTN_PLUGIN_TRANSFER_SEND, &CPluginTransferDlg::OnBnClickedBtnPluginTransferSend)
	ON_WM_CTLCOLOR()
	ON_MESSAGE(WM_PLUGIN_TRANSFER_ERROR, &CPluginTransferDlg::OnPluginTransferError)
	ON_WM_CLOSE()
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CPluginTransferDlg::CPluginTransferDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPluginTransferDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_TRANSFER);
}

CPluginTransferDlg::~CPluginTransferDlg()
{
}

void CPluginTransferDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_PLUGIN_TRANSFER_PLUGIN, m_xListPlugin);
	DDX_Control(pDX, IDC_EDIT_PLUGIN_TRANSFER_PLUGIN, m_xEditPlugin);
	DDX_Control(pDX, IDC_EDIT_PLUGIN_TRANSFER_SENDTO, m_xEditSendTo);
	DDX_Control(pDX, IDC_BTN_PLUGIN_TRANSFER_SEND, m_xBtnSend);
	DDX_Control(pDX, IDC_TXT_PLUGIN_TRANSFER_STATE, m_xTxtState);
	DDX_Control(pDX, IDC_TXT_PLUGIN_TRANSFER_PERCENT, m_xTxtPercent);
	DDX_Control(pDX, IDC_PRG_PLUGIN_TRANSFER_PROGRESS, m_xProgress);
}

HBRUSH CPluginTransferDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_PLUGIN_TRANSFER_PLUGIN:
	case IDC_EDIT_PLUGIN_TRANSFER_SENDTO:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

LRESULT CPluginTransferDlg::OnPluginTransferError(WPARAM wParam, LPARAM lParam)
{
	CString cs1, cs2, csModule;
	UINT    nIndex = static_cast<UINT>(wParam);
	UINT    nSize  = m_Pluginlist.GetSize();

	if (nSize > nIndex)
	{
		csModule = m_Pluginlist[nIndex].csModuleName;
		cs1.LoadString(IDS_WCS_ERROR_PLUGIN_TRANSFER);
		cs2.Format(_T("%s\r\nPlugin: %s"), cs1, csModule);
		AfxMessageBox(cs2);
	}

	return TRUE;
}

void CPluginTransferDlg::OnClose()
{
	m_fSending = FALSE;
	CDialog::OnClose();
}

BOOL CPluginTransferDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	UINT nSize;

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	m_fSending = FALSE;
	m_xProgress.SetRange(0, 100);
	SetProgress(0);

	m_xEditPlugin.SetWindowText(STRING_NONE);
	m_xEditSendTo.SetWindowText(STRING_NONE);

	nSize = m_Pluginlist.GetSize();

	for (UINT i = 0; i < nSize; i++)
	{
		m_xListPlugin.AddString(m_Pluginlist[i].csModuleName);
	}

	return TRUE;
}

void CPluginTransferDlg::OnBnClickedBtnPluginTransferSend()
{
	CString cs;
	UINT nSize = m_xListPlugin.GetCount();

	m_SendList.RemoveAll();

	for (UINT i = 0; i < nSize; i++)
	{
		if (m_xListPlugin.GetCheck(i) == BST_CHECKED)
		{
			m_SendList.Add(i);
		}
	}

	if (m_SendList.GetSize() > 0)
	{
		m_fSending = TRUE;
		m_xBtnSend.EnableWindow(FALSE);
		m_xListPlugin.EnableWindow(FALSE);
		m_pTgtWnd->PostMessage(WM_PLUGIN_SENDING);
	}
	else
	{
		cs.LoadString(IDS_WCS_ERROR_PLUGIN_TRANSFER_SELECT);
		AfxMessageBox(cs);
	}
}

void CPluginTransferDlg::SetSendToSlave(WORD wNodeID, DWORD dwAddress)
{
	CString cs;
	cs.Format(_T("[%d] - %s"), wNodeID, DwToIPAddress(dwAddress));
	m_xEditSendTo.SetWindowText(cs);
}

void CPluginTransferDlg::SetProgress(int nPoint)
{
	CString cs;
	UINT	nSize;

	switch (nPoint)
	{
	case 0:
		m_xTxtState.SetWindowText(_T("Idle"));
		break;

	case 100:
		m_xTxtState.SetWindowText(_T("Finish!"));
		break;

	default:
		m_xTxtState.SetWindowText(_T("Sending..."));
		break;
	}

	cs.Format(_T("%d%%"), nPoint);
	m_xTxtPercent.SetWindowText(cs);
	m_xProgress.SetPos(nPoint);

	if (nPoint == 100)
	{
		CMsgBox::Information(_T("Completed"), _T("Transfer"), m_hWnd);

		m_fSending = FALSE;
		nSize = m_xListPlugin.GetCount();

		for (UINT i = 0; i < nSize; i++)
		{
			m_xListPlugin.SetCheck(i, BST_UNCHECKED);
		}

		m_xBtnSend.EnableWindow(TRUE);
		m_xListPlugin.EnableWindow(TRUE);
		SetProgress(0);
		m_xEditPlugin.SetWindowText(STRING_NONE);
		m_xEditSendTo.SetWindowText(STRING_NONE);	
	}
}

//////////////////////////////////////////////////////////////////////////

