#pragma once

//////////////////////////////////////////////////////////////////////////

#define MSG_ERROR		(MB_OK | MB_ICONSTOP)
#define MSG_EXCLAMATION	(MB_OK | MB_ICONWARNING)
#define MSG_INFORMATION (MB_OK | MB_ICONINFORMATION)
#define MSG_QUESTION	(MB_YESNO | MB_ICONQUESTION)

class CMsgBox
{
public:
	static void Error(LPTSTR szText, LPTSTR szTitle, HWND hWnd = NULL)
	{
		MessageBox(hWnd, szText, szTitle, MSG_ERROR);
	}

	static void Exclamation(LPTSTR szText, LPTSTR szTitle, HWND hWnd = NULL)
	{
		MessageBox(hWnd, szText, szTitle, MSG_EXCLAMATION);
	}

	static void Information(LPTSTR szText, LPTSTR szTitle, HWND hWnd = NULL)
	{
		MessageBox(hWnd, szText, szTitle, MSG_INFORMATION);
	}

	static int Question(LPTSTR szText, LPTSTR szTitle, HWND hWnd = NULL)
	{
		return MessageBox(hWnd, szText, szTitle, MSG_QUESTION);
	}
};

//////////////////////////////////////////////////////////////////////////