#pragma once

//#include <gdiplus.h>
//#pragma comment(lib, "gdiplus.lib")
//////////////////////////////////////////////////////////////////////////

class CImageEx
{
public:
	Gdiplus::Bitmap* m_pBitmap;

public:
	CImageEx()				{ m_pBitmap = NULL; }
	CImageEx(LPCWSTR pFile)	{ m_pBitmap = NULL; Load(pFile); }
	virtual ~CImageEx()		{ Empty(); }

	void Empty()			{ delete m_pBitmap; m_pBitmap = NULL; }

	BOOL Load(LPCWSTR pFile)
	{
		Empty();
		m_pBitmap = Gdiplus::Bitmap::FromFile(pFile);
		return (m_pBitmap->GetLastStatus() == Gdiplus::Ok);
	}

	operator Gdiplus::Bitmap*() const	{ return m_pBitmap; }
};


class CImageExResource : public CImageEx
{
protected:
	HGLOBAL m_hBuffer;

public:
	CImageExResource()
	{ m_hBuffer = NULL; }
	CImageExResource(LPCTSTR pName, LPCTSTR pType = RT_RCDATA, HMODULE hInst = NULL)
	{ m_hBuffer = NULL; Load(pName, pType, hInst); }
	CImageExResource(UINT id, LPCTSTR pType = RT_RCDATA, HMODULE hInst = NULL)
	{ m_hBuffer = NULL; Load(id, pType, hInst); }
	CImageExResource(UINT id, UINT type, HMODULE hInst = NULL)
	{ m_hBuffer = NULL; Load(id, type, hInst); }
	virtual ~CImageExResource()
	{ Empty(); }

	void Empty();
	BOOL Load(LPCTSTR pName, LPCTSTR pType = RT_RCDATA, HMODULE hInst = NULL);
	BOOL Load(UINT id, LPCTSTR pType = RT_RCDATA, HMODULE hInst = NULL)
	{ return Load(MAKEINTRESOURCE(id), pType, hInst); }
	BOOL Load(UINT id, UINT type, HMODULE hInst = NULL)
	{ return Load(MAKEINTRESOURCE(id), MAKEINTRESOURCE(type), hInst); }
};

inline
void CImageExResource::Empty()
{
	CImageEx::Empty();

	if (m_hBuffer)
	{
		::GlobalUnlock(m_hBuffer);
		::GlobalFree(m_hBuffer);
		m_hBuffer = NULL;
	} 
}

inline
BOOL CImageExResource::Load(LPCTSTR pName, LPCTSTR pType, HMODULE hInst)
{
	LPVOID  lpResData;
	LPVOID  lpBuffer;
	HRSRC   hResource;
	DWORD   dwImgSize;
	IStream *pStream = NULL;

	Empty();

	hResource = ::FindResource(hInst, pName, pType);

	if (!hResource)
	{
		return FALSE;
	}

	dwImgSize = ::SizeofResource(hInst, hResource);

	if (!dwImgSize)
	{
		return FALSE;
	}

	lpResData = ::LockResource(::LoadResource(hInst, hResource));
	
	if (!lpResData)
	{
		return FALSE;
	}

	m_hBuffer  = ::GlobalAlloc(GMEM_MOVEABLE, dwImgSize);

	if (m_hBuffer)
	{
		lpBuffer = ::GlobalLock(m_hBuffer);

		if (lpBuffer)
		{
			CopyMemory(lpBuffer, lpResData, dwImgSize);

			if (::CreateStreamOnHGlobal(m_hBuffer, FALSE, &pStream) == S_OK)
			{
				m_pBitmap = Gdiplus::Bitmap::FromStream(pStream);
				pStream->Release();
				
				if (m_pBitmap)
				{ 
					if (m_pBitmap->GetLastStatus() == Gdiplus::Ok)
					{
						return TRUE;
					}

					delete m_pBitmap;
					m_pBitmap = NULL;
				}
			}

			::GlobalUnlock(m_hBuffer);
		}

		::GlobalFree(m_hBuffer);
		m_hBuffer = NULL;
	}

	return FALSE;
}

//////////////////////////////////////////////////////////////////////////
