#include "stdafx.h"
#include "WinCS.h"
#include "FlopsHelpDlg.h"

IMPLEMENT_DYNAMIC(CFlopsHelpDlg, CDialog)

BEGIN_MESSAGE_MAP(CFlopsHelpDlg, CDialog)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDOK, &CFlopsHelpDlg::OnBnClickedOk)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CFlopsHelpDlg::CFlopsHelpDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFlopsHelpDlg::IDD, pParent)
{

}

CFlopsHelpDlg::~CFlopsHelpDlg()
{
}

void CFlopsHelpDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_FLOPSHELP_TEXT, m_xEditText);
}

BOOL CFlopsHelpDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	HGLOBAL hGlobal;
	CString cs;
	LPSTR	lpStr;
	HRSRC   hSrc;
	DWORD	dwSize;

	hSrc = FindResource(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_TEXT_FLOPS), _T("TEXT"));

	if (hSrc == NULL)
	{
		TRACE1("***** ERROR: FindResource(%d) *****\n", GetLastError());
		return EndDialog(IDCANCEL), FALSE;
	}

	dwSize  = SizeofResource(AfxGetInstanceHandle(), hSrc);
	hGlobal = LoadResource(AfxGetInstanceHandle(), hSrc);

	if (hGlobal == NULL)
	{
		TRACE1("***** ERROR: LoadResource(%d) *****\n", GetLastError());
		return EndDialog(IDCANCEL), FALSE;
	}

	lpStr = reinterpret_cast<LPSTR>(LockResource(hGlobal));

	if (lpStr == NULL)
	{
		TRACE1("***** ERROR: LockResource(%d) *****\n", GetLastError());
		return EndDialog(IDCANCEL), FALSE;
	}

	cs.Format(_T("%S"), &lpStr[3]);	// ???
	m_xEditText.SetWindowText(cs);
	FreeResource(hGlobal);

	return TRUE;
}

HBRUSH CFlopsHelpDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_FLOPSHELP_TEXT:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

void CFlopsHelpDlg::OnBnClickedOk()
{
	OnOK();
}

//////////////////////////////////////////////////////////////////////////
