#include "stdafx.h"
#include "WinCS.h"
#include "EXEConfirmDlg.h"

//////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CEXEConfirmDlg, CDialog)

BEGIN_MESSAGE_MAP(CEXEConfirmDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CEXEConfirmDlg::OnBnClickedOk)
	ON_WM_CTLCOLOR()
	ON_CBN_SELCHANGE(IDC_CMB_EXECONFIRM_MODE, &CEXEConfirmDlg::OnCbnSelchangeCmbExeconfirmMode)
END_MESSAGE_MAP()

CEXEConfirmDlg::CEXEConfirmDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEXEConfirmDlg::IDD, pParent),
	m_fSystem(FALSE),
	m_nSlaves(0),
	m_nSystemProcessors(0),
	m_nSingleProcessors(0)
{
	ZeroMemory(&m_CalcSize, sizeof(m_CalcSize));
}

CEXEConfirmDlg::~CEXEConfirmDlg()
{
}

void CEXEConfirmDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CMB_EXECONFIRM_MODE, m_xCmbMode);
	DDX_Control(pDX, IDC_EDIT_EXECONFIRM_SLAVES, m_xEditSlaves);
	DDX_Control(pDX, IDC_EDIT_EXECONFIRM_PLUGIN, m_xEditPlugin);
	DDX_Control(pDX, IDC_EDIT_EXECONFIRM_PARAMS, m_xEditArgument);
	DDX_Control(pDX, IDC_EDIT_EXECONFIRM_WIDTH, m_xEditWidth);
	DDX_Control(pDX, IDC_EDIT_EXECONFIRM_HEIGHT, m_xEditHeight);
	DDX_Control(pDX, IDC_EDIT_EXECONFIRM_RANGE, m_xEditRange);
	DDX_Control(pDX, IDC_EDIT_EXECONFIRM_PROCESSORS, m_xEditProcessors);
}

BOOL CEXEConfirmDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_xCmbMode.AddString(_T("Single"));
	m_xCmbMode.AddString(_T("System"));
	m_xCmbMode.SetCurSel(0);

	m_xEditSlaves.SetWindowText(DwToString(m_nSlaves));
	m_xEditProcessors.SetWindowText(DwToString(m_nSingleProcessors));
	m_xEditPlugin.SetWindowText(m_csModule);
	m_xEditWidth.SetWindowText(DwToString(m_CalcSize.nWidth));
	m_xEditHeight.SetWindowText(DwToString(m_CalcSize.nHeight));
	m_xEditRange.SetWindowText(DwToString(m_CalcSize.nRange));
	m_xEditRange.EnableWindow(FALSE);
	m_xEditArgument.SetFocus();

	return FALSE;
}

void CEXEConfirmDlg::OnBnClickedOk()
{
	CString cs, csRange;
	UINT nWidth, nHeight, nRange;
	BOOL fWidth, fHeight, fRange;
	int  nMode = m_xCmbMode.GetCurSel();

	if ((nMode == 1) && (m_nSlaves < 1))
	{
		cs.LoadString(IDS_WCS_ERROR_EXECUTION_MODE_SELECT);
		AfxMessageBox(cs);
		return;
	}

	nWidth  = GetDlgItemInt(IDC_EDIT_EXECONFIRM_WIDTH, &fWidth, TRUE);
	nHeight = GetDlgItemInt(IDC_EDIT_EXECONFIRM_HEIGHT, &fHeight, TRUE);
	nRange	= GetDlgItemInt(IDC_EDIT_EXECONFIRM_RANGE, &fRange, TRUE);

	if (!fWidth || !fHeight || !fRange)
	{
		cs.LoadString(IDS_WCS_ERROR_INVALID_VALUE);
		AfxMessageBox(cs);
		fWidth ? m_xEditWidth.SetFocus() : (fHeight ? m_xEditHeight.SetFocus() : m_xEditRange.SetFocus());
		return;
	}

	if ((m_nSlaves * nRange) > nWidth || nRange < 1)
	{
		csRange.LoadString(IDS_WCS_ERROR_CALCULATION_RANGE);
		cs.Format(_T("%s\r\nRange: 1 - %d"), csRange, (nWidth / m_nSlaves));
		AfxMessageBox(cs);
		m_xEditRange.SetFocus();
		return;
	}

	m_CalcSize.nWidth  = nWidth;
	m_CalcSize.nHeight = nHeight;
	m_CalcSize.nRange  = nRange;
	m_fSystem = (nMode == 1);
	m_xEditArgument.GetWindowText(m_csArgument);

	OnOK();
}

HBRUSH CEXEConfirmDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_EXECONFIRM_SLAVES:
	case IDC_EDIT_EXECONFIRM_PLUGIN:
	case IDC_EDIT_EXECONFIRM_PROCESSORS:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

void CEXEConfirmDlg::OnCbnSelchangeCmbExeconfirmMode()
{
	BOOL fSystem = (m_xCmbMode.GetCurSel() == 1);
	UINT nProcessors = fSystem ? m_nSystemProcessors : m_nSingleProcessors;
	m_xEditProcessors.SetWindowText(DwToString(nProcessors));
	m_xEditRange.EnableWindow(fSystem);
}

//////////////////////////////////////////////////////////////////////////

