#include "stdafx.h"
#include "WinCS.h"
#include "ClientSocket.h"
#include "WinCSDlg.h"

//////////////////////////////////////////////////////////////////////////

CSocketEx::CSocketEx()
{
	m_hTimer = NULL;
}

CSocketEx::~CSocketEx()
{
}

BOOL CSocketEx::SetTimeOut(DWORD dwTimeout)
{
	return CreateTimerQueueTimer(&m_hTimer, NULL, CSocketEx::WaitTimer,
			this, dwTimeout, dwTimeout, 0);
}

BOOL CSocketEx::KillTimeOut()
{
	if (m_hTimer != NULL)
	{
		DeleteTimerQueueTimer(NULL, m_hTimer, NULL);
		CancelBlockingCall();
		m_hTimer = NULL;
	}
	return TRUE;
}

BOOL CSocketEx::Connect(const SOCKADDR* lpSockAddr, int nSockAddrLen, DWORD dwTimeout)
{
	
	if (dwTimeout > 0)
		SetTimeOut(dwTimeout);

	// {NX̊֐Ăяo
	BOOL fRet = CSocket::Connect(lpSockAddr, nSockAddrLen);

	// ^CAEglݒ肵Ăꍇ
	if (dwTimeout > 0)
	{
		KillTimeOut();
		// 삪^CAEgɂȂꍇ́A
		// ƎRȃG[bZ[W\
		if (GetLastError() == WSAEINTR)
			SetLastError(WSAETIMEDOUT);
	}
	return fRet;
}


//////////////////////////////////////////////////////////////////////////

CClientSocket::CClientSocket()
{
}

CClientSocket::~CClientSocket()
{
	
}

void CClientSocket::OnConnect(int nErrorCode)
{
	((CWinCSDlg *)AfxGetApp()->m_pMainWnd)->OnClientConnect(nErrorCode);
}

void CClientSocket::OnSend(int nErrorCode)
{
	((CWinCSDlg *)AfxGetApp()->m_pMainWnd)->OnClientSend(nErrorCode);
}

void CClientSocket::OnReceive(int nErrorCode)
{
	((CWinCSDlg *)AfxGetApp()->m_pMainWnd)->OnClientRecieve(nErrorCode);
}

void CClientSocket::OnClose(int nErrorCode)
{
	((CWinCSDlg *)AfxGetApp()->m_pMainWnd)->OnClientClose(nErrorCode);
}