#include "stdafx.h"
#include "WinCS.h"
#include "BMSystemDlg.h"
#include "FlopsHelpDlg.h"

IMPLEMENT_DYNAMIC(CBMSystemDlg, CDialog)

BEGIN_MESSAGE_MAP(CBMSystemDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CBMSystemDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BTN_BMSYSTEM_CLOSE, &CBMSystemDlg::OnBnClickedBtnBmsystemClose)
	ON_BN_CLICKED(IDC_BTN_BMSYSTEM_HELP, &CBMSystemDlg::OnBnClickedBtnBmsystemHelp)
	ON_WM_CTLCOLOR()
	ON_WM_SYSCOMMAND()
	ON_BN_CLICKED(IDC_BTN_BMSYSTEM_LOG, &CBMSystemDlg::OnBnClickedBtnBmsystemLog)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CBMSystemDlg::CBMSystemDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBMSystemDlg::IDD, pParent),
	m_fEnd(FALSE),
	m_hTimer(NULL)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_BENCHMARK);
}

CBMSystemDlg::~CBMSystemDlg()
{
	if (!m_fEnd)
	{
		StopTimer();
	}
}

void CBMSystemDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_BMSYSTEM_NODE, m_xNodeList);
	DDX_Control(pDX, IDC_PRG_BMSYSTEM_PROGRESS, m_xProgress);
	DDX_Control(pDX, IDC_TXT_BMSYSTEM_PERCENT, m_xTxtPercent);
	DDX_Control(pDX, IDC_IMG_BMSYSTEM_LOADER, m_xImgLoader);
	DDX_Control(pDX, IDC_TXT_BMSYSTEM_STATE, m_xTxtState);
	DDX_Control(pDX, IDC_EDIT_BMSYSTEM_RUNTIME, m_xEditRuntime);
	DDX_Control(pDX, IDC_EDIT_BMSYSTEM_NODES, m_xEditNodes);
	DDX_Control(pDX, IDC_EDIT_BMSYSTEM_TOTAL, m_xEditTotal);
	DDX_Control(pDX, IDC_EDIT_BMSYSTEM_AVERAGE, m_xEditAverage);
	DDX_Control(pDX, IDC_EDIT_BMSYSTEM_PROCESSORS, m_xEditProcessors);
	DDX_Control(pDX, IDC_EDIT_BMSYSTEM_HIGH, m_xEditHigh);
	DDX_Control(pDX, IDC_EDIT_BMSYSTEM_LOW, m_xEditLow);
	DDX_Control(pDX, IDC_BTN_BMSYSTEM_LOG, m_xBtnLog);
}

HBRUSH CBMSystemDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_BMSYSTEM_AVERAGE:
	case IDC_EDIT_BMSYSTEM_NODES:
	case IDC_EDIT_BMSYSTEM_PROCESSORS:
	case IDC_EDIT_BMSYSTEM_RUNTIME:
	case IDC_EDIT_BMSYSTEM_TOTAL:
	case IDC_EDIT_BMSYSTEM_HIGH:
	case IDC_EDIT_BMSYSTEM_LOW:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

void CBMSystemDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if (nID == SC_CLOSE)
	{
		return;
	}

	CDialog::OnSysCommand(nID, lParam);
}

BOOL CBMSystemDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	LVCOLUMN lvc;
	LVITEM   lvi;
	CString  cs;
	CRect	 cr;
	UINT	 nSize, nProcessors;

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	lvc.mask = (LVCF_FMT | LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM);
	m_xNodeList.GetClientRect(&cr);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 3 / 30;
	lvc.pszText	= _T("ID");
	m_xNodeList.InsertColumn(0, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 8 / 30;
	lvc.pszText	= _T("IP Address");
	m_xNodeList.InsertColumn(1, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 6 / 30;
	lvc.pszText	= _T("Progress");
	m_xNodeList.InsertColumn(2, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 6 / 30;
	lvc.pszText	= _T("Runtime");
	m_xNodeList.InsertColumn(3, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 6 / 30;
	lvc.pszText	= _T("GFLOPS");
	m_xNodeList.InsertColumn(4, &lvc);

	m_xNodeList.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_xProgress.SetRange(0, 100);
	
	if (m_xImgLoader.Load(MAKEINTRESOURCE(IDR_LOADER_INDICATOR), _T("GIF")))
	{
		m_xImgLoader.Draw();
	}

	m_NodeList.RemoveAt(0);
	nSize = m_NodeList.GetSize();
	nProcessors = 0;

	for (UINT i = 0; i < nSize; i++)
	{
		nProcessors += m_NodeList[i].dwProcessors;
	}

	lvi.mask = (LVIF_TEXT | LVIF_IMAGE);

	for (UINT i = 0; i < nSize; i++)
	{
		cs = DwToString(m_NodeList[i].wNodeID);
		lvi.iItem	 = i;
		lvi.iSubItem = 0;
		lvi.pszText  = MC_CStoSTR(cs);
		m_xNodeList.InsertItem(&lvi);

		cs = DwToIPAddress(m_NodeList[i].dwAddress);
		lvi.iItem	 = i;
		lvi.iSubItem = 1;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);

		cs = _T("0%");
		lvi.iItem	 = i;
		lvi.iSubItem = 2;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);

		cs = STRING_NONE;
		lvi.iItem	 = i;
		lvi.iSubItem = 3;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);

		cs = STRING_NONE;
		lvi.iItem	 = i;
		lvi.iSubItem = 4;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);
	}

	m_xEditNodes.SetWindowText(DwToString(nSize));
	m_xEditProcessors.SetWindowText(DwToString(nProcessors));
	m_xEditTotal.SetWindowText(STRING_NONE);
	m_xEditAverage.SetWindowText(STRING_NONE);
	m_xEditHigh.SetWindowTextW(STRING_NONE);
	m_xEditLow.SetWindowText(STRING_NONE);
	m_xBtnLog.EnableWindow(FALSE);

	if (!StartTimer())
	{
		TRACE1("***** ERROR: StartTimer(%d) *****\n", GetLastError());
		return EndDialog(IDCANCEL), FALSE;
	}

	return FALSE;
}

void CBMSystemDlg::OnBnClickedBtnBmsystemClose()
{
	CString cs;
	int     nRet;

	if (m_fEnd)
	{
		EndDialog(IDOK);
	}
	else
	{
		cs.LoadString(IDS_WCS_TEXT_BMTEST_EXIT_CONFIRM);
		nRet = CMsgBox::Question(MC_CStoSTR(cs), _T("Benchmark Test"));

		if (nRet == IDYES)
		{
			StopTimer();
			EndDialog(IDCANCEL);
		}
	}
}

void CBMSystemDlg::OnBnClickedBtnBmsystemHelp()
{
	CFlopsHelpDlg dlg;
	dlg.DoModal();
}

void CBMSystemDlg::SetNodeList(const NodeDataList &list)
{
	m_NodeList.RemoveAll();
	m_NodeList.Copy(list);
}

void CBMSystemDlg::SetProgressPoint(WORD wNodeID, int nPoint)
{
	CString cs;
	LVITEM  lvi;
	int nIndex = SearchNodeListIndex(wNodeID);

	if (nIndex != -1)
	{
		CSingleLock sl(&m_cs, TRUE);

		lvi.mask = (LVIF_TEXT | LVIF_IMAGE);
		cs.Format(_T("%d%%"), nPoint);
		lvi.iItem	 = nIndex;
		lvi.iSubItem = 2;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);
	}
}

void CBMSystemDlg::SetProgress(int nPoint)
{
	CString cs;

	cs.Format(_T("%d%%"), nPoint);
	m_xTxtPercent.SetWindowText(cs);
	m_xProgress.SetPos(nPoint);

	if (nPoint == 100)
	{
		m_xImgLoader.Stop();
		m_xImgLoader.ShowWindow(SW_HIDE);
		m_xTxtState.SetWindowText(_T("Finish!"));
		StopTimer();
		m_fEnd = TRUE;
	}
}

int CBMSystemDlg::SearchNodeListIndex(WORD wNodeID)
{
	int  nIndex = -1;
	UINT nItemCount;
	BOOL find = FALSE;

	CSingleLock sl(&m_cs, TRUE);
	nItemCount = m_xNodeList.GetItemCount();

	for (UINT i = 0; i < nItemCount; i++)
	{
		if (m_xNodeList.GetItemText(i, 0) == DwToString(wNodeID))
		{
			nIndex = i;
			break;
		}
	}

	return nIndex;
}

void WINAPI CBMSystemDlg::doRuntimeTimer(LPVOID pvContext, BOOLEAN fTimeout)
{
	((CBMSystemDlg *)pvContext)->RuntimeTimer();
}

void CBMSystemDlg::RuntimeTimer()
{
	CString cs;
	m_Stopwatch.GetHMS(cs);
	m_xEditRuntime.SetWindowText(cs);
}

BOOL CBMSystemDlg::StartTimer()
{
	m_Stopwatch.Start();
	RuntimeTimer();

	if (!CreateTimerQueueTimer(&m_hTimer, NULL, doRuntimeTimer, this, 500, 500, 0))
	{
		m_hTimer = NULL;
		return FALSE;
	}

	return TRUE;
}

void CBMSystemDlg::StopTimer()
{
	if (m_hTimer != NULL)
	{
		DeleteTimerQueueTimer(NULL, m_hTimer, NULL);
		m_hTimer = NULL;
	}
}

void CBMSystemDlg::SetTestScore(WORD wNodeID, BM_DATA bm)
{
	CString cs;
	LVITEM  lvi;
	int nIndex = SearchNodeListIndex(wNodeID);

	if (nIndex != -1)
	{
		CSingleLock sl(&m_cs, TRUE);

		lvi.mask = (LVIF_TEXT | LVIF_IMAGE);

		cs = DbToHMSTime(bm.dbRuntime);
		lvi.iItem	 = nIndex;
		lvi.iSubItem = 3;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);

		cs.Format(_T("%.4lf"), bm.dbRltAvg);
		lvi.iItem	 = nIndex;
		lvi.iSubItem = 4;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xNodeList.SetItem(&lvi);
	}
}

void CBMSystemDlg::SetSystemScore(BM_SYSTEMSCORE bmScore, const CString &csLogPath)
{
	CString cs;

	m_LogPath = csLogPath;
	cs.Format(_T("%.4lf GFLOPS"), bmScore.dbTotal);
	m_xEditTotal.SetWindowText(cs);
	cs.Format(_T("%.4lf GFLOPS"), bmScore.dbAvg);
	m_xEditAverage.SetWindowText(cs);
	cs.Format(_T("%.4lf GFLOPS"), bmScore.dbHigh);
	m_xEditHigh.SetWindowText(cs);
	cs.Format(_T("%.4lf GFLOPS"), bmScore.dbLow);
	m_xEditLow.SetWindowText(cs);
	m_xBtnLog.EnableWindow(TRUE);
}

void CBMSystemDlg::OnBnClickedBtnBmsystemLog()
{
	SHELLEXECUTEINFO sei;
	CString			 cs;

	ZeroMemory(&sei, sizeof(sei));
	sei.cbSize = sizeof(SHELLEXECUTEINFO);						
	sei.hwnd   = m_hWnd;											
	sei.nShow  = SW_SHOWNORMAL;									
	sei.fMask  = SEE_MASK_NOCLOSEPROCESS;						
	sei.lpFile = MC_CStoSTR(m_LogPath);								

	if(!ShellExecuteEx(&sei) || reinterpret_cast<int>(sei.hInstApp) <= 32)
	{	
		TRACE1("***** ERROR: OnShowLog(%d) *****\n", GetLastError());
		cs.LoadString(IDS_WCS_ERROR_SHOW_LOG);
		AfxMessageBox(cs);
		return;
	}

	WaitForSingleObject(sei.hProcess, INFINITE);
	CloseHandle(sei.hProcess);
}

//////////////////////////////////////////////////////////////////////////
