#include "stdafx.h"
#include "WinCS.h"
#include "BMSingleDlg.h"
#include "Flops.h"
#include "FlopsHelpDlg.h"

IMPLEMENT_DYNAMIC(CBMSingleDlg, CDialog)

BEGIN_MESSAGE_MAP(CBMSingleDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CBMSingleDlg::OnBnClickedOk)
	ON_WM_CTLCOLOR()
	ON_WM_SYSCOMMAND()
	ON_MESSAGE(WM_BMSYSTEM_FINISH, &CBMSingleDlg::OnBMTestFinish)
	ON_BN_CLICKED(IDC_BTN_BMSINGLE_CLOSE, &CBMSingleDlg::OnBnClickedBtnBmsingleClose)
	ON_BN_CLICKED(IDC_BTN_BMSINGLE_HELP, &CBMSingleDlg::OnBnClickedBtnBmsingleHelp)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CBMSingleDlg::CBMSingleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBMSingleDlg::IDD, pParent),
	m_hTimer(NULL),
	m_dwProcessors(0),
	m_fEnd(FALSE),
	m_wNodeType(WCS_NODE_UNDEFINED)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_BENCHMARK);
}

CBMSingleDlg::~CBMSingleDlg()
{
	CloseHandleList();
}

void CBMSingleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_BMSINGLE_DATA, m_xDataList);
	DDX_Control(pDX, IDC_IMG_BMSINGLE_LOADER, m_xImgLoader);
	DDX_Control(pDX, IDC_EDIT_BMSINGLE_AVERAGE, m_xEditAverage);
	DDX_Control(pDX, IDC_EDIT_BMSINGLE_RUNTIME, m_xEditRuntime);
	DDX_Control(pDX, IDC_EDIT_BMSINGLE_PROCESSORS, m_xEditProcessors);
	DDX_Control(pDX, IDC_PRG_BMSINGLE_PROGRESS, m_xProgress);
	DDX_Control(pDX, IDC_TXT_BMSINGLE_PERCENT, m_xTxtPercent);
	DDX_Control(pDX, IDC_TXT_BMSINGLE_STATE, m_xTxtState);
	DDX_Control(pDX, IDC_BTN_BMSINGLE_CLOSE, m_xBtnClose);
}


void CBMSingleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if (nID == SC_CLOSE)
	{
		return;
	}

	CDialog::OnSysCommand(nID, lParam);
}

void CBMSingleDlg::CloseHandleList()
{
	CSingleLock sl(&m_cs, TRUE);
	UINT nSize = static_cast<UINT>(m_ThdList.GetSize());

	if (nSize > 0)
	{
		for (UINT i = 0; i < nSize; i++)
		{
			if (m_ThdList[i] != NULL)
			{
				CloseHandle(m_ThdList[i]);
			}
		}

		m_ThdList.RemoveAll();
	}
}

void CBMSingleDlg::OnBnClickedBtnBmsingleClose()
{
	CloseSingleBenchmark();
}

void CBMSingleDlg::CancelBenchmarkTest()
{
	CloseSingleBenchmark();
}

void CBMSingleDlg::CloseSingleBenchmark()
{
	CString cs;
	UINT    nSize;
	int		nRet;

	if (!m_fEnd)
	{
		if (m_wNodeType == WCS_NODE_MASTER)
		{
			cs.LoadString(IDS_WCS_TEXT_BMTEST_EXIT_CONFIRM);
			nRet = CMsgBox::Question(MC_CStoSTR(cs), _T("Benchmark Test"));

			if (nRet != IDYES)
			{
				return;
			}
		}

		nSize = static_cast<UINT>(m_ThdList.GetSize());

		for (UINT i = 0; i < nSize; i++)
		{
			m_fpList[i].fAlive = FALSE;
		}

		StopTimer(TRUE);
		WaitForMultipleObjects(nSize, &m_ThdList[0], TRUE, INFINITE);
		CloseHandleList();
		EndDialog(IDCANCEL);
	}
	else
	{
		// Default finish
		CloseHandleList();
		EndDialog(IDOK);
	}
}

BOOL CBMSingleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	LVCOLUMN	lvc;
	CRect		cr;

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	m_bmResult.dwAftyCnt = 0;
	ZeroMemory(&m_bmResult.bm, sizeof(m_bmResult.bm));

	m_fpList.SetSize(m_dwProcessors);
	m_bpList.SetSize(m_dwProcessors);
	m_ThdIDList.SetSize(m_dwProcessors);
	m_ThdList.SetSize(m_dwProcessors);
	
	lvc.mask = (LVCF_FMT | LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM);
	m_xDataList.GetClientRect(&cr);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 2 / 10;
	lvc.pszText	= _T("Module");
	m_xDataList.InsertColumn(0, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 4 / 10;
	lvc.pszText	= _T("Runtime");
	m_xDataList.InsertColumn(1, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 4 / 10;
	lvc.pszText	= _T("FLOPS");
	m_xDataList.InsertColumn(2, &lvc);

	m_xDataList.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_xProgress.SetRange(0, 100);
	m_xBtnClose.EnableWindow(m_wNodeType == WCS_NODE_MASTER);
	m_xBtnClose.ShowWindow((m_wNodeType == WCS_NODE_MASTER) ? SW_SHOW : SW_HIDE);

	if (m_xImgLoader.Load(MAKEINTRESOURCE(IDR_LOADER_INDICATOR), _T("GIF")))
	{
		m_xImgLoader.Draw();
	}

	m_xEditAverage.SetWindowText(STRING_NONE);
	m_xEditProcessors.SetWindowText(DwToString(m_dwProcessors));

	for (UINT i = 0; i < 8; i++)
	{
		m_Affinity.dwAftyCntArray[i]    = 0;
		m_Affinity.bpArray[i].nIndex    = i;
		m_Affinity.bpArray[i].dbError   = 0.0;
		m_Affinity.bpArray[i].dbGFLOPS  = 0.0;
		m_Affinity.bpArray[i].dbRuntime = 0.0;
	}

	for (UINT i = 0; i < 11; i++)
	{
		m_PrgPoint.dwPointArray[i] = 0;
	}

	if (!StartTimer())
	{
		TRACE1("***** ERROR: StartTimer(%d) *****\n", GetLastError());
		return EndDialog(IDCANCEL), FALSE;
	}

	if (!StartBenchmarkTest())
	{
		TRACE1("***** ERROR: StartBenchmarkTest(%d) *****\n", GetLastError());
		return EndDialog(IDCANCEL), FALSE;
	}

	return TRUE;
}

HBRUSH CBMSingleDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_BMSINGLE_AVERAGE:
	case IDC_EDIT_BMSINGLE_RUNTIME:
	case IDC_EDIT_BMSINGLE_PROCESSORS:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

LRESULT CBMSingleDlg::OnBMTestFinish(WPARAM wParam, LPARAM lParam)
{
	BenchmarkTestFinish();
	return 0;
}

BOOL CBMSingleDlg::StartTimer()
{
	m_Stopwatch.Start();
	RuntimeTimer();

	if (!CreateTimerQueueTimer(&m_hTimer, NULL, doRuntimeTimer, this, 500, 500, 0))
	{
		m_hTimer = NULL;
		return FALSE;
	}

	return TRUE;
}

void CBMSingleDlg::StopTimer(BOOL fForce)
{
	if (((fForce) || (m_bmResult.dwAftyCnt == m_dwProcessors)) && (m_hTimer != NULL))
	{
		DeleteTimerQueueTimer(NULL, m_hTimer, NULL);
		m_hTimer = NULL;
	}
}

DWORD WINAPI CBMSingleDlg::doBenchmark(LPVOID pvParam)
{
	typedef std::tr1::shared_ptr<CFlops> FlopsPtr;

	LPFLOPS_PARAMS lpFP = static_cast<LPFLOPS_PARAMS>(pvParam);
	CBMSingleDlg *dlg = lpFP->obj;
	DWORD  dwAffinity = lpFP->dwAffinity;
	DWORD  dwIndex = lpFP->dwIndex;
	FlopsPtr flops;
	BM_DATA  bm;
	HANDLE	 hCurrent;
	BOOL     fOutput;

	// Set Affinity
	hCurrent = GetCurrentThread();

	if (SetThreadAffinityMask(hCurrent, dwAffinity) == 0)
	{
		TRACE2("***** ERROR: SetThreadAffinityMask(%d) Processor(%d)", GetLastError(), dwIndex);
		return 0;
	}
	/*if (SetThreadIdealProcessor(hCurrent, dwAffinity) == -1)
	{
		TRACE2("***** ERROR: SetThreadIdealProcessor(%d) Processor(%d)", GetLastError(), dwIndex);
		return 0;
	}*/

	try
	{
		flops = FlopsPtr(new CFlops(dlg));
	}
	catch (std::bad_alloc &)
	{
		TRACE0("***** ERROR: shared_ptr(bad_alloc) *****\n");
		return 0;
	}

	if (flops->Start(dwIndex))
	{
		bm.dbRlt1       = flops->GetGFLOPS1();
		bm.dbRlt2       = flops->GetGFLOPS2();
		bm.dbRlt3       = flops->GetGFLOPS3();
		bm.dbRlt4       = flops->GetGFLOPS4();
		bm.dwIterations = flops->GetIterations();
		bm.dbRuntime    = dlg->GetTimer().NowBySecond();

		dlg->SetBMData(dwIndex, bm, &fOutput);
		
		if (fOutput)
		{
			dlg->OutputBenchmarkResult();	// Result output
		}
	}

	dlg->PostMessage(WM_BMSYSTEM_FINISH);

	return 0;
}

void WINAPI CBMSingleDlg::doRuntimeTimer(LPVOID pvContext, BOOLEAN fTimeout)
{
	((CBMSingleDlg *)pvContext)->RuntimeTimer();
}

void CBMSingleDlg::RuntimeTimer()
{
	CString cs;
	m_Stopwatch.GetHMS(cs);
	m_xEditRuntime.SetWindowText(cs);
}

BOOL CBMSingleDlg::StartBenchmarkTest()
{
	// Create thread
	for (UINT i = 0; i < m_dwProcessors; i++)
	{
		m_fpList[i].obj = this;
		m_fpList[i].dwIndex = i;
		m_fpList[i].dwAffinity = (0x0001 << i);
		m_fpList[i].fAlive = TRUE;

		m_ThdList[i] = MC_BEGINTHREADEX(NULL, 
										 0,
										 CBMSingleDlg::doBenchmark,
										 &m_fpList[i],
										 CREATE_SUSPENDED,
										 &m_ThdIDList[i]);
	}

	// Start thread
	for (UINT i = 0; i < m_dwProcessors; i++)
	{
		ResumeThread(m_ThdList[i]);
	}

	for (UINT i = 0; i < m_dwProcessors; i++)
	{
		if (m_ThdList[i] == NULL)
		{
			return FALSE;
		}
	}

	return TRUE;
}

void CBMSingleDlg::BenchmarkTestFinish()
{
	DWORD dwCount;

	StopTimer(FALSE);

	if (m_wNodeType == WCS_NODE_SLAVE)
	{
		if (m_bmResult.dwAftyCnt == m_dwProcessors)
		{
			// Automatic termination(Slave)
			dwCount = static_cast<DWORD>(m_ThdList.GetSize());
			WaitForMultipleObjects(dwCount, m_ThdList.GetData(), TRUE, INFINITE);
			CloseHandleList();
			EndDialog(IDOK);
		}
	}
}

void CBMSingleDlg::OutputBenchmarkResult()
{
	CString csAvg;

	if (m_bmResult.dwAftyCnt == m_dwProcessors)
	{
		csAvg.Format(_T("%.4lf GFLOPS"), m_bmResult.bm.dbRltAvg);
		m_xEditAverage.SetWindowText(csAvg);
		m_xTxtState.SetWindowText(_T("Finish!"));
		m_xImgLoader.Stop();
		m_xImgLoader.ShowWindow(SW_HIDE);
		SaveReport();
		m_fEnd = TRUE;
	}
}

void CBMSingleDlg::SetBMData(DWORD dwIndex, BM_DATA bm, LPBOOL lpfOutput)
{
	m_bmResult.lock.Enter();

	m_bmResult.dwAftyCnt++;
	m_bmResult.bm.dbRlt1	+= bm.dbRlt1;
	m_bmResult.bm.dbRlt2	+= bm.dbRlt2;
	m_bmResult.bm.dbRlt3	+= bm.dbRlt3;
	m_bmResult.bm.dbRlt4	+= bm.dbRlt4;
	m_bmResult.bm.dbRuntime += bm.dbRuntime;

	m_bpList[dwIndex].bm = bm;
	m_bmResult.bm.fSet = (m_bmResult.dwAftyCnt == m_dwProcessors);
	*lpfOutput = (m_bmResult.dwAftyCnt == m_dwProcessors);

	if (m_bmResult.bm.fSet)
	{
		m_bmResult.bm.dbRuntime    /= m_bmResult.dwAftyCnt;
		m_bmResult.bm.dwIterations =  bm.dwIterations;
		m_bmResult.bm.dwProcessors =  m_dwProcessors;

		for (UINT i = 0; i < m_dwProcessors; i++)
		{
			m_bmResult.bm.dbRltAvg += m_Affinity.bpArray[i].dbGFLOPS;
		}

		m_bmResult.bm.dbRltAvg /= m_dwProcessors;
	}

	m_bmResult.lock.Leave();
}

void CBMSingleDlg::SetProgressPoint(int nPoint)
{
	TCHAR szParcent[5];
	BOOL  fOutput;
	int   nProgPoint = nPoint / 10;

	m_PrgPoint.lock.Enter();
	m_PrgPoint.dwPointArray[nProgPoint]++;
	fOutput = (m_PrgPoint.dwPointArray[nProgPoint] == m_dwProcessors);
	m_PrgPoint.lock.Leave();

	if (fOutput)
	{
		wsprintf(szParcent, _T("%d%%"), nPoint);
		m_xTxtPercent.SetWindowText(szParcent);
		m_xProgress.SetPos(nPoint);

		if (m_wNodeType == WCS_NODE_SLAVE)
		{
			// Send progress status
			GetParent()->SendMessage(WM_BMSYSTEM_PROGRESS, (WPARAM)nProgPoint);
		}	
	}
}
void CBMSingleDlg::SetProcessData(BM_PROCESS bp)
{
	CString cs;
	LVITEM  lvi;
	BOOL    fOutput;
	UINT    nListSize;

	m_Affinity.lock.Enter();

	if (m_Affinity.dwAftyCntArray[bp.nIndex - 1] < m_dwProcessors)
	{
		m_Affinity.dwAftyCntArray[bp.nIndex - 1]++;
		m_Affinity.bpArray[bp.nIndex - 1].nIndex	=  bp.nIndex;
		m_Affinity.bpArray[bp.nIndex - 1].dbGFLOPS  += bp.dbGFLOPS;
		m_Affinity.bpArray[bp.nIndex - 1].dbRuntime += bp.dbRuntime;
		m_Affinity.bpArray[bp.nIndex - 1].dbError	+= bp.dbError;

		fOutput = (m_Affinity.dwAftyCntArray[bp.nIndex - 1] == m_dwProcessors);
		
		if (fOutput)
		{
			m_Affinity.bpArray[bp.nIndex - 1].dbRuntime /= m_dwProcessors;
			m_Affinity.bpArray[bp.nIndex - 1].dbError	/= m_dwProcessors;
		}
	}

	m_Affinity.lock.Leave();

	if (fOutput)
	{
		lvi.mask = (LVIF_TEXT | LVIF_IMAGE);
		nListSize = m_xDataList.GetItemCount();

		cs = DwToString(bp.nIndex);
		lvi.iItem	 = nListSize;
		lvi.iSubItem = 0;
		lvi.pszText  = MC_CStoSTR(cs);
		m_xDataList.InsertItem(&lvi);

		cs.Format(_T("%.4lf sec"), m_Affinity.bpArray[bp.nIndex - 1].dbRuntime);
		lvi.iItem	 = nListSize;
		lvi.iSubItem = 1;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xDataList.SetItem(&lvi);

		cs.Format(_T("%.4lf GFLOPS"), m_Affinity.bpArray[bp.nIndex - 1].dbGFLOPS += bp.dbGFLOPS);
		lvi.iItem	 = nListSize;
		lvi.iSubItem = 2;
		lvi.pszText	 = MC_CStoSTR(cs);
		m_xDataList.SetItem(&lvi);
	}
}

void CBMSingleDlg::OnBnClickedBtnBmsingleHelp()
{
	CFlopsHelpDlg dlg;
	dlg.DoModal();
}

BOOL CBMSingleDlg::SaveReport()
{
	SYSTEMTIME  st;
	CString     csRuntime, csReport, csText, csTime, csTxtPath;
	HANDLE		hFile;
	double		dbMax, dbMin;
	DWORD		dwFileSize, dwWriteSize;

	GetLocalTime(&st);
	csTxtPath.Format(_T("./Log/Benchmark/Single_%04d%02d%02d%02d%02d%02d.html"), 
					 st.wYear, st.wMonth, st.wDay,
					 st.wHour, st.wMinute, st.wSecond);
	
	dbMax = 0.0;
	dbMin = static_cast<double>(INT_MAX);

	for (UINT i = 0; i < 8; i++)
	{
		dbMax = max(dbMax, m_Affinity.bpArray[i].dbGFLOPS);
		dbMin = min(dbMin, m_Affinity.bpArray[i].dbGFLOPS);
	}

	m_xEditRuntime.GetWindowText(csRuntime);
	csTime.Format(_T("%04d/%02d/%02d %02d:%02d:%02d"),
				  st.wYear, st.wMonth, st.wDay,
				  st.wHour, st.wMinute, st.wSecond);
	csReport.Format(LOG_TEMPLATE_HTML_BENCHMARK_SINGLE_DATA,
				    m_Affinity.bpArray[0].dbGFLOPS,
				    m_Affinity.bpArray[1].dbGFLOPS,
				    m_Affinity.bpArray[2].dbGFLOPS,
				    m_Affinity.bpArray[3].dbGFLOPS,
				    m_Affinity.bpArray[4].dbGFLOPS,
				    m_Affinity.bpArray[5].dbGFLOPS,
				    m_Affinity.bpArray[6].dbGFLOPS,
				    m_Affinity.bpArray[7].dbGFLOPS);

	csText.Format(LOG_TEMPLATE_HTML_BENCHMARK_CONTAINER,
				  _T("Single"),								// Mode
				  csTime,									// DateTime
				  1,										// Nodes
				  m_dwProcessors,							// Processors
				  csRuntime,								// Runtime
				  STRING_EMPTY,								// (Total)
				  m_bmResult.bm.dbRltAvg,					// Average
				  dbMax,									// High score
				  dbMin,									// Low score
				  csReport);								// Report data

	hFile = CreateFile(csTxtPath, GENERIC_WRITE, 0, NULL, CREATE_NEW,
					   FILE_ATTRIBUTE_NORMAL, NULL);

	if (hFile != INVALID_HANDLE_VALUE)
	{
		dwFileSize = csText.GetLength() * sizeof(TCHAR);
		WriteFile(hFile, csText, dwFileSize, &dwWriteSize, NULL);
		CloseHandle(hFile);
		return TRUE;
	}

	return FALSE;
}

//////////////////////////////////////////////////////////////////////////

