#pragma once
#include "afxcmn.h"
#include "afxwin.h"

//////////////////////////////////////////////////////////////////////////

class CAPIReportDlg : public CDialog, CStringConvert
{
	DECLARE_DYNAMIC(CAPIReportDlg)

public:
	CAPIReportDlg(CWnd* pParent = NULL);
	virtual ~CAPIReportDlg();
	enum { IDD = IDD_API_REPORT_DIALOG };

	void SetReportList(const CalcReportList &list) { m_list.Copy(list); }
	void SetLog(BOOL fSave) { m_fSaveLog = fSave; }

protected:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();

	afx_msg void OnBnClickedListPluginReportLog();
	afx_msg void OnBnClickedBtnPluginReportClose() { OnOK(); }

public:
	CListCtrl	   m_xReportList;
	CButton		   m_xBtnLog;

protected:
	CalcReportList m_list;
	HICON		   m_hIcon;
	BOOL		   m_fSaveLog;
};


//////////////////////////////////////////////////////////////////////////