#include "stdafx.h"
#include "WinCS.h"
#include "APIReportDlg.h"

IMPLEMENT_DYNAMIC(CAPIReportDlg, CDialog)

BEGIN_MESSAGE_MAP(CAPIReportDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_PLUGIN_REPORT_LOG, &CAPIReportDlg::OnBnClickedListPluginReportLog)
	ON_BN_CLICKED(IDC_BTN_PLUGIN_REPORT_CLOSE, &CAPIReportDlg::OnBnClickedBtnPluginReportClose)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CAPIReportDlg::CAPIReportDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAPIReportDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_INFO);
}

CAPIReportDlg::~CAPIReportDlg()
{
}

void CAPIReportDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_PLUGIN_REPORT_LOG, m_xReportList);
	DDX_Control(pDX, IDC_BTN_PLUGIN_REPORT_LOG, m_xBtnLog);
}

BOOL CAPIReportDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	LVCOLUMN lvc;
	CString  cs;
	LVITEM   lvi;
	CRect	 cr;
	UINT	 nSize;

	lvc.mask	= (LVCF_FMT | LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM);
	m_xReportList.GetClientRect(&cr);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 4 / 30;
	lvc.pszText	= _T("ID");
	m_xReportList.InsertColumn(0, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 4 / 30;
	lvc.pszText	= _T("Sub");
	m_xReportList.InsertColumn(1, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 10 / 30;
	lvc.pszText	= _T("IP Address");
	m_xReportList.InsertColumn(2, &lvc);

	lvc.fmt		= LVCFMT_RIGHT;
	lvc.cx		= (cr.right - cr.left) * 10 / 30;
	lvc.pszText	= _T("Runtime");
	m_xReportList.InsertColumn(3, &lvc);

	m_xReportList.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_xBtnLog.EnableWindow(m_fSaveLog);

	nSize = m_list.GetSize();

	for (UINT i = 0; i < nSize; i++)
	{
		lvi.mask = (LVIF_TEXT | LVIF_IMAGE);

		cs = DwToString(m_list[i].wNodeID);
		lvi.iItem	 = i;
		lvi.iSubItem = 0;
		lvi.pszText  = MC_CStoSTR(cs);
		m_xReportList.InsertItem(&lvi);

		cs = DwToString(m_list[i].wSubID);
		lvi.iItem	 = i;
		lvi.iSubItem = 1;
		lvi.pszText  = MC_CStoSTR(cs);
		m_xReportList.SetItem(&lvi);

		cs = DwToIPAddress(m_list[i].dwAddress);
		lvi.iItem	 = i;
		lvi.iSubItem = 2;
		lvi.pszText  = MC_CStoSTR(cs);
		m_xReportList.SetItem(&lvi);

		cs.Format(_T("%.4lf sec"), m_list[i].dbRuntime);
		lvi.iItem	 = i;
		lvi.iSubItem = 3;
		lvi.pszText  = MC_CStoSTR(cs);
		m_xReportList.SetItem(&lvi);
	}

	CenterWindow(GetDesktopWindow());
	MessageBeep(MB_ICONASTERISK);

	return FALSE;
}

void CAPIReportDlg::OnBnClickedListPluginReportLog()
{
	GetParent()->PostMessage(WM_SHOW_LOG);
}

//////////////////////////////////////////////////////////////////////////