#pragma once

// white
#define RESET_WINDOW_COLOR	RGB(255, 255, 255)

//////////////////////////////////////////////////////////////////////////

class CAPIGraphicsWindow : public CWnd, CStringConvert
{
	DECLARE_DYNAMIC(CAPIGraphicsWindow)

public:
	CAPIGraphicsWindow();
	virtual ~CAPIGraphicsWindow();
	BOOL Create(const CString &csName, int cx, int cy, BOOL bFront);
	BOOL SetPixel(int x, int y, COLORREF color);
	BOOL SetXLine(int y, int cx, LPCOLORREF lpColor);
	BOOL SetYLine(int x, int cy, LPCOLORREF lpColor);
	void SetWindowSize(int cx, int cy, int x, int y);
	void SetCenterWindow();
	void ResetWindow();

	BOOL StartTimer();
	BOOL ForceClose();
	void StopTimer();
	void RuntimeTimer();
	void InitRenderingCount(UINT nTotal);
	void AddRenderingCount();
	void FinishDrawing();
	void GetTimer(CString &cs);
	void SetReportList(const CalcReportList &list) { m_ReportList.Copy(list); }
	void SetMode(BOOL fSystem) { m_fSystem = fSystem; }
	void SetNodeCount(DWORD dwNodes) { m_dwNodes = dwNodes; }
	void SetProcessros(DWORD dwProcessors) { m_dwProcessors = dwProcessors; }

	void SetCalcSize(CALCSIZE size) { m_CalcSize = size; }
	void GetCalcSize(CALCSIZE &size) { size = m_CalcSize; }
	void SetLog(BOOL fSave) { m_fSaveLog = fSave; }
	BOOL IsAPIWindow() { return IsWindow(m_hWnd); }
	BOOL IsSystemMode() { return m_fSystem; }

protected:
	DECLARE_MESSAGE_MAP()

	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnDestroy();
	afx_msg LRESULT OnShowLog(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnOutputReport(WPARAM wParam, LPARAM lParam);

	BOOL SaveReport();
	void OutputReportList();
	static void WINAPI doRuntimeTimer(LPVOID pvContext, BOOLEAN fTimeout);

protected:
	CCriticalSection m_DrawLock;
	CCriticalSection m_RgCountLock;
	CalcReportList	 m_ReportList;
	LOCKTIMER		 m_Timer;
	CALCSIZE		 m_CalcSize;
	CStopwatch		 m_Stopwatch;
	CString			 m_csWndName;
	CString			 m_LogPath;
	HICON			 m_hIcon;
	DWORD			 m_dwNodes;
	DWORD			 m_dwProcessors;
	BOOL			 m_fDrawing;
	BOOL			 m_fView;
	BOOL			 m_fSystem;
	BOOL			 m_fSaveLog;
	UINT			 m_nRecvCount;
	UINT			 m_nTotalCount;
	int 			 m_nWidth;
	int 			 m_nHeight;
	int				 m_nHPos;
	int				 m_nVPos;
};

//////////////////////////////////////////////////////////////////////////


