#include "stdafx.h"
#include "WinCS.h"
#include "APIConsoleDlg.h"

IMPLEMENT_DYNAMIC(CAPIConsoleDlg, CDialog)

BEGIN_MESSAGE_MAP(CAPIConsoleDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CAPIConsoleDlg::OnBnClickedOk)
	ON_WM_SIZE()
	ON_WM_CTLCOLOR()
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////

CAPIConsoleDlg::CAPIConsoleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAPIConsoleDlg::IDD, pParent)
{
	m_hIcon	= AfxGetApp()->LoadIcon(IDI_PLUGIN);
}

CAPIConsoleDlg::~CAPIConsoleDlg()
{
}

void CAPIConsoleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_API_CONSOLE_TEXT, m_xEditText);
}

BOOL CAPIConsoleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	m_xEditText.SetWindowText(STRING_EMPTY);

	return TRUE;
}

void CAPIConsoleDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDIT_API_CONSOLE_TEXT);

	if (pEdit != NULL)
	{
		pEdit->MoveWindow(0, 0, cx, cy);
	}
}

HBRUSH CAPIConsoleDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	int nCtlID = pWnd->GetDlgCtrlID();

	switch (nCtlID)
	{
	case IDC_EDIT_API_CONSOLE_TEXT:
		hbr = static_cast<HBRUSH>(GetStockObject(WHITE_BRUSH));
		pDC->SetBkColor(RGB(255, 255, 255));
		break;
	}

	return hbr;
}

//////////////////////////////////////////////////////////////////////////
