#pragma once

#include "stdafx.h"
#include "SocketX.h"

//////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CClientSocket, IBaseSocket)

CClientSocket::CClientSocket()
{
	ZeroMemory(&m_PeerAddr, sizeof(m_PeerAddr));
}

CClientSocket::~CClientSocket()
{
}

void CClientSocket::OnConnect(SOCKET hSocket, int nErrorCode)
{
	SOCKADDR SockAddr;
	NETADDR  NetAddr;

	if (nErrorCode != 0)
	{
		TRACE1("***** ERROR: OnConnect(%d) *****\n", nErrorCode);
		return;
	}

	if (!doGetPeerName(hSocket, &SockAddr) || !AsyncSelect(FD_CLIENT))
	{
		return;
	}

	CopyMemory(&m_PeerAddr, &SockAddr, sizeof(m_PeerAddr));

	ConvertSockAddrToNetAddr(&SockAddr, NetAddr);
	m_SockMsg.pTgtObj->OnSocketConnectMessage(m_SockMsg.dwSocketID, NetAddr);
}

void CClientSocket::OnReceive(SOCKET hSocket, int nErrorCode)
{
	CByteArray data;
	SOCKADDR   SockAddr;
	NETADDR	   NetAddr;

	if (nErrorCode != 0)
	{
		TRACE1("***** ERROR: OnReceive(%d) *****\n", nErrorCode);
		return;
	}

	if (!doGetPeerName(hSocket, &SockAddr) || !doReceive(hSocket, data))
	{
		return;
	}

	ConvertSockAddrToNetAddr(&SockAddr, NetAddr);
	m_SockMsg.pTgtObj->OnSocketReceiveMessage(m_SockMsg.dwSocketID, NetAddr, data);
}

void CClientSocket::OnSend(SOCKET hSocket, int nErrorCode)
{
	if (nErrorCode != 0)
	{
		TRACE1("***** ERROR: OnSend(%d) *****\n", nErrorCode);
		return;
	}

	m_SockMsg.pTgtObj->OnSocketSendMessage(m_SockMsg.dwSocketID);
}

void CClientSocket::OnClose(SOCKET hSocket, int nErrorCode)
{
	NETADDR NetAddr;

	// WinSock Error(10053) Keep-Alive timeout
	if (nErrorCode != 10053 && nErrorCode != 0)
	{
		TRACE1("***** ERROR: OnClose(%d) *****\n", nErrorCode);
		return;
	}

	ConvertSockAddrToNetAddr(&m_PeerAddr, NetAddr);
	m_SockMsg.pTgtObj->OnSocketCloseMessage(m_SockMsg.dwSocketID, NetAddr);
}

BOOL CClientSocket::CreateSocket(SOCKMSG SockMsg)
{
	if (!IBaseSocket::CreateSocketWindow())
	{
		return FALSE;
	}

	SetTargetWnd(SockMsg);

	m_hSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

	if (m_hSocket == INVALID_SOCKET)
	{
		TRACE1("***** ERROR: socket(%d) *****\n", GetLastError());
		m_dwError = GetLastError();
		return FALSE;
	}

	SetSendTimeout(m_dwSendTimeout);
	SetRecieveTimeout(m_dwReceiveTimeout);

	return TRUE;
}

BOOL CClientSocket::Initialize(SOCKMSG SockMsg)
{
	BOOL fSend, fReceive, flag = TRUE;

	if (!CreateSocket(SockMsg))
	{
		return FALSE;
	}

	// TCP Option(no delay)
	if (!SetSockOpt(TCP_NODELAY, (LPSTR)&flag, sizeof(flag)))
	{
		CloseSocket();
		return FALSE;
	}

	// buffer size
	fSend = fReceive = FALSE;

	for (UINT nBufSize = SX_TCP_MAXBUFSIZE; nBufSize > 0; nBufSize /= 2)
	{
		if (!fSend && SetSendBufferSize(nBufSize))
		{
			fSend = TRUE;
		}

		if (!fReceive && SetReceiveBufferSize(nBufSize))
		{
			fReceive = TRUE;
		}

		if (fSend && fReceive && TRUE)
		{
			break;
		}
	}

	return TRUE;
}

BOOL CClientSocket::SyncConnect(const LPSOCKADDR lpDstAddr, int nLength, DWORD dwTimeout)
{
	WSANETWORKEVENTS wnEvent;
	WSAEVENT hEvent;
	DWORD dwRet, dwOption, dwError;
	BOOL fRet = FALSE;
	int nRet;

	hEvent = WSACreateEvent();

	if (hEvent == WSA_INVALID_EVENT)
	{
		TRACE1("***** ERROR: WSACreateEvent(%d) *****\n", GetLastError());
		m_dwError = GetLastError();
		return FALSE;
	}

	nRet = WSAEventSelect(m_hSocket, hEvent, FD_CONNECT);

	if (nRet == SOCKET_ERROR)
	{
		TRACE1("***** ERROR: WSAEventSelect(%d) *****\n", GetLastError());
		m_dwError = GetLastError();
		WSACloseEvent(hEvent);
		return FALSE;
	}

	nRet = connect(m_hSocket, lpDstAddr, nLength);

	if (nRet == SOCKET_ERROR)
	{
		dwError = GetLastError();

		if (dwError != WSAEWOULDBLOCK)
		{
			TRACE1("***** ERROR: connect(%d) *****\n", GetLastError());
			m_dwError = dwError;
			goto END;
		}
	}

	// Wait...
	dwRet = WSAWaitForMultipleEvents(1, &hEvent, FALSE, dwTimeout, FALSE);

	switch (dwRet)
	{
	case WSA_WAIT_TIMEOUT:
	case WSA_WAIT_FAILED:
		TRACE1("***** ERROR: WSAWaitForMultipleEvents(%d) *****\n", GetLastError());
		m_dwError = GetLastError();
		goto END;

	default:
		nRet = WSAEnumNetworkEvents(m_hSocket, hEvent, &wnEvent);

		if (nRet == SOCKET_ERROR)
		{
			TRACE1("***** ERROR: WSAEnumNetworkEvents(%d) *****\n", GetLastError());
			m_dwError = GetLastError();
			goto END;
		}

		if ((wnEvent.lNetworkEvents & FD_CONNECT) &&
			(wnEvent.iErrorCode[FD_CONNECT_BIT] == 0))
		{
			fRet = TRUE;
		}
	}

END:
	WSAEventSelect(m_hSocket, hEvent, 0);
	WSACloseEvent(hEvent);

	// Blocking socket
	dwOption = 0;
	IOCtlSocket(FIONBIO, &dwOption);

	return fRet;
}

BOOL CClientSocket::SyncConnect(const LPCSTR lpDstAddr, WORD wPort, int nLength, DWORD dwTimeout)
{
	SOCKADDR_IN siAddr;
	MakeSockAddrIN(&siAddr, inet_addr(lpDstAddr), wPort);
	return SyncConnect((LPSOCKADDR)&siAddr, sizeof(siAddr), dwTimeout);
}

BOOL CClientSocket::AsyncConnect(const LPSOCKADDR lpDstAddr, int nLength)
{
	if (!AsyncSelect(FD_CONNECT))
	{
		return FALSE;
	}

	if (connect(m_hSocket, lpDstAddr, nLength) == SOCKET_ERROR)
	{
		m_dwError = GetLastError();

		if (m_dwError != WSAEWOULDBLOCK)
		{
			TRACE1("***** ERROR: connect(%d) *****\n", GetLastError());
			return FALSE;
		}
	}

	return TRUE;
}

BOOL CClientSocket::AsyncConnect(const LPCSTR lpDstAddr, WORD wPort, int nLength)
{
	SOCKADDR_IN siAddr;
	MakeSockAddrIN(&siAddr, inet_addr(lpDstAddr), wPort);
	return AsyncConnect((LPSOCKADDR)&siAddr, sizeof(siAddr));
}

//////////////////////////////////////////////////////////////////////////