#include "StdAfx.h"
#include "Flactale.h"

//////////////////////////////////////////////////////////////////////////

CMandelbrot::CMandelbrot()
{
}

CMandelbrot::~CMandelbrot()
{
}

void CMandelbrot::Calculation(int nYPoint, LPCOLORREF lpColor)
{
	double cy, cx, zx, zy, work;
	double dbImgMin, dbSide, dbRealMin;
	int    nWidth, nHeight, nCountMax;
	int    i, j;

	nWidth    = m_Flactale.nWidth;
	nHeight   = m_Flactale.nHeigth;
	nCountMax = m_Flactale.nCountMax;
	dbImgMin  = m_Flactale.dbImgMin;
	dbSide	  = m_Flactale.dbSide;
	dbRealMin = m_Flactale.dbRealMin;

	cy = dbImgMin + dbSide * nYPoint / nHeight;

	for (i = 0; i < nWidth; i++)
	{
		cx = dbRealMin + dbSide * i / nWidth;
		zx = cx;
		zy = cy;

		for (j = 0; j < nCountMax; j++)
		{
			if (4.0 < (zx * zx + zy * zy))
			{
				break;
			}

			work = zx * zx - zy * zy + cx;
			zy   = 2.0 * zx * zy + cy;
			zx   = work;
		}

		lpColor[i] = m_nPal[j];
	}
}

//////////////////////////////////////////////////////////////////////////