#include "StdAfx.h"
#include "Flactale.h"

//////////////////////////////////////////////////////////////////////////

CFlactale::CFlactale()
{
}

CFlactale::~CFlactale()
{
}

void CFlactale::Initialize(FLACTALE Params)
{
	SetParameters(Params);
	DefPalette();
	PrintLevel();
}

void CFlactale::DefPalette()
{
	m_nLvlMax = 4095;
	m_nPalMax = 4096;
	m_nLvlPal.SetSize(m_nLvlMax + 2);
	m_Color.SetSize(m_nPalMax + 2);

	m_Color[0]    = RGB(0, 0, 0);
	m_Color[4096] = RGB(160, 160, 160);

	int i = 1;
	for (int r = 1; r <= 16; r++)
	{
		for (int g = 1; g <= 16; g++)
		{
			for (int b = 1; b <= 16; b++)
			{
				m_Color[i++] = RGB(r * 16 - 1, g * 16 - 1, b * 16 - 1);
			}
		}
	}

	for (int i = 0; i <= m_nLvlMax + 1; i++)
	{
		m_nLvlPal[i] = static_cast<int>(m_Color[i]);
	}
}

void CFlactale::PrintLevel()
{
	int st, ed, pal0, pal1;
	int nCountMax = m_Flactale.nCountMax;

	m_nPal.SetSize(nCountMax + 1);

	for (int i = 1; i <= m_nLvlMax; i++)
	{
		st = static_cast<int>(nCountMax * (i - 1) / m_nLvlMax);
		ed = static_cast<int>(nCountMax * i / m_nLvlMax) - 1;

		if (st > ed)
		{
			continue;
		}

		pal0 = m_nLvlPal[i];
		pal1 = m_nLvlPal[m_nLvlMax + 1];

		for (int j = st; j <= ed; j++)
		{
			m_nPal[j] = (j % 2 == 0) ? pal0 : pal1;
		}

		m_nPal[nCountMax] = m_nLvlPal[0];
	}
}

//////////////////////////////////////////////////////////////////////////
