#include "StdAfx.h"
#include "DefaultPlugin.h"

//////////////////////////////////////////////////////////////////////////

CDefaultPlugin::CDefaultPlugin()
{
	doConstructor();
}

CDefaultPlugin::~CDefaultPlugin()
{
}

//////////////////////////////////////////////////////////////////////////

BOOL CDefaultPlugin::LoadInitialize()
{
	// ToDo: 

	return doLoadInitialize(), TRUE;
}

void CDefaultPlugin::ReceiveCallBack(const CByteArray &data)
{
	CSingleLock sl(&m_NetLock, TRUE);

	// ToDo:
	CalcReportList list;
	CALCREPORT cr;
	FTCALCDATA ftCalc;
	CString cs, csText;
	UINT nHdrSize = sizeof(FTCALCDATA) - sizeof(ColorList) - 4;	// 32 byte(Including alignment)
	UINT nWidth = m_CalcSize.nWidth;
	int  nSize  = m_NodeInitList.GetSize();
	int  nIndex = -1;
	int  nYPoint;

	CopyMemory(&ftCalc, data.GetData(), nHdrSize);
	ftCalc.list.SetSize(ftCalc.nSize);
	CopyMemory(ftCalc.list.GetData(), data.GetData() + nHdrSize, ftCalc.nSize * sizeof(COLORREF));

	for (int i = 0; i < nSize; i++)
	{
		if ((m_NodeInitList[i].nIndex  == ftCalc.nIndex) &&
			(m_NodeInitList[i].wNodeID == ftCalc.wNodeID) &&
			(m_NodeInitList[i].wSubID  == ftCalc.wSubID))
		{
			nIndex = i;
			break;
		}
	}

	if (nIndex != -1)
	{
		nYPoint = m_NodeInitList[nIndex].nYInit + ftCalc.nStepNo * m_NodeInitList[nIndex].nStep;

		for (int i = 0; i < m_NodeInitList[nIndex].nRange; i++)
		{
			API_SetXLine(nYPoint + i, nWidth, ftCalc.list.GetData() + i * nWidth);
		}

		if (ftCalc.fEnd)
		{
			m_NodeInitList[nIndex].dbRuntime = ftCalc.dbRuntime;

			++m_CalcCount.dwFinCount;

			if (m_CalcCount.dwAllCount == m_CalcCount.dwFinCount)
			{
				for (int i = 0; i < m_NodeInitList.GetSize(); i++)
				{
					ZeroMemory(&cr, sizeof(cr));
					cr.dwAddress = m_NodeInitList[i].dwAddress;
					cr.wNodeID	 = m_NodeInitList[i].wNodeID;
					cr.wSubID	 = m_NodeInitList[i].wSubID;
					cr.dbRuntime = m_NodeInitList[i].dbRuntime;
					list.Add(cr);
				}

				API_StopTimer();
				API_StopPlugin(list);
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////

BOOL CDefaultPlugin::MasterInitialize(const NodeDataList &list, BOOL fSystem)
{
	MASTER_PLUGIN init;

	// ToDo:
	init.bSystem   = fSystem;
	init.bFront	   = FALSE;
	init.csWndName = _T("Mandelbrot");
	init.list.Copy(list);

	return doMasterInitialize(init);
}

BOOL CDefaultPlugin::MasterFinalize()
{
	// ToDo:

	return doMasterFinalize(), TRUE;
}

DWORD CDefaultPlugin::MasterTransaction(LPVOID lpParams)
{
	// ToDo:
	LPPLUGIN_PARAMS p = (LPPLUGIN_PARAMS)lpParams;
	FLACTALE mb;
	CString cs;
	int  nArgument;
	UINT nWidth  = m_CalcSize.nWidth;
	UINT nHeight = m_CalcSize.nHeight;
	UINT nRange  = m_CalcSize.nRange;

	ByteArrayToString(p->arg, cs);

	try
	{
		nArgument = StrToInt(static_cast<LPCTSTR>(cs));
	}
	catch (CException* e)
	{
		nArgument = 4;	// To default
		e->Delete();
	}

	// Parameters setting
	switch (nArgument)
	{
	case 0:
		mb.dbRealMin = -1.825;
		mb.dbImgMin  = -0.05;
		mb.dbSide	 = 0.1;
		mb.nCountMax = 1000;
		break;

	case 1:
		mb.dbRealMin = -0.7717;
		mb.dbImgMin  = 0.11653;
		mb.dbSide	 = 0.00002;
		mb.nCountMax = 1800;
		break;

	case 2:
		mb.dbRealMin = -0.712;
		mb.dbImgMin  = -0.274;
		mb.dbSide	 = 0.0015;
		mb.nCountMax = 500;
		break;

	case 3:
		mb.dbRealMin = -0.7465;
		mb.dbImgMin  = 0.1045;
		mb.dbSide	 = 0.0015;
		mb.nCountMax = 900;
		break;

	case 4:
		mb.dbRealMin = -1.2458;
		mb.dbImgMin  = -0.1894;
		mb.dbSide	 = 0.023;
		mb.nCountMax = 1000;
		break;

	case 5:
		mb.dbRealMin = -0.7525;
		mb.dbImgMin  = 0.1875;
		mb.dbSide	 = 0.0415;
		mb.nCountMax = 600;
		break;

	case 6:
		mb.dbRealMin = -0.7824;
		mb.dbImgMin  = 0.1267;
		mb.dbSide	 = 0.0102;
		mb.nCountMax = 500;
		break;

	case 7:
		mb.dbRealMin = -0.3824;
		mb.dbImgMin  = -1.2824;
		mb.dbSide	 = 0.7824;
		mb.nCountMax = 500;
		break;

	default:
		mb.dbRealMin = -2.0;
		mb.dbImgMin  = -1.25;
		mb.dbSide	 = 2.5;
		mb.nCountMax = 50;
		break;
	}

	mb.nWidth  = nWidth;
	mb.nHeigth = nHeight;

	if (p->fSystem)
	{
		// System mode
		CByteArray data, tmp;
		FLACTALEDATA ftInit;
		NODEINIT   ndInit;
		int  nStep, nIndex;
		UINT nProcessors = 0;
		UINT nSlaves = m_MasterPlugin.list.GetSize() - 1;

		for (UINT i = 0; i < nSlaves; i++)
		{
			nProcessors += m_MasterPlugin.list[i + 1].dwProcessors;
		}

		m_NodeInitList.RemoveAll();
		tmp.SetSize(sizeof(ftInit));
		nIndex = 0;
		nStep  = nRange * nProcessors;	// Calculation step

		m_CalcCount.dwAllCount = nProcessors;
		m_CalcCount.dwFinCount = 0;

		for (UINT i = 0; i < nSlaves; i++)
		{
			ZeroMemory(&ndInit, sizeof(ndInit));
			ZeroMemory(&ftInit, sizeof(ftInit));
			ftInit.ft	       = mb;
			ftInit.nSlaves     = nSlaves;
			ftInit.nProcessors = nProcessors;

			ndInit.nRange	   = nRange;
			ndInit.nStep	   = nStep;
			ndInit.wNodeID	   = m_MasterPlugin.list[i + 1].wNodeID;
			ndInit.dwAddress   = m_MasterPlugin.list[i + 1].dwAddress;
			ndInit.fEnd		   = FALSE;

			// Per processors
			for (UINT j = 0; j < m_MasterPlugin.list[i + 1].dwProcessors; j++)
			{
				ndInit.nIndex  = nIndex;
				ndInit.nYInit  = nIndex * nRange;
				ndInit.wSubID  = static_cast<WORD>(j);
				ftInit.nd	   = ndInit;
				m_NodeInitList.Add(ndInit);
				CopyMemory(tmp.GetData(), &ftInit, tmp.GetSize());
				data.Append(tmp);
				nIndex++;
			}	
		}

		// Start
		data.FreeExtra();
		API_StartPlugin(m_PlgInfo.wPluginID, data);
	}
	else
	{
		// Single mode
		CMandelbrot man;
		CStopwatch  sw;
		ColorList	color;
		INT64		nDrawTime = 0;
		double		dbRuntime;
		UINT		nSpan = static_cast<int>(nHeight / p->dwThdCount);

		m_Stopwatch.Start();
		man.Initialize(mb);
		color.SetSize(m_CalcSize.nWidth);

		for (UINT i = nSpan * p->dwIndex; i < nSpan * (p->dwIndex + 1); i++)
		{
			man.Calculation(i, color.GetData());
			sw.Start();

			if (!API_SetXLine(i, m_CalcSize.nWidth, color.GetData()))
			{
				break;
			}

			nDrawTime += sw.NowByMicrosecond();
		}

		dbRuntime = static_cast<double>(m_Stopwatch.NowByMicrosecond() - nDrawTime) / 1000000;
		SetCalcReport(p->dwIndex, dbRuntime);
	}

	return CPlugin::MasterTransaction();
}

//////////////////////////////////////////////////////////////////////////

BOOL CDefaultPlugin::SlaveInitialize(const SLAVE_PLUGIN &init)
{
	// ToDo:

	return doSlaveInitialize(init);
}

BOOL CDefaultPlugin::SlaveFinalize()
{
	// ToDo:

	return doSlaveFinalize(), TRUE;
}

DWORD CDefaultPlugin::SlaveTransaction(LPVOID lpParams)
{
	// ToDo: 
	LPPLUGIN_PARAMS p = (LPPLUGIN_PARAMS)lpParams;
	FLACTALEDATA ftInit;
	FTCALCDATA   ftCalc;
	CMandelbrot  man;
	CByteArray   data;
	CStopwatch   sw;
	ColorList	 color;
	CString		 cs;

	int   nWidth, nHeight, nStep, nRange, nYInit;
	int   nPoint, nProgress, nMaxCount;	// For progress
	UINT  nSlaves, nProcessors, nCpIndex;
	UINT  nHdrSize  = sizeof(FTCALCDATA) - sizeof(ColorList) - 4;	// 32 byte(Including alignment)
	BOOL  flag	    = FALSE;
	DWORD dwIndex   = p->dwIndex;
	INT64 nSendTime = 0; 

	CopyMemory(&nSlaves, p->arg.GetData(), sizeof(nSlaves));
	CopyMemory(&nProcessors, p->arg.GetData() + sizeof(nSlaves), sizeof(nProcessors));

	for (UINT i = 0; i < nProcessors; i++)
	{
		nCpIndex = sizeof(ftInit) * i;
		CopyMemory(&ftInit, (p->arg.GetData() + nCpIndex), sizeof(ftInit));

		if ((ftInit.nd.wNodeID == m_SlavePlugin.wNodeID) && 
			(ftInit.nd.wSubID == static_cast<WORD>(dwIndex)))
		{
			ftCalc.nIndex  = ftInit.nd.nIndex;
			ftCalc.wNodeID = ftInit.nd.wNodeID;
			ftCalc.wSubID  = ftInit.nd.wSubID;
			flag = TRUE;
			break;
		}
	}

	if (flag)
	{
		m_Stopwatch.Start();
		nWidth  = ftInit.ft.nWidth;
		nHeight = ftInit.ft.nHeigth;
		nStep   = ftInit.nd.nStep;
		nRange  = ftInit.nd.nRange;
		nYInit  = ftInit.nd.nYInit;

		man.Initialize(ftInit.ft);
		color.SetSize(nWidth);
		ftCalc.nStepNo = 0;
		ftCalc.fEnd	   = FALSE;

		nProgress = 0;
		nMaxCount = static_cast<int>(static_cast<double>(nHeight - nYInit) / nStep * nRange);

		ASSERT(nMaxCount != 0);

		for (int i = nYInit; i < nHeight; i += nStep)
		{
			ftCalc.list.RemoveAll();

			for (int j = 0; j < nRange; j++)
			{
				if (!m_fRunning)
				{
					goto END;
				}

				man.Calculation(i + j, color.GetData());
				ftCalc.list.Append(color);
				nProgress++;
				nPoint = static_cast<int>(nProgress * 100 / nMaxCount);
				API_SetProgress(dwIndex, nPoint);
			}

			sw.Start();
			ftCalc.nSize = ftCalc.list.GetSize();
			data.SetSize(nHdrSize + ftCalc.list.GetSize() * sizeof(COLORREF));

			if ((i + nStep) >= nHeight)
			{
				ftCalc.fEnd = TRUE;
				ftCalc.dbRuntime = static_cast<double>(m_Stopwatch.NowByMicrosecond() - nSendTime) / 1000000;
				m_SlavePlugin.dbRuntime = ftCalc.dbRuntime;
			}

			CopyMemory(data.GetData(), &ftCalc, nHdrSize);
			CopyMemory(data.GetData() + nHdrSize, ftCalc.list.GetData(), ftCalc.nSize * sizeof(COLORREF));
			API_SendToMaster(data);
			nSendTime += sw.NowByMicrosecond();

			ftCalc.nStepNo++;
		}
	}

END:
	return CPlugin::SlaveTransaction();
}

//////////////////////////////////////////////////////////////////////////

