import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
/*
 * Created on 2004/05/04
 */
/**
 * @author qwert
 */
public class Surface extends Canvas {
	private class PromotionInputListener extends AbstractInputListener {
		Coordinate c, C;
		/**
		 * @param _app
		 */
		public PromotionInputListener(MIDlet app, Coordinate _c, Coordinate _C) {
			super(app);
			c = _c;
			C = _C;
		}
		/*
		 * this method is only called by Winboardclone.inputListener.keyPressed
		 */
		public void keyPressed(int param) {
			switch (param) {
				case javax.microedition.lcdui.Canvas.KEY_NUM2 :
				//N
				case javax.microedition.lcdui.Canvas.KEY_NUM3 :
				//B
				case javax.microedition.lcdui.Canvas.KEY_NUM4 :
				//R
				case javax.microedition.lcdui.Canvas.KEY_NUM5 :
					try {
						//Q
						WinboardClone.game.move(c,C,param - javax.microedition.lcdui.Canvas.KEY_NUM0);
					} catch (IllegalMoveException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (GameEndException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					repaint();
					return;
				default :
					return;
			}
		}
	}
	public class InputListener extends AbstractInputListener {
		int[] buf;
		Command exit, init;
		int index;
		/**
		 * @param _app
		 */
		public InputListener(MIDlet _app) {
			super(_app);
			exit = new Command("Exit", Command.SCREEN, 0);
			init = new Command("Init", Command.SCREEN, 1);
			addCommand(exit);
			addCommand(init);
			buf = new int[4];
		}
		
		public void commandAction(Command c, Displayable s) {
			if (c == exit) {
				app.notifyDestroyed();
			} else if (c == init)
				WinboardClone.game.init();
			repaint();
		}
		/**
		 * this method is only called by Winboardclone.surface.keypressed
		 */
		public void keyPressed(int param) {
			switch (param) {
				case KEY_NUM1 :
				//49
				case KEY_NUM2 :
				//50
				case KEY_NUM3 :
				case KEY_NUM4 :
				case KEY_NUM5 :
				case KEY_NUM6 :
				case KEY_NUM7 :
				case KEY_NUM8 :
					/*
					 * 'a' = 97
					 */
					char[] achar = new char[1];
					if (index % 2 == 0) {
						achar[0] = (char) (param + 48);
					} else {
						achar[0] = (char) (param);
					}
					WinboardClone.appendmsg(new String(achar));
					buf[index] = param - KEY_NUM1;
					repaint();
					break;
				default :
					return;
			}
			if (index == 3) {
				index = -1;
				Coordinate c, C;
				c = new Coordinate(buf[0], buf[1]);
				C = new Coordinate(buf[2], buf[3]);
				try {
					WinboardClone.game.move(c, C);
				} catch (IllegalMoveException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (PromotionException e) {
					inputListener = WinboardClone.inputListener;
					WinboardClone.inputListener = new PromotionInputListener(WinboardClone.inputListener.app,c,C);
					WinboardClone.newmsg("Promote pawn to");
				} catch (GameEndException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				repaint();
			}
			index++;
		}
	}
	/**
	 * handles pieces-image and draw that @author qwert
	 */
	public class PiecesImage {
		Image image;
		/*
		 *  the height and the width of one piece-image
		 */
		int length;
		/**
		 * init image
		 */
		public PiecesImage(int l) {
			length = l;
			setImagefromRecord();
		}
		/**
		 * paint pieces
		 */
		public void paint(Graphics g, int x, int y) {
			int color = 0;//whitesquare = 0 blacksquare = 1
			/*
			 * tmp-Image to copy a piece from image
			 */
			Image square = Image.createImage(length, length);
			Graphics g2 = square.getGraphics();
			/*
			 * the main routine counts up 64.
			 * r means rank f means file
			 */
			for (int r = 7; r >= 0; r--) {
				for (int f = 0; f <= 7; f++) {
					int p = WinboardClone.game.board.P[f][r];
					if (p >= 0) { // space or whitepiece
						/*
						 * Copy a piece-image
						 */
						g2.drawImage(image, -p * length, -2 * color * length,
								Graphics.TOP | Graphics.LEFT);
					} else//blackpiece
					{
						/*
						 * Copy a piece-image
						 */
						g2.drawImage(image, p * length, -2 * color * length
								- length, Graphics.TOP | Graphics.LEFT);
					}
					/*
					 * draw the piece-image
					 */
					g.drawImage(square, f * length + x, (7 - r) * length + y,
							Graphics.TOP | Graphics.LEFT);
					/*
					 * reverse color
					 */
					color = (color + 1) % 2;
				}
				/*
				 * reverse color
				 */
				color = (color + 1) % 2;
			}
		}
		/**
		 * get the image from the record
		 */
		public void setImagefromRecord() {
			try {
				image = Image.createImage("/chessfont" + String.valueOf(length)
						+ "-regular.png");
			} catch (IOException ex) {
				ex.printStackTrace(); // will never happen
			}
		}
	}
	AbstractInputListener inputListener;
	int msgBarHeight;
	PiecesImage piecesImage;
	public Surface(MIDlet app) {
		WinboardClone.inputListener = new InputListener(app);
		setCommandListener(WinboardClone.inputListener);
		if (getWidth() >= 240) {
			piecesImage = new PiecesImage(29);
			msgBarHeight = 26;
		} else {
			piecesImage = new PiecesImage(15);
			msgBarHeight = 16;
		}
	}
	/**
	 * call Winboardclone.inputListener.keyPressed
	 */
	public void keyPressed(int param) {
		WinboardClone.inputListener.keyPressed(param);
	}
	public void paint(Graphics g) {
		g.fillRect(0, 0, WinboardClone.frame.x, WinboardClone.frame.y);
		/*
		 * draw boader and etc.//TODO
		 */
		g.setColor(0xFFFFFF);
		g.fillRect(0, 0, WinboardClone.frame.x, msgBarHeight);
		g.setColor(0x2F2F2F);
		g.drawString(WinboardClone.msg, 0, 0, Graphics.TOP | Graphics.LEFT);
		
		piecesImage.paint(g, 4, msgBarHeight + 4);
	}
}
