/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Surface
extends Canvas {
    AbstractInputListener inputListener;
    int msgBarHeight;
    PiecesImage piecesImage;

    public Surface(MIDlet mIDlet) {
        WinboardClone.inputListener = new InputListener(mIDlet);
        this.setCommandListener(WinboardClone.inputListener);
        if (this.getWidth() >= 240) {
            this.piecesImage = new PiecesImage(29);
            this.msgBarHeight = 26;
        } else {
            this.piecesImage = new PiecesImage(15);
            this.msgBarHeight = 16;
        }
    }

    public void keyPressed(int n) {
        WinboardClone.inputListener.keyPressed(n);
    }

    public void paint(Graphics graphics) {
        graphics.fillRect(0, 0, WinboardClone.frame.x, WinboardClone.frame.y);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, WinboardClone.frame.x, this.msgBarHeight);
        graphics.setColor(0x2F2F2F);
        graphics.drawString(WinboardClone.msg, 0, 0, 20);
        this.piecesImage.paint(graphics, 4, this.msgBarHeight + 4);
    }

    public class PiecesImage {
        Image image;
        int length;

        public PiecesImage(int n) {
            this.length = n;
            this.setImagefromRecord();
        }

        public void paint(Graphics graphics, int n, int n2) {
            int n3 = 0;
            Image image = Image.createImage((int)this.length, (int)this.length);
            Graphics graphics2 = image.getGraphics();
            int n4 = 7;
            while (n4 >= 0) {
                int n5 = 0;
                while (n5 <= 7) {
                    byte by = WinboardClone.game.board.P[n5][n4];
                    if (by >= 0) {
                        graphics2.drawImage(this.image, -by * this.length, -2 * n3 * this.length, 20);
                    } else {
                        graphics2.drawImage(this.image, by * this.length, -2 * n3 * this.length - this.length, 20);
                    }
                    graphics.drawImage(image, n5 * this.length + n, (7 - n4) * this.length + n2, 20);
                    n3 = (n3 + 1) % 2;
                    ++n5;
                }
                n3 = (n3 + 1) % 2;
                --n4;
            }
        }

        public void setImagefromRecord() {
            try {
                this.image = Image.createImage((String)("/chessfont" + String.valueOf(this.length) + "-regular.png"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public class InputListener
    extends AbstractInputListener {
        int[] buf;
        Command exit = new Command("Exit", 1, 0);
        Command init = new Command("Init", 1, 1);
        int index;

        public InputListener(MIDlet mIDlet) {
            super(mIDlet);
            Surface.this.addCommand(this.exit);
            Surface.this.addCommand(this.init);
            this.buf = new int[4];
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.exit) {
                this.app.notifyDestroyed();
            } else if (command == this.init) {
                WinboardClone.game.init();
            }
            Surface.this.repaint();
        }

        public void keyPressed(int n) {
            switch (n) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: {
                    char[] cArray = new char[]{this.index % 2 == 0 ? (char)(n + 48) : (char)n};
                    WinboardClone.appendmsg(new String(cArray));
                    this.buf[this.index] = n - 49;
                    Surface.this.repaint();
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.index == 3) {
                this.index = -1;
                Coordinate coordinate = new Coordinate(this.buf[0], this.buf[1]);
                Coordinate coordinate2 = new Coordinate(this.buf[2], this.buf[3]);
                try {
                    WinboardClone.game.move(coordinate, coordinate2);
                }
                catch (IllegalMoveException illegalMoveException) {
                    illegalMoveException.printStackTrace();
                }
                catch (PromotionException promotionException) {
                    Surface.this.inputListener = WinboardClone.inputListener;
                    WinboardClone.inputListener = new PromotionInputListener(WinboardClone.inputListener.app, coordinate, coordinate2);
                    WinboardClone.newmsg("Promote pawn to");
                }
                catch (GameEndException gameEndException) {
                    gameEndException.printStackTrace();
                }
                Surface.this.repaint();
            }
            ++this.index;
        }
    }

    private class PromotionInputListener
    extends AbstractInputListener {
        Coordinate c;
        Coordinate C;

        public PromotionInputListener(MIDlet mIDlet, Coordinate coordinate, Coordinate coordinate2) {
            super(mIDlet);
            this.c = coordinate;
            this.C = coordinate2;
        }

        public void keyPressed(int n) {
            switch (n) {
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    try {
                        WinboardClone.game.move(this.c, this.C, n - 48);
                    }
                    catch (IllegalMoveException illegalMoveException) {
                        illegalMoveException.printStackTrace();
                    }
                    catch (GameEndException gameEndException) {
                        gameEndException.printStackTrace();
                    }
                    Surface.this.repaint();
                    return;
                }
            }
        }
    }
}

