/*
 * Decompiled with CFR 0.152.
 */
public class Game
extends AbstractGame
implements ChessLibrary {
    public static char pieceOf(int n) {
        switch (n) {
            case 1: {
                return 'p';
            }
            case -1: {
                return 'P';
            }
            case 2: {
                return 'n';
            }
            case -2: {
                return 'N';
            }
            case 3: {
                return 'b';
            }
            case -3: {
                return 'B';
            }
            case 4: {
                return 'r';
            }
            case -4: {
                return 'R';
            }
            case 5: {
                return 'q';
            }
            case -5: {
                return 'Q';
            }
            case 6: {
                return 'k';
            }
            case -6: {
                return 'K';
            }
        }
        return ' ';
    }

    public Game(int n) {
        super(n);
        this.board = new Board();
        this.init();
        this.enumVariations();
    }

    public void clear() throws LineCannotAccessedException {
        if (this.line.pline == this) {
            if (this.cline == null) {
                throw new LineCannotAccessedException();
            }
            this.cline = null;
            return;
        }
        if (this.line.pline.cline == this.line) {
            this.line = this.line.pline;
            this.clear();
            return;
        }
        try {
            this.line.joints[0].pline = this.line.pline;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.line.pline.joints[this.line.num1] = this.line.joints[0];
    }

    private void enumVariations() {
        Line line = this.line;
        this.variations.x = 0;
        this.variations.y = 1;
        this.subenumVariations(line);
        line = this.line;
        this.sub2enumVariations(line);
        this.variations.y += this.variations.x;
    }

    private int[] getAttackingPawnMove(Coordinate coordinate, int n) {
        int[] nArray = new int[]{this.getPosition(coordinate.add(1, 1 * n)), this.getPosition(coordinate.add(-1, 1 * n))};
        return nArray;
    }

    private int[][] getBishopMove(Coordinate coordinate) {
        int[][] nArray = new int[4][7];
        Coordinate coordinate2 = new Coordinate(1, 1);
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 7) {
                nArray[n][n2] = this.getPosition(coordinate.add((n2 + 1) * coordinate2.x, (n2 + 1) * coordinate2.y));
                ++n2;
            }
            coordinate2.y = coordinate2.x = -coordinate2.y;
            ++n;
        }
        return nArray;
    }

    private int getColor(int n) {
        if (n > 0) {
            return 1;
        }
        if (n == 0) {
            return 0;
        }
        if (n == -7) {
            return 0;
        }
        return -1;
    }

    private int[] getKingMove(Coordinate coordinate) {
        int[] nArray = new int[]{this.getPosition(coordinate.add(0, 1)), this.getPosition(coordinate.add(1, 1)), this.getPosition(coordinate.add(1, 0)), this.getPosition(coordinate.add(1, -1)), this.getPosition(coordinate.add(0, -1)), this.getPosition(coordinate.add(-1, -1)), this.getPosition(coordinate.add(-1, 0)), this.getPosition(coordinate.add(-1, 1))};
        return nArray;
    }

    private int[] getkNightMove(Coordinate coordinate) {
        int[] nArray = new int[]{this.getPosition(coordinate.add(1, 2)), this.getPosition(coordinate.add(2, 1)), this.getPosition(coordinate.add(2, -1)), this.getPosition(coordinate.add(1, -2)), this.getPosition(coordinate.add(-1, -2)), this.getPosition(coordinate.add(-2, -1)), this.getPosition(coordinate.add(-2, 1)), this.getPosition(coordinate.add(-1, 2))};
        return nArray;
    }

    public Move getMove() {
        if (this.line == this) {
            return this.rootMove;
        }
        return this.line.moves[this.num];
    }

    private int[] getMovingPawnMove(Coordinate coordinate, int n) {
        int[] nArray = new int[2];
        nArray[0] = this.getPosition(coordinate.add(0, 1 * n));
        if (n == 1 && coordinate.y == 1 || n == -1 && coordinate.y == 6) {
            nArray[1] = this.getPosition(coordinate.add(0, 2 * n));
        }
        return nArray;
    }

    public int getPosition(Coordinate coordinate) {
        try {
            return this.board.P[coordinate.x][coordinate.y];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -7;
        }
    }

    private int[][] getRookMove(Coordinate coordinate) {
        int[][] nArray = new int[4][7];
        Coordinate coordinate2 = new Coordinate(0, 1);
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 7) {
                nArray[n][n2] = this.getPosition(coordinate.add((n2 + 1) * coordinate2.x, (n2 + 1) * coordinate2.y));
                ++n2;
            }
            coordinate2.y = coordinate2.x = -coordinate2.y;
            ++n;
        }
        return nArray;
    }

    public void go(int n) throws LineCannotAccessedException {
        if (this.line == this && this.num + n < this.num1) {
            throw new LineCannotAccessedException();
        }
        if (n != 0) {
            if (n > 0) {
                try {
                    this.line.moves[this.num + n].notify();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (this.line.cline == null) {
                        this.line.cline = new Line(this.line.num1 + this.length, this.line, null, this.length);
                    }
                    this.num += this.length;
                    this.line = this.line.cline;
                    this.go(n - this.length);
                    return;
                }
                this.num += n;
            } else {
                try {
                    this.line.moves[this.num - n].notify();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.num -= this.length;
                    this.line = this.line.pline;
                    this.go(n + this.length);
                    return;
                }
                this.num -= n;
            }
        }
        this.enumVariations();
    }

    public void init() {
        this.board.P[0][7] = -4;
        this.board.P[1][7] = -2;
        this.board.P[2][7] = -3;
        this.board.P[3][7] = -5;
        this.board.P[4][7] = -6;
        this.board.P[5][7] = -3;
        this.board.P[6][7] = -2;
        this.board.P[7][7] = -4;
        int n = 0;
        while (n < 8) {
            this.board.P[n][6] = -1;
            ++n;
        }
        this.board.P[0][0] = 4;
        this.board.P[1][0] = 2;
        this.board.P[2][0] = 3;
        this.board.P[3][0] = 5;
        this.board.P[4][0] = 6;
        this.board.P[5][0] = 3;
        this.board.P[6][0] = 2;
        this.board.P[7][0] = 4;
        int n2 = 0;
        while (n2 <= 7) {
            this.board.P[n2][1] = 1;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 8) {
            int n4 = 2;
            while (n4 < 6) {
                this.board.P[n3][n4] = 0;
                ++n4;
            }
            ++n3;
        }
        this.color = 1;
    }

    private boolean isInfluencedBy(Coordinate coordinate, int n, Coordinate[] coordinateArray, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray;
        if (this.getPosition(coordinate) == -7) {
            return false;
        }
        if (n2 % 2 == 0) {
            nArray = this.getAttackingPawnMove(coordinate, -n);
            n5 = 0;
            while (n5 < nArray.length) {
                if (nArray[n5] == n * 1 && !this.isPinnedBy(coordinate, coordinateArray)) {
                    return true;
                }
                ++n5;
            }
        }
        if (n2 % 3 == 0) {
            nArray = this.getMovingPawnMove(coordinate, -n);
            n5 = 0;
            while (n5 < nArray.length) {
                if (nArray[n5] == n * 1 && !this.isPinnedBy(coordinate, coordinateArray)) {
                    return true;
                }
                ++n5;
            }
        }
        nArray = this.getkNightMove(coordinate);
        n5 = 0;
        while (n5 < nArray.length) {
            if (nArray[n5] == n * 2 && !this.isPinnedBy(coordinate, coordinateArray)) {
                return true;
            }
            ++n5;
        }
        int[][] nArray2 = this.getBishopMove(coordinate);
        int n6 = 0;
        while (n6 < 4) {
            n4 = 0;
            while (n4 < 7) {
                if (nArray2[n6][n4] != 0 && (nArray2[n4][n6] == n * 3 || nArray2[n4][n6] == n * 5)) {
                    if (this.isPinnedBy(coordinate, coordinateArray)) break;
                    return true;
                }
                ++n4;
            }
            ++n6;
        }
        nArray2 = this.getRookMove(coordinate);
        n4 = 0;
        while (n4 < 4) {
            n3 = 0;
            while (n3 < 7) {
                if (nArray2[n4][n3] != 0 && (nArray2[n3][n4] == n * 4 || nArray2[n3][n4] == n * 5)) {
                    if (this.isPinnedBy(coordinate, coordinateArray)) break;
                    return true;
                }
                ++n3;
            }
            ++n4;
        }
        if (n2 % 5 == 0) {
            nArray = this.getKingMove(coordinate);
            n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == this.color * 6 && !this.isPinnedBy(coordinate, coordinateArray)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    private boolean isPinnedBy(Coordinate coordinate, Coordinate[] coordinateArray) {
        int n = 0;
        while (n < coordinateArray.length) {
            if (coordinate.equals(coordinateArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void move(Coordinate coordinate, Coordinate coordinate2) throws IllegalMoveException, PromotionException, GameEndException {
        int n = this.getPosition(coordinate);
        if (n == 1 && coordinate2.y == 7 || n == -1 && coordinate2.x == 0) {
            throw new PromotionException();
        }
        this.tryMove(coordinate, coordinate2, 0);
    }

    public void move(Coordinate coordinate, Coordinate coordinate2, int n) throws IllegalMoveException, GameEndException {
        this.tryMove(coordinate, coordinate2, n);
    }

    public void paste(Line line) throws LineCannotAccessedException {
        if (this.line == this) {
            throw new LineCannotAccessedException();
        }
        this.line.joints[this.num - this.num1] = line;
    }

    private Coordinate searchKing(int n) {
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 0;
            while (n3 < 8) {
                if (this.board.P[n2][n3] == n * 6) {
                    return new Coordinate(n2, n3);
                }
                ++n3;
            }
            ++n2;
        }
        return null;
    }

    public void setMove(Move move) throws LineCannotAccessedException {
        if (this.line == this) {
            throw new LineCannotAccessedException();
        }
        this.line.moves[this.num] = move;
    }

    public void setPosition(Coordinate coordinate, int n) {
        try {
            this.board.P[coordinate.x][coordinate.y] = (byte)n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    private void sub2enumVariations(Line line) {
        if (line.joints[this.num - this.num1] == null) {
            return;
        }
        ++this.variations.y;
        line = line.joints[this.num - this.num1];
        this.sub2enumVariations(line);
    }

    private void subenumVariations(Line line) {
        if (line.pline == this || this.pline.num1 != this.line.num1) {
            return;
        }
        ++this.variations.x;
        line = line.pline;
        this.subenumVariations(line);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void tryMove(Coordinate var1_1, Coordinate var2_2, int var3_3) throws IllegalMoveException, GameEndException {
        block128: {
            block129: {
                var4_4 = new Move(0, null, 1, 0, null, this.board);
                var16_5 = this.getPosition(var1_1);
                if (var16_5 == 0) {
                    throw new IllegalMoveException();
                }
                var4_4.p = Math.abs(var16_5);
                if (this.getColor(var16_5) * this.color != 1) {
                    throw new IllegalMoveException();
                }
                if (var1_1.equals(var2_2)) {
                    throw new IllegalMoveException();
                }
                switch (Math.abs(var16_5)) {
                    case 1: {
                        switch (var2_2.x - var1_1.x) {
                            case 0: {
                                var6_6 = this.getMovingPawnMove(var1_1, this.color);
                                if (var6_6[0] == 0 || var1_1.y - var2_2.y != this.color && (var6_6[1] == 0 || Math.abs(var2_2.y - var1_1.y) != 2)) {
                                    throw new IllegalMoveException();
                                }
                                break block129;
                            }
                            case 1: {
                                var6_6 = this.getAttackingPawnMove(var1_1, this.color);
                                if (var1_1.y - var2_2.y != this.color || this.getColor(var6_6[0]) != -this.color && (this.getColor(var6_6[0]) != 0 || this.getMove().fen % 9 != var2_2.x)) {
                                    throw new IllegalMoveException();
                                }
                                break block129;
                            }
                            case -1: {
                                var6_6 = this.getAttackingPawnMove(var1_1, this.color);
                                if (var1_1.y - var2_2.y != this.color || this.getColor(var6_6[1]) != -this.color && (this.getColor(var6_6[1]) != 0 || this.getMove().fen % 9 != var2_2.x)) {
                                    throw new IllegalMoveException();
                                }
                                break block129;
                            }
                            case 2: {
                                if (Math.abs((var2_2.x - var1_1.x) * (var2_2.y - var1_1.y)) != 2 || this.getColor(this.getPosition(var2_2)) == this.color) {
                                    throw new IllegalMoveException();
                                }
                                break block129;
                            }
                            case 3: {
                                var5_7 /* !! */  = this.getBishopMove(var1_1);
                                if (Math.abs(var2_2.x - var1_1.x) != Math.abs(var2_2.y - var1_1.y)) ** GOTO lbl50
                                var7_8 = new Coordinate(this.getColor(var2_2.x - var1_1.x), this.getColor(var2_2.y - var1_1.y));
                                var8_9 = new Coordinate(1, 1);
                                var17_10 = 0;
                                while (!var7_8.equals(var8_9)) {
                                    var7_8.x = var7_8.y;
                                    var7_8.y = -var7_8.y;
                                    ++var17_10;
                                }
                                var18_11 = 0;
                                while (var18_11 < Math.abs(var2_2.x - var1_1.x) - 1) {
                                    if (var5_7 /* !! */ [var17_10][var18_11] != 0) {
                                        throw new IllegalMoveException();
                                    }
                                    ++var18_11;
                                }
                                if (this.getColor(var5_7 /* !! */ [var17_10][Math.abs(var2_2.x - var1_1.x)]) != this.color) break block129;
lbl50:
                                // 2 sources

                                throw new IllegalMoveException();
                            }
                            case 4: {
                                var5_7 /* !! */  = this.getRookMove(var1_1);
                                if (var1_1.x != var2_2.x) ** GOTO lbl62
                                var17_10 = 0;
                                while (var17_10 < Math.abs(var2_2.y - var1_1.y) - 1) {
                                    if (var5_7 /* !! */ [3 - this.getColor(var2_2.y - var1_1.y)][var17_10] != 0) {
                                        throw new IllegalMoveException();
                                    }
                                    ++var17_10;
                                }
                                if (this.getColor(var5_7 /* !! */ [3 - this.getColor(var2_2.y - var1_1.y)][Math.abs(var2_2.y - var1_1.y)]) != this.color) break block129;
lbl62:
                                // 2 sources

                                if (var1_1.y != var2_2.y) ** GOTO lbl70
                                var17_10 = 0;
                                while (var17_10 < Math.abs(var2_2.x - var1_1.x) - 1) {
                                    if (var5_7 /* !! */ [3 - this.getColor(var2_2.x - var1_1.x)][var17_10] != 0) {
                                        throw new IllegalMoveException();
                                    }
                                    ++var17_10;
                                }
                                if (this.getColor(var5_7 /* !! */ [3 - this.getColor(var2_2.x - var1_1.x)][Math.abs(var2_2.x - var1_1.x)]) != this.color) break block129;
lbl70:
                                // 2 sources

                                throw new IllegalMoveException();
                            }
                            case 5: {
                                var5_7 /* !! */  = this.getBishopMove(var1_1);
                                if (Math.abs(var2_2.x - var1_1.x) != Math.abs(var2_2.y - var1_1.y)) ** GOTO lbl90
                                var7_8 = new Coordinate(this.getColor(var2_2.x - var1_1.x), this.getColor(var2_2.y - var1_1.y));
                                var8_9 = new Coordinate(1, 1);
                                var17_10 = 0;
                                while (!var7_8.equals(var8_9)) {
                                    var7_8.x = var7_8.y;
                                    var7_8.y = -var7_8.y;
                                    ++var17_10;
                                }
                                var18_11 = 0;
                                while (var18_11 < Math.abs(var2_2.x - var1_1.x) - 1) {
                                    if (var5_7 /* !! */ [var17_10][var18_11] != 0) {
                                        throw new IllegalMoveException();
                                    }
                                    ++var18_11;
                                }
                                if (this.getColor(var5_7 /* !! */ [var17_10][Math.abs(var2_2.x - var1_1.x)]) != this.color) break block129;
lbl90:
                                // 2 sources

                                var5_7 /* !! */  = this.getRookMove(var1_1);
                                if (var1_1.x != var2_2.x) ** GOTO lbl99
                                var17_10 = 0;
                                while (var17_10 < Math.abs(var2_2.y - var1_1.y) - 1) {
                                    if (var5_7 /* !! */ [2 - this.getColor(var2_2.y - var1_1.y)][var17_10] != 0) {
                                        throw new IllegalMoveException();
                                    }
                                    ++var17_10;
                                }
                                if (this.getColor(var5_7 /* !! */ [3 - this.getColor(var2_2.y - var1_1.y)][Math.abs(var2_2.y - var1_1.y)]) != this.color) break block129;
lbl99:
                                // 2 sources

                                if (var1_1.y != var2_2.y) ** GOTO lbl107
                                var17_10 = 0;
                                while (var17_10 < Math.abs(var2_2.x - var1_1.x) - 1) {
                                    if (var5_7 /* !! */ [3 - this.getColor(var2_2.x - var1_1.x)][var17_10] != 0) {
                                        throw new IllegalMoveException();
                                    }
                                    ++var17_10;
                                }
                                if (this.getColor(var5_7 /* !! */ [3 - this.getColor(var2_2.x - var1_1.x)][Math.abs(var2_2.x - var1_1.x)]) != this.color) break block129;
lbl107:
                                // 2 sources

                                throw new IllegalMoveException();
                            }
                            case 6: {
                                var5_7 /* !! */  = new int[1][];
                                var6_6 = this.getKingMove(var2_2);
                                var13_12 = false;
                                var17_10 = 0;
                                while (var17_10 < 8) {
                                    if (var6_6[var17_10] != this.color * 6) {
                                        ++var17_10;
                                        continue;
                                    }
                                    break block129;
                                }
                                if (var2_2.y - var1_1.y != 0 || (var2_2.x - var1_1.x != 2 || 9 > this.getMove().fen || this.getMove().fen >= 18) && (var2_2.x - var1_1.x != -3 || 18 > this.getMove().fen)) {
                                    throw new IllegalMoveException();
                                } else {
                                    ** GOTO lbl121
                                }
                            }
                        }
                    }
                }
            }
            var11_13 = new Coordinate[8];
            var10_14 = this.searchKing(-this.color);
            var5_7 /* !! */  = this.getRookMove(var10_14);
            var13_12 = false;
            var7_8 = null;
            var18_11 = 0;
            while (var18_11 < 4) {
                var19_15 = 0;
                while (var19_15 < 7) {
                    if (var5_7 /* !! */ [var18_11][var19_15] != 0) {
                        if (this.getColor(var5_7 /* !! */ [var18_11][var19_15]) == -this.color) {
                            if (var13_12) break;
                            var13_12 = true;
                            var7_8 = new Coordinate(var19_15, var18_11);
                        } else {
                            if (var5_7 /* !! */ [var19_15][var18_11] != this.color * 4 && var5_7 /* !! */ [var19_15][var18_11] != this.color * 5) break;
                            var11_13[2 * var18_11] = var7_8;
                        }
                    }
                    ++var19_15;
                }
                var13_12 = false;
                ++var18_11;
            }
            var5_7 /* !! */  = this.getBishopMove(var10_14);
            var19_15 = 0;
            while (var19_15 < 4) {
                var20_16 = 0;
                while (var20_16 < 7) {
                    if (var5_7 /* !! */ [var19_15][var20_16] != 0) {
                        if (this.getColor(var5_7 /* !! */ [var19_15][var20_16]) == -this.color) {
                            if (var13_12) break;
                            var13_12 = true;
                            var7_8 = new Coordinate(var20_16, var19_15);
                        } else {
                            if (var5_7 /* !! */ [var20_16][var19_15] != this.color * 3 && var5_7 /* !! */ [var20_16][var19_15] != this.color * 5) break;
                            var11_13[2 * var19_15 + 1] = var7_8;
                        }
                    }
                    ++var20_16;
                }
                var13_12 = false;
                ++var19_15;
            }
            if (var3_3 == 0) {
                this.setPosition(var2_2, this.getPosition(var1_1));
            } else {
                this.setPosition(var2_2, var3_3);
            }
            this.setPosition(var1_1, 0);
            var12_18 = new Coordinate[8];
            var9_19 = this.searchKing(this.color);
            if (this.isInfluencedBy(var9_19, -this.color, var12_18, 10)) {
                this.board = this.getMove().P;
                throw new IllegalMoveException();
            }
            var14_20 = 0;
            var13_12 = true;
            block56: while (var13_12) {
                var13_12 = false;
                var6_6 = this.getAttackingPawnMove(var10_14, this.color);
                var20_16 = 0;
                while (var20_16 < var6_6.length) {
                    if (var6_6[var20_16] == this.color * 1) {
                        ++var14_20;
                        var7_8 = var10_14.add(-2 * var20_16 + 1, -this.color);
                        break block56;
                    }
                    ++var20_16;
                }
                var6_6 = this.getkNightMove(var10_14);
                var21_21 = 0;
                while (var21_21 < var6_6.length) {
                    if (var6_6[var21_21] == this.color * 2) {
                        ++var14_20;
                        switch (var21_21) {
                            case 0: {
                                var7_8 = var10_14.add(1, 2);
                                break;
                            }
                            case 1: {
                                var7_8 = var10_14.add(2, 1);
                                break;
                            }
                            case 2: {
                                var7_8 = var10_14.add(2, -1);
                                break;
                            }
                            case 3: {
                                var7_8 = var10_14.add(1, -2);
                                break;
                            }
                            case 4: {
                                var7_8 = var10_14.add(-1, -2);
                                break;
                            }
                            case 5: {
                                var7_8 = var10_14.add(-2, -1);
                            }
                            case 6: {
                                var7_8 = var10_14.add(-2, 1);
                                break;
                            }
                            case 7: {
                                var7_8 = var10_14.add(-1, 2);
                            }
                        }
                    }
                    ++var21_21;
                }
                var22_28 = 0;
                while (var22_28 < 4) {
                    var23_30 = 0;
                    while (var23_30 < 7) {
                        var5_7 /* !! */ [var22_28][var23_30] = this.getPosition(var1_1.add((var23_30 + 1) * var2_2.x, (var23_30 + 1) * var2_2.y));
                        ++var23_30;
                    }
                    ++var22_28;
                }
                var5_7 /* !! */  = this.getBishopMove(var10_14);
                var8_9 = new Coordinate(1, 1);
                var23_30 = 0;
                while (var23_30 < 4) {
                    var24_31 = 0;
                    while (var24_31 < 7) {
                        if (var5_7 /* !! */ [var23_30][var24_31] != 0) {
                            if (var5_7 /* !! */ [var24_31][var23_30] != this.color * 3 && var5_7 /* !! */ [var24_31][var23_30] != this.color * 5) break;
                            ++var14_20;
                            var7_8 = var10_14.add((var24_31 + 1) * var8_9.x, (var24_31 + 1) * var8_9.y);
                            break;
                        }
                        ++var24_31;
                    }
                    var8_9.y = var8_9.x = -var8_9.y;
                    ++var23_30;
                }
                var8_9 = new Coordinate(0, 1);
                var5_7 /* !! */  = this.getRookMove(var10_14);
                var24_31 = 0;
                while (var24_31 < 4) {
                    var25_32 = 0;
                    while (var25_32 < 7) {
                        if (var5_7 /* !! */ [var24_31][var25_32] != 0) {
                            if (var5_7 /* !! */ [var25_32][var24_31] != this.color * 4 && var5_7 /* !! */ [var25_32][var24_31] != this.color * 5) break;
                            ++var14_20;
                            var7_8 = var10_14.add((var25_32 + 1) * var8_9.x, (var25_32 + 1) * var8_9.y);
                            break;
                        }
                        ++var25_32;
                    }
                    var8_9.y = var8_9.x = -var8_9.y;
                    ++var24_31;
                }
            }
            if (this.isInfluencedBy(var10_14.add(0, 1), this.color, var12_18, 10) == false && this.getColor(this.getPosition(var10_14.add(0, 1))) != -this.color || this.isInfluencedBy(var10_14.add(1, 1), this.color, var12_18, 10) == false && this.getColor(this.getPosition(var10_14.add(1, 1))) != -this.color || this.isInfluencedBy(var10_14.add(1, 0), this.color, var12_18, 10) == false && this.getColor(this.getPosition(var10_14.add(1, 0))) != -this.color || this.isInfluencedBy(var10_14.add(1, -1), this.color, var12_18, 10) == false && this.getColor(this.getPosition(var10_14.add(1, -1))) != -this.color || this.isInfluencedBy(var10_14.add(0, -1), this.color, var12_18, 10) == false && this.getColor(this.getPosition(var10_14.add(0, -1))) != -this.color || this.isInfluencedBy(var10_14.add(-1, 1), this.color, var12_18, 10) == false && this.getColor(this.getPosition(var10_14.add(-1, -1))) != -this.color || this.isInfluencedBy(var10_14.add(-1, 0), this.color, var12_18, 10) == false && this.getColor(this.getPosition(var10_14.add(-1, 0))) != -this.color || !this.isInfluencedBy(var10_14.add(-1, 1), this.color, var12_18, 10) && this.getColor(this.getPosition(var10_14.add(-1, 1))) != -this.color) {
                if (var14_20 != 0) {
                    var4_4.p *= 9;
                    if (var14_20 == 2) {
                        var4_4.p *= 9;
                        try {
                            this.go(1);
                            this.setMove(var4_4);
                        }
                        catch (LineCannotAccessedException var20_17) {
                            // empty catch block
                        }
                        throw new GameEndException(this.color);
                    }
                    if (!this.isInfluencedBy(var7_8, -this.color, var11_13, 2)) {
                        var14_20 = Math.abs(this.getPosition(var7_8));
                        if (var14_20 == 5) {
                            var14_20 = var7_8.x == var10_14.x || var7_8.y == var10_14.y ? 4 : 3;
                        }
                        switch (Math.abs(this.getPosition(var7_8))) {
                            case 3: {
                                var20_16 = 1;
                                while (var20_16 < var7_8.x - var9_19.x) {
                                    if (!this.isInfluencedBy(var9_19.add(var20_16 * this.getColor(var7_8.x - var9_19.x), var20_16 * this.getColor(var7_8.y - var9_19.y)), -this.color, var11_13, 3)) {
                                        ++var20_16;
                                        continue;
                                    }
                                    break block128;
                                }
                                var4_4.p *= 9;
                                try {
                                    this.go(1);
                                    this.setMove(var4_4);
                                }
                                catch (LineCannotAccessedException var21_22) {
                                    // empty catch block
                                }
                                throw new GameEndException(this.color);
                            }
                            case 4: {
                                if (var7_8.x == var10_14.x) {
                                    var21_21 = 1;
                                    while (var21_21 < var7_8.y - var9_19.y) {
                                        if (!this.isInfluencedBy(var9_19.add(var7_8.x, var21_21 * this.getColor(var7_8.y - var9_19.y)), -this.color, var11_13, 3)) {
                                            ++var21_21;
                                            continue;
                                        }
                                        break block128;
                                    }
                                } else {
                                    var21_21 = 1;
                                    while (var21_21 < var7_8.x - var9_19.x) {
                                        if (!this.isInfluencedBy(var9_19.add(var21_21 * this.getColor(var7_8.x - var9_19.x), var7_8.y), -this.color, var11_13, 3)) {
                                            ++var21_21;
                                            continue;
                                        }
                                        break block128;
                                    }
                                }
                                var4_4.p *= 9;
                                try {
                                    this.go(1);
                                    this.setMove(var4_4);
                                }
                                catch (LineCannotAccessedException var21_23) {
                                    // empty catch block
                                }
                                throw new GameEndException(this.color);
                            }
                        }
                    }
                } else {
                    var12_18 = new Coordinate[15];
                    var14_20 = 0;
                    var20_16 = 0;
                    while (var20_16 < 8) {
                        var21_21 = 0;
                        while (var21_21 < 8) {
                            if (this.getColor(this.board.P[var20_16][var21_21]) == -this.color && this.board.P[var20_16][var21_21] != -this.color * 5) {
                                var7_8 = new Coordinate(var20_16, var21_21);
                                if (!this.isPinnedBy(var7_8, var11_13) && Math.abs(this.getPosition(var7_8)) == 1 && (this.getColor((var6_6 = this.getAttackingPawnMove(var7_8, -this.color))[0]) == this.color || this.getColor(var6_6[1]) == this.color || this.getMovingPawnMove(var7_8, -this.color)[0] == 0)) break;
                                try {
                                    this.go(1);
                                    this.setMove(var4_4);
                                }
                                catch (LineCannotAccessedException var22_29) {
                                    // empty catch block
                                }
                                throw new GameEndException(2);
                            }
                            ++var21_21;
                        }
                        ++var20_16;
                    }
                }
            }
        }
        var15_33 = this.board;
        var14_20 = 1;
        var13_12 = false;
        var20_16 = 1;
        while (true) {
            if (var13_12) {
                try {
                    this.go(-1);
                }
                catch (LineCannotAccessedException var21_24) {
                    break;
                }
                if (Math.abs(var16_5) == 1) {
                    --var14_20;
                    break;
                }
            } else {
                var13_12 = true;
            }
            try {
                this.go(-1);
            }
            catch (LineCannotAccessedException var21_25) {
                break;
            }
            if (Math.abs(var16_5) == 1) break;
            if (var15_33.equals(this.board)) {
                ++var20_16;
            }
            if (var20_16 == 3) {
                try {
                    this.go(var14_20);
                    this.go(1);
                    this.setMove(var4_4);
                }
                catch (LineCannotAccessedException var21_26) {
                    // empty catch block
                }
                throw new GameEndException(3);
            }
            var14_20 += 2;
        }
        try {
            this.go(var14_20);
            this.go(1);
            this.setMove(var4_4);
        }
        catch (LineCannotAccessedException var21_27) {}
    }
}

