import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
/*
 * Created on 2004/05/04
 */
//TODO abstract_surface
/**
 * @author qwert
 *  
 */
public class Surface extends Canvas {
	/*
	 * this class handles any input on Surface by user @author qwert
	 */
	public class InputListener extends AbstractInputListener {
		/*
		 * the buf stores user's key press and the index is the pointer of the
		 * buf to be pressed this time
		 */
		int index;
		int[] buf;
		/*
		 * commands ,will grow
		 */
		Command exit, init;
		/*
		 * doing commands (non-Javadoc)
		 * 
		 * @see javax.microedition.lcdui.CommandListener#commandAction(javax.microedition.lcdui.Command,
		 *        javax.microedition.lcdui.Displayable)
		 */
		public void commandAction(Command c, Displayable s) {
			if (c == exit) {
				app.notifyDestroyed();
			} else if (c == init)
				Winboardclone.game.init();
			repaint();
		}
		/*
		 * this method is only called by Surface.keypressed
		 */
		public void keyPressed(int param) {
			switch (param) {
				case KEY_NUM1 :
				//49
				case KEY_NUM2 :
				//50
				case KEY_NUM3 :
				case KEY_NUM4 :
				case KEY_NUM5 :
				case KEY_NUM6 :
				case KEY_NUM7 :
				case KEY_NUM8 :
					/*
					 * 'a' = 97
					 */
					char[] achar = new char[1];
					if (index % 2 == 0) {
						achar[0] = (char) (param + 48);
					} else {
						achar[0] = (char) (param);
					}
					Winboardclone.messagebar.appendmsg(new String(achar));
					buf[index] = param - KEY_NUM1;
					break;
				default :
					return;
			}
			if (index == 3) {
				index = -1;
				/*
				 * movepiece() may access msg
				 */
				Coordinate c, C;
				c = new Coordinate(buf[0], buf[1]);
				C = new Coordinate(buf[2], buf[3]);
				Winboardclone.game.movepiece(c, C);
			}
			index++;
		}
		/*
		 * init things
		 */
		/**
		 * @param _app
		 */
		public InputListener(MIDlet _app) {
			super(_app);
			exit = new Command("Exit", Command.SCREEN, 0);
			init = new Command("Init", Command.SCREEN, 1);
			addCommand(exit);
			addCommand(init);
			buf = new int[4];
		}
	}
	/*
	 * handles a piece-images and draw that @author qwert
	 * 
	 * To change the template for this generated type comment go to Window -
	 * Preferences - Java - Code Generation - Code and Comments
	 */
	public class PiecesImage {
		/*
		 * the holding piece-images
		 */
		Image image;
		/*
		 * the height and the width of images
		 */
		int length;
		/*
		 * get the image from the record
		 */
		public void setImagefromRecord() {
			try {
				image = Image.createImage("/chessfont" + String.valueOf(length)
						+ "-regular.png");
			} catch (IOException ex) {
				ex.printStackTrace(); // never happen
			}
		}
		/**
		 * init image
		 */
		public PiecesImage(int l) {
			length = l;
			setImagefromRecord();
		}
		//		/*
		//		 * dosen't work
		//		 */
		//		public void setImagefromDatafolder(String name) {
		//			image = Main.archs.getImagefromDatafolder(name, length);
		//		}
		/*
		 * paint squares not borders to copy from image, this method doing
		 * little triky
		 */
		public void paint(Graphics g, int x, int y) {
			/*
			 * the square's color to be drawn
			 */
			int color = 0;//whitesquare = 0 blacksquare = 1
			/*
			 * tmp-Image to copy a square from image
			 */
			Image square = Image.createImage(length, length);
			/*
			 * tmp-Graphics to do that
			 */
			Graphics g2 = square.getGraphics();
			/*
			 * the main routine counts up 64 r means rank f means file
			 */
			for (int r = 7; r >= 0; r--) {
				for (int f = 0; f <= 7; f++) {
					/*
					 * get the kind of piece from Game
					 */
					int p = Winboardclone.game.Position[f][r];
					if (p >= 0) { // space or whitepiece
						/*
						 * Copy a piece-image
						 */
						g2.drawImage(image, -p * length, -2 * color * length,
								Graphics.TOP | Graphics.LEFT);
					} else//blackpiece
					{
						/*
						 * Copy a piece-image
						 */
						g2.drawImage(image, p * length, -2 * color * length
								- length, Graphics.TOP | Graphics.LEFT);
					}
					/*
					 * draw the piece-image
					 */
					g.drawImage(square, f * length + x, (7 - r) * length + y,
							Graphics.TOP | Graphics.LEFT);
					/*
					 * reverse color
					 */
					color = (color + 1) % 2;
				}
				/*
				 * reverse color
				 */
				color = (color + 1) % 2;
			}
		}
	}
	/*
	 * this class handles MessageBar what will be placed above of the
	 * chess-board @author qwert
	 * 
	 * To change the template for this generated type comment go to Window -
	 * Preferences - Java - Code Generation - Code and Comments
	 */
	public class MessageBar extends AbstractMessageBar {
		/*
		 * init msg and height
		 */
		/**
		 * @param str
		 * @param h
		 */
		public MessageBar(String str, int h) {
			super(str, h);
		}
		/*
		 * append str to msg and show it
		 */
		public void appendmsg(String str) {
			msg = msg.concat(str);
			repaint();
		}
		/*
		 * show a new msg
		 */
		public void newmsg(String str) {
			msg = new String(str);
			repaint();
		}
		public void paint(Graphics g, int x, int y) {
			g.setColor(0xFFFFFF);
			g.fillRect(0, 0, Winboardclone.frame.x, height);
			g.setColor(0x2F2F2F);
			g.drawString(msg, 0, 0, Graphics.TOP | Graphics.LEFT);
		}
	}
	InputListener inputlistener;
	PiecesImage piecesimage;
	MessageBar messagebar;
	/*
	 * init the things
	 */
	public Surface(MIDlet app) {
		inputlistener = new InputListener(app);
		setCommandListener(inputlistener);
		Winboardclone.inputlistener = inputlistener;

		if (getWidth() >= 240) {
			piecesimage = new PiecesImage(29);
			messagebar = new MessageBar("Hello! WC", 26);
		} else {
			piecesimage = new PiecesImage(15);
			messagebar = new MessageBar("Hello! WC", 16);
		}
	
	}
	/*
	 * throw anything to Main.InputListener.keyPressed (non-Javadoc)
	 * 
	 * @see javax.microedition.lcdui.Canvas#keyPressed(int)
	 */
	public void keyPressed(int param) {
		Winboardclone.inputlistener.keyPressed(param);
	}
	/*
	 * this will be the most complicated method. (non-Javadoc)
	 * 
	 * @see javax.microedition.lcdui.Canvas#paint(javax.microedition.lcdui.Graphics)
	 */
	public void paint(Graphics g) {
		g.fillRect(0, 0, Winboardclone.frame.x, Winboardclone.frame.y);
		/*
		 * draw boader and etc.//TODO
		 */
		messagebar.paint(g, 0, 0);
		piecesimage.paint(g, 4, Winboardclone.messagebar.height + 4);
	}
}
