import javax.microedition.midlet.MIDlet;
/*
 * Created on 2004/05/04
 */
/**
 * implements chess-rule,PGN,FEN etc.
 * 
 * @author qwert
 */
public class Game implements ChessLibrary {
	/*
	 * this class handles any KEY input on Surface by user only when promotion
	 * occurs @author qwert
	 */
	public class PromotionInputListener extends AbstractInputListener {
		Coordinate c, C;
		/**
		 * @param _app
		 */
		public PromotionInputListener(MIDlet app, Coordinate _c, Coordinate _C) {
			super(app);
			c = _c;
			C = _C;
		}
		/*
		 * this method is only called by Surface.keypressed
		 */
		public void keyPressed(int param) {
			switch (param) {
				case javax.microedition.lcdui.Canvas.KEY_NUM2 :
				//N
				case javax.microedition.lcdui.Canvas.KEY_NUM3 :
				//B
				case javax.microedition.lcdui.Canvas.KEY_NUM4 :
				//R
				case javax.microedition.lcdui.Canvas.KEY_NUM5 :
					//Q
					Position[C.x][C.y] = param
							- javax.microedition.lcdui.Canvas.KEY_NUM0;
					Position[c.x][c.y] = SP;
					rline.go(1);
					Move m = new Move(param
							- javax.microedition.lcdui.Canvas.KEY_NUM0, c, C,
							0, 0, null);
					rline.setMove(m);
					Winboardclone.messagebar.newmsg("");
					Winboardclone.inputlistener = inputlistener;
					inputlistener = null;
					return;
				default :
					return;
			}
		}
	}
	//TODO
	/*
	 * Line @author qwert
	 */
	public class Line {
		int num1; // the number of the 1st move of the lines
		/*
		 * this two arrays(moves and joints) always together the 1st move =
		 * move[0]
		 */
		private Move[] moves;
		/*
		 * this two arrays(moves and joints) always together move[0] is 1st
		 * move so that you can't make a variation before game
		 */
		private Line[] joints;//TODO
		/*
		 * pointers used to joint two lines to make more long line
		 */
		Line pline, cline;// parent,child
		/**
		 *  
		 */
		public Line(int n1, Line pl, Line cl, int len) {
			num1 = n1;
			pline = pl;
			cline = cl;
			moves = new Move[len];
			joints = new Line[len];
		}
	}
	/*
	 * WinboardClone's native chess format @author qwert
	 */
	public class Move {
		/*
		 * piece moves from C(F,R) to c(f,r)
		 */
		public Coordinate c, C;
		/*
		 * fen compatible see FEN, nag is full NAG(Numeric Annotation Glyph)
		 */
		public int fen, nag;
		/*
		 * see ChessLibrary
		 */
		public int piece;
		/*
		 * comments
		 */
		public String str;
		/**
		 * init all variables
		 */
		public Move(int p, Coordinate _c, Coordinate _C, int f, int n, String s) {
			piece = p;
			c = _c;
			C = _C;
			fen = f;
			nag = n;
			str = s;
		}
	}
	/*
	 * holding the position;
	 */
	public int[][] Position;//[file][rank]
	/*
	 * implements Line handling methods this line do not store lines usually
	 * @author qwert
	 */
	public class RootLine extends Line {
		/*
		 * the current pointed line
		 */
		Line line;
		/*
		 * the length of moves of lines under RootLine
		 */
		int length;
		/*
		 * the number of the current pointed line
		 */
		int num;
		/*
		 * indicate the position of the pointed line among the variations x
		 * means position 0,1,2 ... y means length of variations 1,2,3 ...
		 */
		Coordinate variations;
		public Move getMove() {
			return rline.line.moves[rline.num];
		}
		public void setMove(Move m) {
			rline.line.moves[rline.num] = m;
		}
		/*
		 * go forward or backward if n == 0 only call enumlines;
		 */
		public void go(int n) {
			if (n == 0) {
				enumline();
			} else if (n > 0) {
				try {
					line.moves[num + n].notify(); //  do nothing maybe :)
				} catch (IndexOutOfBoundsException e) {
					if (line.cline == null) {
						line.cline = new Line(line.num1 + length, line, null,
								length);
					}
					num += length;
					line = line.cline;
					go(n - length);
					return;
				}
				num += n;
				enumline();
			} else {
				try {
					line.moves[num - n].notify(); //  do nothing maybe :)
				} catch (IndexOutOfBoundsException e) {
					if (line.pline == this) {
						line = this;
						num = 0;
						return;
					}
					num -= length;
					line = line.pline;
					go(n + length);
					return;
				}
				num -= n;
				enumline();
			}
		}
		/*
		 * clear lines(one variation)
		 */
		public void clear() {
			if (line.pline == this) {
				this.cline = null;
				return;
			}
			/*
			 * to clear a variation, line should be the 1st line at the
			 * variation
			 */
			if (line.pline.cline == line) {
				line = line.pline;
				clear();
				return;
			}
			try {
				line.joints[0].pline = line.pline;
			} catch (NullPointerException e) {
				// 			 it is all right
			}
			line.pline.joints[line.num1] = line.joints[0];
		}
		/*
		 * paste a line
		 */
		public void paste(Line l) throws LineCannotAccessedException {
			if (line == this)
				throw new LineCannotAccessedException();
			line.joints[num - num1] = l;
		}
		/*
		 * count up lines while pline is not higher line
		 */
		private void subenumlines(Line l) {
			if (l.pline == this || pline.num1 != line.num1)
				return;
			variations.x++;
			l = l.pline;
			subenumlines(l);
		}
		/*
		 * count up lines while joints[x] exists.
		 */
		private void sub2enumlines(Line l) {
			if (l.joints[num - num1] == null)
				return;
			variations.y++;
			l = l.joints[num - num1];
			sub2enumlines(l);
		}
		// TODOs
		private void enumline() {
			Line l = line;
			variations.x = 0;
			variations.y = 1;
			subenumlines(l);
			l = line;
			sub2enumlines(l);
			variations.y += variations.x;
		}
		//void swapline(Line swappedline, Line swappedline2)
		//throws LineCannotAccessedException {
		//Line tmpl;
		//Line hsl, hsl2;
		//if (swappedline == swappedline2)
		//	return;
		//hsl = gethigherline(swappedline);
		//hsl2 = gethigherline(swappedline2);
		///*
		// * simple swap
		// */
		//if (hsl == hsl2) {
		//	tmpl = swappedline;
		//	swappedline.parentline = swappedline2.parentline;
		//	swappedline.childline = swappedline2.childline;
		//	swappedline2.parentline = tmpl.parentline;
		//	swappedline2.childline = tmpl.childline;
		//	return;
		//}
		///*
		// * swap2 is higher line of swap1
		// */
		//if (hsl == swappedline2){
		//	tmpl = new Line(swappedline.basen, parentline, childline,
		// length,this);
		//	for (int tmpnum = num + 1;
		//		swappedline.getmove(tmpnum) == null;
		//		tmpnum++) {
		//		tmpl.putmove(tmpnum, swappedline.getmove(tmpnum));
		//	}
		//	for (int tmpnum = num + 1; getmove(tmpnum) == null; tmpnum++) {
		//		swappedline.putmove(tmpnum, swappedline.getmove(tmpnum));
		//	} /*
		//																																																												 * lastly set links and move back line so user's line pointer is not
		// changed in user's view
		//																																																												 */
		//	parentline.childline = tmpl;
		//	childline.parentline = tmpl;
		//	this = swappedline;
		//}
		//if (swappedline == swappedline2)
		//	return;
		//
		//if (i == 0) {
		//	/*
		//	* this is higher line and do a special swap
		//	*/
		//	if (basen != num) {
		//		/*
		//					 * lines are same so don't do swap
		//					 */
		//		if (this == swappedline)
		//			return;
		//		/*
		//		 * make tmp line to copy moves from higher line
		//		 */
		//		tmpl =
		//			new Line(
		//				num,
		//				swappedline.parentline,
		//				swappedline.childline,
		//				length);
		//		/*
		//		* copying higher-line's moves to tmpl
		//		*/
		//		for (int tmpnum = num + 1; getmove(tmpnum) == null; tmpnum++) {
		//			tmpl.putmove(tmpnum, getmove(tmpnum));
		//		} /*
		//																																																														* copying smaller-line's moves to higher line
		//																																																														*/
		//		for (int tmpnum = num + 1;
		//			swappedline.getmove(tmpnum) == null;
		//			tmpnum++) {
		//			putmove(tmpnum, swappedline.getmove(tmpnum));
		//		} /*
		//																																																													 * lastly set links and move back line so user's line pointer is not
		// changed in user's view
		//																																																													 */
		//		swappedline.parentline.childline = tmpl;
		//		swappedline.childline.parentline = tmpl;
		//		this = tmpl;
		//		/*
		//		* swappedline is higher line and do a special swap
		//		*/
		//	} else if (swappedline.basen != num) {
		//
		//	} else { /*
		//																																														 * do a swap
		//																																														 */
		//
		//	}
		//} else if (i > 0) {
		//	if (getmove(num).connecter == null)
		//		throw new LineCannotAccessedException();
		//	i--;
		//	getmove(num).connecter.swapline(num, swappedline, i);
		//} else {
		//	if (parentline == rootline)
		//		throw new LineCannotAccessedException();
		//	if (parentline.basen != num && i <= -2)
		//		throw new LineCannotAccessedException();
		//	parentline.swapline(num, swappedline, i);
		//	i++;
		//}
		//return;
		//}
		/**
		 * @param n0
		 * @param pl
		 * @param cl
		 * @param len
		 */
		public RootLine(int len) {
			super(1 - len, null, null, 1);
			// TODO Auto-generated constructor stub
			pline = this;
			line = this;
			length = len;
			variations = new Coordinate(0, 1);
		}
	}
	FEN RootPosition;
	public class FEN {
	}
	/*
	 * the number of the current move
	 */
	int num;
	/*
	 * only used for promotion handling
	 */
	AbstractInputListener inputlistener;
	/*
	 * rootline contains the every lines in a game
	 */
	RootLine rline;
	//TODO
	/*
	 *  
	 */
	public Game() {
		init();
		rline = new RootLine(32);
	}
	/*
	 * init the board
	 */
	public void init() {
		Position = new int[8][8];
		Position[0][7] = BR;
		Position[1][7] = BN;
		Position[2][7] = BB;
		Position[3][7] = BQ;
		Position[4][7] = BK;
		Position[5][7] = BB;
		Position[6][7] = BN;
		Position[7][7] = BR;
		for (int i = 0; i <= 7; i++) {
			Position[i][6] = BP;
		}
		Position[0][0] = WR;
		Position[1][0] = WN;
		Position[2][0] = WB;
		Position[3][0] = WQ;
		Position[4][0] = WK;
		Position[5][0] = WB;
		Position[6][0] = WN;
		Position[7][0] = WR;
		for (int i = 0; i <= 7; i++) {
			Position[i][1] = WP;
		}
	}
	//TODO rename
	public void movepiece(Coordinate c, Coordinate C)// throws
	// IllegalMoveException
	{
		int p;
		p = Position[c.x][c.y];
		if (p == WP && C.y == 7 || p == BP && C.x == 0) {
			inputlistener = Winboardclone.inputlistener;
			Winboardclone.inputlistener = new PromotionInputListener(Winboardclone.inputlistener.app,
					c, C);
			Winboardclone.messagebar.newmsg("Promote pawn to");
			return;
		}
		Position[C.x][C.y] = Position[c.x][c.y];
		Position[c.x][c.y] = SP;
		rline.go(1);
		Move m = new Move(p, c, C, 0, 0, null);
		rline.setMove(m);
		Winboardclone.messagebar.newmsg("");
	}
	public char pieceOf(int p) {
		switch (p) {
			case WP :
				return 'p';
			case BP :
				return 'P';
			case WN :
				return 'n';
			case BN :
				return 'N';
			case WB :
				return 'b';
			case BB :
				return 'B';
			case WR :
				return 'r';
			case BR :
				return 'R';
			case WQ :
				return 'q';
			case BQ :
				return 'Q';
			case WK :
				return 'k';
			case BK :
				return 'K';
			default :
				return ' ';
		}
	}
}
