/*
 * Decompiled with CFR 0.152.
 */
package prantl.ant.eclipse;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import prantl.ant.eclipse.EclipseOutput;
import prantl.ant.eclipse.EclipseTask;
import prantl.ant.eclipse.GeneralPreferencesElement;
import prantl.ant.eclipse.PreferencesElement;
import prantl.ant.eclipse.SettingsElement;
import prantl.ant.eclipse.VariableElement;

final class SettingsGenerator {
    private EclipseTask task;

    SettingsGenerator(EclipseTask parent) {
        this.task = parent;
    }

    private void checkPreferences(SettingsElement settings) {
        if (this.task.getEclipse().getMode().getIndex() == 1 && this.getPreferences(settings, "org.eclipse.ajdt.ui") == null) {
            GeneralPreferencesElement preferences = settings.createGeneral();
            preferences.setName("org.eclipse.ajdt.ui");
        }
    }

    void generate() {
        SettingsElement settings = this.task.getEclipse().getSettings();
        if (settings == null) {
            this.task.log("There were no settings found.", 1);
            return;
        }
        this.checkPreferences(settings);
        Vector entries = settings.getPreferences();
        if (entries.size() == 0) {
            this.task.log("There were no preferences found.", 1);
            return;
        }
        int i = 0;
        int size = entries.size();
        while (i != size) {
            PreferencesElement preferences = (PreferencesElement)entries.get(i);
            preferences.validate();
            this.generatePreferences(preferences);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generatePreferences(PreferencesElement preferences) {
        String packageName;
        EclipseOutput output = this.task.getOutput();
        if (output.isPreferencesUpToDate(packageName = preferences.getName())) {
            this.task.log("The preferences for \"" + packageName + "\" are up-to-date.", 1);
            return;
        }
        this.task.log("Writing the preferences for \"" + packageName + "\".");
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new OutputStreamWriter(output.createPreferences(packageName), "UTF-8");
                this.generateTimeStamp(writer);
                Vector entries = preferences.getVariables();
                if (entries.size() == 0) {
                    this.task.log("There were no variables found for \"" + packageName + "\".", 1);
                }
                int i = 0;
                int size = entries.size();
                while (i != size) {
                    this.generateVariable(writer, (VariableElement)entries.get(i));
                    ++i;
                }
            }
            catch (UnsupportedEncodingException exception) {
                throw new BuildException("Encoder to UTF-8 is not supported.", (Throwable)exception);
            }
            catch (IOException exception) {
                throw new BuildException("Writing the settings failed.", (Throwable)exception);
            }
            Object var6_11 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException exception1) {
                throw new BuildException("Closing the settings failed.", (Throwable)exception1);
            }
        }
        try {
            writer.close();
            return;
        }
        catch (IOException exception1) {
            throw new BuildException("Closing the settings failed.", (Throwable)exception1);
        }
    }

    private void generateTimeStamp(OutputStreamWriter writer) throws IOException {
        writer.write(35);
        writer.write(Calendar.getInstance().getTime().toString());
        writer.write(10);
    }

    private void generateVariable(OutputStreamWriter writer, VariableElement variable) throws IOException {
        writer.write(variable.getName());
        writer.write(61);
        writer.write(variable.getValue());
        writer.write(10);
    }

    private PreferencesElement getPreferences(SettingsElement settings, String name) {
        Vector entries = settings.getPreferences();
        int i = 0;
        int size = entries.size();
        while (i != size) {
            PreferencesElement preferences = (PreferencesElement)entries.get(i);
            if (name.equals(preferences.getName())) {
                return preferences;
            }
            ++i;
        }
        return null;
    }
}

