/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.relational;

import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.examples.java.relational.util.WebLogData;
import org.apache.flink.util.Collector;

public class WebLogAnalysis {
    private static boolean fileOutput = false;
    private static String documentsPath;
    private static String ranksPath;
    private static String visitsPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!WebLogAnalysis.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<String, String>> documents = WebLogAnalysis.getDocumentsDataSet(env);
        DataSet<Tuple3<Integer, String, Integer>> ranks = WebLogAnalysis.getRanksDataSet(env);
        DataSet<Tuple2<String, String>> visits = WebLogAnalysis.getVisitsDataSet(env);
        ProjectOperator filterDocs = documents.filter((FilterFunction)new FilterDocByKeyWords()).project(new int[]{0});
        FilterOperator filterRanks = ranks.filter((FilterFunction)new FilterByRank());
        ProjectOperator filterVisits = visits.filter((FilterFunction)new FilterVisitsByDate()).project(new int[]{0});
        JoinOperator.ProjectJoin joinDocsRanks = filterDocs.join((DataSet)filterRanks).where(new int[]{0}).equalTo(new int[]{1}).projectSecond(new int[]{0, 1, 2});
        CoGroupOperator result = joinDocsRanks.coGroup((DataSet)filterVisits).where(new int[]{1}).equalTo(new int[]{0}).with((CoGroupFunction)new AntiJoinVisits());
        if (fileOutput) {
            result.writeAsCsv(outputPath, "\n", "|");
        } else {
            result.print();
        }
        env.execute("WebLogAnalysis Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing WebLog Analysis example with built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  We provide a data generator to create synthetic input files for this program.");
            System.out.println("  Usage: WebLogAnalysis <documents path> <ranks path> <visits path> <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 4) {
            documentsPath = args[0];
            ranksPath = args[1];
            visitsPath = args[2];
            outputPath = args[3];
            return true;
        }
        System.err.println("Usage: WebLogAnalysis <documents path> <ranks path> <visits path> <result path>");
        return false;
    }

    private static DataSet<Tuple2<String, String>> getDocumentsDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(documentsPath).fieldDelimiter('|').types(String.class, String.class);
        }
        return WebLogData.getDocumentDataSet(env);
    }

    private static DataSet<Tuple3<Integer, String, Integer>> getRanksDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(ranksPath).fieldDelimiter('|').types(Integer.class, String.class, Integer.class);
        }
        return WebLogData.getRankDataSet(env);
    }

    private static DataSet<Tuple2<String, String>> getVisitsDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(visitsPath).fieldDelimiter('|').includeFields("011000000").types(String.class, String.class);
        }
        return WebLogData.getVisitDataSet(env);
    }

    public static class AntiJoinVisits
    implements CoGroupFunction<Tuple3<Integer, String, Integer>, Tuple1<String>, Tuple3<Integer, String, Integer>> {
        public void coGroup(Iterable<Tuple3<Integer, String, Integer>> ranks, Iterable<Tuple1<String>> visits, Collector<Tuple3<Integer, String, Integer>> out) {
            if (!visits.iterator().hasNext()) {
                for (Tuple3<Integer, String, Integer> next : ranks) {
                    out.collect(next);
                }
            }
        }
    }

    public static class FilterVisitsByDate
    implements FilterFunction<Tuple2<String, String>> {
        private static final int YEARFILTER = 2007;

        public boolean filter(Tuple2<String, String> value) throws Exception {
            String dateString = (String)value.f1;
            int year = Integer.parseInt(dateString.substring(0, 4));
            return year == 2007;
        }
    }

    public static class FilterByRank
    implements FilterFunction<Tuple3<Integer, String, Integer>> {
        private static final int RANKFILTER = 40;

        public boolean filter(Tuple3<Integer, String, Integer> value) throws Exception {
            return (Integer)value.f0 > 40;
        }
    }

    public static class FilterDocByKeyWords
    implements FilterFunction<Tuple2<String, String>> {
        private static final String[] KEYWORDS = new String[]{" editors ", " oscillations "};

        public boolean filter(Tuple2<String, String> value) throws Exception {
            String docText = (String)value.f1;
            for (String kw : KEYWORDS) {
                if (docText.contains(kw)) continue;
                return false;
            }
            return true;
        }
    }
}

