package jp.ac.dendai.cdl.mori.wikie.util;

import static org.junit.Assert.assertEquals;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.junit.Test;

public class WNormalizerTest {

    public Map<String, Integer> nsNumberMap = new HashMap<String, Integer>(); {
        nsNumberMap.put("wikipedia", 4);
        nsNumberMap.put("category", 14);
    }

    public Map<Integer, String> originalNsMap = new HashMap<Integer, String>(); {
        originalNsMap.put(4, "wikipedia");
        originalNsMap.put(14, "category");
    }

    public Set<String> langSet = new TreeSet<String>();

    public Set<String> proSet = new TreeSet<String>();

    public WNormalizerTest() {
        super();
        try {
            WikipediaDump db2 = new WikipediaDump();
            db2.setUp(new FileInputStream(new File("D:\\data\\wikipedia\\jawiki-latest-interwiki.sql")));

            langSet.addAll(db2.getLanguagePrefixSet());
            proSet.addAll(db2.getProjectPrefixSet());
            proSet.add("w");
        } catch (SQLException e) {
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDecode() {
        try {
            assertEquals("真SAMURAI_SPIRITS_覇王丸地獄変（1994年）", WNormalizer.decodeSectionLink(".E7.9C.9FSAMURAI_SPIRITS_.E8.A6.87.E7.8E.8B.E4.B8.B8.E5.9C.B0.E7.8D.84.E5.A4.89.EF.BC.881994.E5.B9.B4.EF.BC.89"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testNormalize() {
        try {
            WNormalizer n = new WNormalizer(nsNumberMap, langSet, proSet);
            n.setOrignalNsMap(originalNsMap);
            WLinkUtils link = new WLinkUtils(n);
            WTitle entry = n.normalize("利用者:テスト");
            System.out.println(link.getKind(entry, "abc"));

            assertEquals("", n.normalize(":").toString());
            assertEquals("", n.normalize(" : ").toString());
            assertEquals("", n.normalize("").toString());
            assertEquals("", n.normalize(" ").toString());
            assertEquals("en:category:MAGIC : the", n.normalize(" : EN : CaTeGoRy : mAGIC : the").toString());
            assertEquals("en:category:MAGIC : the", n.normalize("EN : CaTeGoRy : mAGIC : the").toString());
            assertEquals("category:MAGIC : the", n.normalize("CaTeGoRy : mAGIC : the").toString());
            assertEquals("MAGIC : the", n.normalize("mAGIC : the").toString());
            assertEquals(".hack//G.U.: The World", n.normalize(".hack//G.U.: The World").toString());
            assertEquals("Abc", n.normalize("abc").toString());
            assertEquals("Abc", n.normalize(":abc").toString());
            assertEquals("en:Abc", n.normalize(":En:abc").toString());
            assertEquals("en:category:Computer: abc", n.normalize("En : Category : computer: abc").toString());
            assertEquals("en:category:Computer: abc", n.normalize(":En : Category : computer: abc").toString());
            assertEquals("", n.normalize("").toString());
            assertEquals("%", n.normalize("%").toString());
            assertEquals("%1", n.normalize("%1").toString());
            assertEquals("ニュース速報+板", n.normalize("ニュース速報+板").toString());
            assertEquals(")2", n.normalize("%292").toString());
            assertEquals("ジャガー (曖昧さ回避)", n.normalize("ジャガー_%28曖昧さ回避%29").toString());
            assertEquals("ジャガー 7(曖昧さ回避)", n.normalize("ジャガー_7%28曖昧さ回避%29").toString());
            assertEquals("", n.normalize(":").toString());
            assertEquals("", n.normalize("category:").toString());
            assertEquals("Abc", n.normalize("abc").toString());
            assertEquals("+", n.normalize("+").toString());
            assertEquals("&", n.normalize("&amp;").toString());
            assertEquals("&", n.normalize("%26amp%3B").toString());
            assertEquals("バッシング (映画)", n.normalize("%E3%83%90%E3%83%83%E3%82%B7%E3%83%B3%E3%82%B0 %28%E6%98%A0%E7%94%BB%29").toString());
            assertEquals("category:Abc", n.normalize("Category:abc").toString());
            assertEquals("category:Abc", n.normalize("Category : abc").toString());
            assertEquals("category:A b c", n.normalize(" Category _:_ a _ b _ c ").toString());
            assertEquals("category:Magic : ザ・ギャザリング", n.normalize("Category:magic : ザ・ギャザリング").toString());
            assertEquals("'''", "'''");
            assertEquals("en:Richard M. Daley|リチャード・デイリー", n.normalize(":en:Richard M. Daley|リチャード・デイリー").toString());
            assertEquals("あいう", n.normalize(":あいう").toString());
            assertEquals("ウィンドウズ100%", n.normalize("ウィンドウズ100%").toString());
            assertEquals("ウィリアムズ%R", n.normalize("ウィリアムズ%R").toString());
            assertEquals("犬", n.normalize("%E7%8A%AC").toString());
            assertEquals("en:Wikipedia", n.normalize("en:Wikipedia").toString());
            assertEquals("En", n.normalize("en").toString());
            assertEquals("", n.normalize("en:").toString());
            assertEquals("w:en:wikipedia:Wikipedia", n.normalize("w:en:Wikipedia:Wikipedia").toString());
            assertEquals("w:Xyz", n.normalize("W:xyz").toString());
            assertEquals("category:Category", n.normalize("category:category").toString());
            assertEquals("en:En:category:category", n.normalize("En:En:category:category").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}
