/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.mapred;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import jp.ac.dendai.cdl.mori.wikie.mapred.WMapper;
import jp.ac.dendai.cdl.mori.wikie.parser.WPageElementHandler;
import jp.ac.dendai.cdl.mori.wikie.util.WEntry;
import jp.ac.dendai.cdl.mori.wikie.util.WNormalizer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class EdgeMapper
extends WMapper {
    public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        try {
            WPageElementHandler page = this.createPageHandler(value);
            WEntry entry = this.normalizer.normalize(page.getTitle());
            String title = entry.toString();
            String id = page.getId();
            String text = WNormalizer.deleteNonPrintingChar(page.getText());
            String kind = this.linkUtils.getKind(entry, text);
            if (kind != null) {
                if (kind.equals("leaf") || kind.equals("node")) {
                    List<WEntry> categoryArrayList = this.linkUtils.getCategory(text);
                    output.collect((Object)new Text(title), (Object)new Text("entry\t" + kind + "\t" + id));
                    Iterator<WEntry> itr = categoryArrayList.iterator();
                    while (itr.hasNext()) {
                        String category = itr.next().toString();
                        try {
                            output.collect((Object)new Text(category), (Object)new Text("edge\t" + id));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (kind.equals("redirect")) {
                    String redirect = this.linkUtils.isRedirect(text).toString();
                    output.collect((Object)new Text(title), (Object)new Text("entry\tleaf\t" + id));
                    output.collect((Object)new Text(redirect), (Object)new Text("target\t" + id));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

