/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.api.Page;
import info.bliki.api.User;
import info.bliki.api.creator.ImageData;
import info.bliki.api.creator.TopicData;
import info.bliki.api.creator.WikiDB;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.WikipediaParser;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.model.WikiModel;
import info.bliki.wiki.tags.WPATag;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.htmlcleaner.TagNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIWikiModel
extends WikiModel {
    private WikiDB fWikiDB;
    private final String fImageDirectoryName;
    private final User fUser;

    static {
        TagNode.addAllowedAttribute("style");
    }

    public APIWikiModel(User user, WikiDB wikiDB, String imageBaseURL, String linkBaseURL, String imageDirectoryName) {
        this(user, wikiDB, Locale.ENGLISH, imageBaseURL, linkBaseURL, imageDirectoryName);
    }

    public APIWikiModel(User user, WikiDB wikiDB, Locale locale, String imageBaseURL, String linkBaseURL, String imageDirectoryName) {
        super(Configuration.DEFAULT_CONFIGURATION, locale, imageBaseURL, linkBaseURL);
        this.fUser = user;
        this.fWikiDB = wikiDB;
        this.fImageDirectoryName = imageDirectoryName.charAt(imageDirectoryName.length() - 1) == '/' ? imageDirectoryName : String.valueOf(imageDirectoryName) + "/";
        File file = new File(this.fImageDirectoryName);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    @Override
    public String getRawWikiContent(String namespace, String articleName, Map<String, String> templateParameters) {
        String result = super.getRawWikiContent(namespace, articleName, templateParameters);
        if (result != null) {
            return result;
        }
        String name = articleName;
        if (namespace.equals("Template")) {
            TopicData topicData;
            String content;
            block8: {
                content = null;
                topicData = this.fWikiDB.selectTopic("Template:" + name);
                if (topicData == null) break block8;
                content = topicData.getContent();
                if ((content = this.getRedirectedWikiContent(content, templateParameters)) != null) {
                    return content.length() == 0 ? null : content;
                }
                return null;
            }
            try {
                Page page;
                String[] listOfTitleStrings = new String[]{"Template:" + name};
                this.fUser.login();
                List<Page> listOfPages = this.fUser.queryContent(listOfTitleStrings);
                Iterator<Page> iterator = listOfPages.iterator();
                if (iterator.hasNext() && (content = (page = iterator.next()).getCurrentContent()) != null) {
                    topicData = new TopicData("Template:" + name, content);
                    this.fWikiDB.insertTopic(topicData);
                    content = this.getRedirectedWikiContent(content, templateParameters);
                    if (content != null) {
                        content = content.length() == 0 ? null : content;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return content;
        }
        return null;
    }

    public String getRedirectedWikiContent(String rawWikitext, Map<String, String> templateParameters) {
        if (rawWikitext.length() < 9) {
            return rawWikitext;
        }
        String redirectedLink = WikipediaParser.parseRedirect(rawWikitext, this);
        if (redirectedLink != null) {
            String redirNamespace = "";
            String redirArticle = redirectedLink;
            int index = redirectedLink.indexOf(":");
            if (index > 0) {
                redirNamespace = redirectedLink.substring(0, index);
                if (this.isNamespace(redirNamespace)) {
                    redirArticle = redirectedLink.substring(index + 1);
                } else {
                    redirNamespace = "";
                }
            }
            try {
                int level = this.incrementRecursionLevel();
                if (level > 64) {
                    String string = "Error - getting content of redirected link: " + redirNamespace + ":" + redirArticle;
                    return string;
                }
                String string = this.getRawWikiContent(redirNamespace, redirArticle, templateParameters);
                return string;
            }
            finally {
                this.decrementRecursionLevel();
            }
        }
        return rawWikitext;
    }

    @Override
    public void appendInternalImageLink(String hrefImageLink, String srcImageLink, ImageFormat imageFormat) {
        block15: {
            try {
                File file;
                String imageName = imageFormat.getFilename();
                ImageData imageData = this.fWikiDB.selectImage(imageName);
                if (imageData != null && (file = new File(imageData.getFilename())).exists()) {
                    super.appendInternalImageLink(hrefImageLink, "file:///" + imageData.getFilename(), imageFormat);
                    return;
                }
                String imageNamespace = this.getImageNamespace();
                String[] listOfTitleStrings = new String[]{String.valueOf(imageNamespace) + ":" + imageName};
                this.fUser.login();
                List<Page> listOfPages = this.fUser.queryImageinfo(listOfTitleStrings);
                Iterator<Page> iterator = listOfPages.iterator();
                if (!iterator.hasNext()) break block15;
                Page page = iterator.next();
                imageData = new ImageData(imageName);
                FileOutputStream os = null;
                try {
                    String filename = String.valueOf(this.fImageDirectoryName) + page.getTitle().substring(imageNamespace.length() + 1).replaceAll(" ", "_");
                    os = new FileOutputStream(filename);
                    page.downloadImageUrl(os);
                    imageData.setUrl(page.getImageUrl());
                    imageData.setFilename(filename);
                    this.fWikiDB.insertImage(imageData);
                    super.appendInternalImageLink(hrefImageLink, "file:///" + filename, imageFormat);
                    return;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void appendInternalLink(String topic, String hashSection, String topicDescription, String cssClass) {
        WPATag aTagNode = new WPATag();
        aTagNode.addAttribute("id", "w", true);
        String href = topic;
        if (hashSection != null) {
            href = String.valueOf(href) + '#' + hashSection;
        }
        aTagNode.addAttribute("href", href, true);
        if (cssClass != null) {
            aTagNode.addAttribute("class", cssClass, true);
        }
        aTagNode.addObjectAttribute("wikilink", topic);
        this.pushNode(aTagNode);
        WikipediaParser.parseRecursive(topicDescription.trim(), this, false, true);
        this.popNode();
    }

    @Override
    public void parseInternalImageLink(String imageNamespace, String rawImageLink) {
        if (this.fExternalImageBaseURL != null) {
            String imageHref = this.fExternalWikiBaseURL;
            String imageSrc = this.fExternalImageBaseURL;
            ImageFormat imageFormat = ImageFormat.getImageFormat(rawImageLink, imageNamespace);
            String imageName = imageFormat.getFilename();
            imageName = Encoder.encodeUrl(imageName);
            if (this.replaceColon()) {
                imageHref = imageHref.replace("${title}", String.valueOf(imageNamespace) + '/' + imageName);
                imageSrc = imageSrc.replace("${image}", imageName);
            } else {
                imageHref = imageHref.replace("${title}", String.valueOf(imageNamespace) + ':' + imageName);
                imageSrc = imageSrc.replace("${image}", imageName);
            }
            this.appendInternalImageLink(imageHref, imageSrc, imageFormat);
        }
    }
}

