/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.MethodException;
import info.bliki.api.UnexpectedAnswerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.htmlcleaner.util.DivErrorboxExtractor;
import org.htmlcleaner.util.HtmlForm;
import org.htmlcleaner.util.HtmlFormExtractor;

public class MediaWikiComm {
    private static final String WP_SECTION = "wpSection";
    private static final String WP_STARTTIME = "wpStarttime";
    private static final String WP_EDITTIME = "wpEdittime";
    private static final String WP_SCROLLTOP = "wpScrolltop";
    private static final String WP_TEXTBOX1 = "wpTextbox1";
    private static final String WP_SUMMARY = "wpSummary";
    private static final String WP_SAVE = "wpSave";
    private static final String WP_EDITTOKEN = "wpEditToken";
    private static final String WP_AUTOSUMMARY = "wpAutoSummary";
    private String fPageURL;
    private String[] fCookiePairs;
    private EditFormData fPageData;
    private HttpClient fHttpClient = new HttpClient();

    public MediaWikiComm(String pageURL, String[] cookiePairs) {
        if (pageURL == null) {
            throw new NullPointerException();
        }
        this.fPageURL = pageURL;
        this.fCookiePairs = cookiePairs != null ? (String[])cookiePairs.clone() : new String[]{};
    }

    public EditFormData loadEditFormData(String title) throws IOException {
        String empty;
        String responseBody;
        block20: {
            GetMethod method = new GetMethod(String.valueOf(this.fPageURL) + "?title=" + title + "&action=edit");
            int responseCode = 200;
            responseBody = null;
            method.getParams().setCookiePolicy("ignoreCookies");
            String cookies = this.getCookieString();
            if (cookies.length() > 0) {
                method.setRequestHeader("Cookie", cookies);
            }
            try {
                responseCode = this.fHttpClient.executeMethod((HttpMethod)method);
                if (responseCode >= 200 && responseCode < 300) {
                    String charSet = method.getResponseCharSet();
                    BufferedReader br = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), charSet));
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        pw.println(line);
                    }
                    pw.flush();
                    responseBody = sw.toString();
                    break block20;
                }
                throw new IOException(String.valueOf(method.getStatusText()) + " (" + responseCode + ")");
            }
            finally {
                method.releaseConnection();
            }
        }
        HtmlForm form = new HtmlForm("editform", 1, "", "");
        new HtmlFormExtractor(form).extractContent(responseBody);
        String startTime = empty = "";
        String editTime = empty;
        String editText = empty;
        String autoSummary = empty;
        String editToken = empty;
        if (form != null) {
            int sz = form.getElementCount();
            int i = 0;
            while (i < sz) {
                block21: {
                    HtmlForm.Element element = form.getElement(i);
                    HtmlForm.ElementAttribute nameAttr = element.getElementAttributeByName("name");
                    HtmlForm.ElementAttribute valueAttr = element.getElementAttributeByName("value");
                    String name = nameAttr != null ? nameAttr.getValue() : null;
                    try {
                        if (WP_STARTTIME.equals(name)) {
                            startTime = valueAttr.getValue();
                            break block21;
                        }
                        if (WP_EDITTIME.equals(name)) {
                            editTime = valueAttr.getValue();
                            break block21;
                        }
                        if (WP_TEXTBOX1.equals(name)) {
                            BufferedReader br2 = new BufferedReader(new StringReader(element.getEmbeddedText()));
                            StringWriter sw2 = new StringWriter();
                            PrintWriter pw2 = new PrintWriter(sw2);
                            String line2 = null;
                            while ((line2 = br2.readLine()) != null) {
                                pw2.println(line2);
                            }
                            pw2.close();
                            try {
                                br2.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            editText = sw2.getBuffer().toString();
                            break block21;
                        }
                        if (WP_AUTOSUMMARY.equals(name)) {
                            autoSummary = valueAttr.getValue();
                        } else if (WP_EDITTOKEN.equals(name)) {
                            editToken = valueAttr.getValue();
                        }
                    }
                    catch (RuntimeException rte) {
                        rte.printStackTrace();
                        throw new IOException("invalid editform data: " + rte.toString());
                    }
                }
                ++i;
            }
        } else {
            throw new IOException("no edit form on page");
        }
        return new EditFormData(startTime, editTime, editText, autoSummary, editToken);
    }

    public void saveData(String title, String newEditText) throws IOException {
        if (newEditText == null) {
            throw new IOException("could not generate updated page content");
        }
        this.fPageData = this.loadEditFormData(title);
        PostMethod method = new PostMethod(String.valueOf(this.fPageURL) + "?title=" + title + "&action=submit");
        int responseCode = 200;
        method.getParams().setCookiePolicy("ignoreCookies");
        String cookies = this.getCookieString();
        if (cookies.length() > 0) {
            method.setRequestHeader("Cookie", cookies);
        }
        method.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        NameValuePair[] params = new NameValuePair[]{new NameValuePair(WP_SECTION, ""), new NameValuePair(WP_STARTTIME, this.fPageData.getStartTime()), new NameValuePair(WP_EDITTIME, this.fPageData.getEditTime()), new NameValuePair(WP_SCROLLTOP, ""), new NameValuePair(WP_TEXTBOX1, newEditText), new NameValuePair(WP_SUMMARY, ""), new NameValuePair(WP_SAVE, "Save page"), new NameValuePair(WP_EDITTOKEN, this.fPageData.getEditToken()), new NameValuePair(WP_AUTOSUMMARY, this.fPageData.getAutoSummary())};
        method.addParameters(params);
        try {
            responseCode = this.fHttpClient.executeMethod((HttpMethod)method);
            if (responseCode >= 200 && responseCode < 300) {
                throw new ConcurrentEditException();
            }
            if (responseCode != 302) {
                throw new IOException(String.valueOf(method.getStatusText()) + " (" + responseCode + ")");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private String getCookieString() {
        StringBuffer cookieBuf = new StringBuffer();
        int pairs = this.fCookiePairs != null ? this.fCookiePairs.length / 2 : 0;
        int i = 0;
        while (i < pairs) {
            if (i > 0) {
                cookieBuf.append("; ");
            }
            cookieBuf.append(this.fCookiePairs[i]);
            cookieBuf.append('=');
            cookieBuf.append(this.fCookiePairs[i + 1]);
            i += 2;
        }
        return cookieBuf.toString();
    }

    public boolean login(String user, String password, boolean remember) throws UnexpectedAnswerException, MethodException {
        boolean result;
        block8: {
            PostMethod method = new PostMethod(this.fPageURL);
            method.setFollowRedirects(false);
            method.addRequestHeader("User-Agent", "plog4u.org/3.0");
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("title", "Special:Userlogin"), new NameValuePair("action", "submit"), new NameValuePair("wpName", user), new NameValuePair("wpPassword", password), new NameValuePair("wpRemember", remember ? "1" : "0"), new NameValuePair("wpLoginattempt", "submit")};
            method.addParameters(params);
            try {
                try {
                    int responseCode = this.fHttpClient.executeMethod((HttpMethod)method);
                    String responseBody = method.getResponseBodyAsString();
                    if (responseCode == 302 && responseBody.length() == 0) {
                        this.saveLoginData();
                        result = true;
                        break block8;
                    }
                    if (responseCode == 200) {
                        StringBuilder buff = new StringBuilder("Probably logout not successful: responseCode == 200: ");
                        new DivErrorboxExtractor(buff).extractContent(responseBody);
                        boolean result2 = false;
                        throw new UnexpectedAnswerException(buff.toString());
                    }
                    throw new UnexpectedAnswerException("login not successful: " + method.getStatusLine());
                }
                catch (HttpException e) {
                    throw new MethodException("method failed", e);
                }
                catch (IOException e) {
                    throw new MethodException("method failed", e);
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        return result;
    }

    private void saveLoginData() {
        Cookie[] cookies = this.fHttpClient.getState().getCookies();
        this.fCookiePairs = new String[8];
        int i = 0;
        while (i < cookies.length) {
            this.fCookiePairs[i] = "";
            ++i;
        }
        i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            String cookieName = cookie.getName();
            String cookieValue = cookie.getValue();
            String cookieNameLowerCase = cookieName.toLowerCase();
            if (cookieNameLowerCase.endsWith("_session")) {
                this.fCookiePairs[0] = cookieName;
                this.fCookiePairs[1] = cookieValue;
            } else if (cookieNameLowerCase.endsWith("userid")) {
                this.fCookiePairs[2] = cookieName;
                this.fCookiePairs[3] = cookieValue;
            } else if (cookieNameLowerCase.endsWith("username")) {
                this.fCookiePairs[4] = cookieName;
                this.fCookiePairs[5] = cookieValue;
            } else if (cookieNameLowerCase.endsWith("token")) {
                this.fCookiePairs[6] = cookieName;
                this.fCookiePairs[7] = cookieValue;
            }
            ++i;
        }
    }

    public boolean logout() throws UnexpectedAnswerException, MethodException {
        boolean result;
        block8: {
            GetMethod method = new GetMethod(this.fPageURL);
            method.setFollowRedirects(false);
            method.addRequestHeader("User-Agent", "plog4u.org/3.0");
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("title", "Special:Userlogout"), new NameValuePair("action", "submit")};
            method.setQueryString(EncodingUtil.formUrlEncode((NameValuePair[])params, (String)"utf-8"));
            try {
                try {
                    int responseCode = this.fHttpClient.executeMethod((HttpMethod)method);
                    String responseBody = method.getResponseBodyAsString();
                    if (responseCode == 302 && responseBody.length() == 0 || responseCode == 200) {
                        result = true;
                        break block8;
                    }
                    if (responseCode == 200) {
                        boolean result2 = false;
                        throw new UnexpectedAnswerException("logout not successful: responseCode == 200");
                    }
                    throw new UnexpectedAnswerException("logout not successful: " + method.getStatusLine());
                }
                catch (HttpException e) {
                    throw new MethodException("method failed", e);
                }
                catch (IOException e) {
                    throw new MethodException("method failed", e);
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        return result;
    }

    public static class ConcurrentEditException
    extends IOException {
        public ConcurrentEditException(String message) {
            super(message);
        }

        public ConcurrentEditException() {
        }
    }

    static class EditFormData {
        private String mStartTime;
        private String mEditTime;
        private String mEditText;
        private String mAutoSummary;
        private String mEditToken;

        EditFormData(String startTime, String editTime, String editText, String autoSummary, String editToken) {
            this.mStartTime = startTime;
            this.mEditTime = editTime;
            this.mEditText = editText;
            this.mAutoSummary = autoSummary;
            this.mEditToken = editToken;
        }

        String getStartTime() {
            return this.mStartTime;
        }

        String getEditText() {
            return this.mEditText;
        }

        String getEditTime() {
            return this.mEditTime;
        }

        String getAutoSummary() {
            return this.mAutoSummary;
        }

        String getEditToken() {
            return this.mEditToken;
        }
    }
}

