package jp.ac.dendai.cdl.mori.wikie.util;

/**
 * Wikipediaのリンクを表現するためのクラス
 * @author Mori
 *
 */
public class WikipediaLink {
    /**
     * アンカーテキスト
     */
    private String anchorText;
    /**
     * リンク先エントリのタイトル
     */
    private String entryTitle;

    public WikipediaLink(String entry, String anchor) {
        entryTitle = entry;
        anchorText = anchor;
    }

    /**
     * アンカーテキストを返す
     * @return　アンカーテキスト
     */
    public String getAnchorText() {
        return anchorText;
    }

    /**
     * リンク先エントリのタイトルを返す
     * @return　リンク先エントリ
     */
    public String getEntryTitle() {
        return entryTitle;
    }
    
    @Override
    public int hashCode() {
        return (getEntryTitle() + getAnchorText()).hashCode();
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof WikipediaLink) {
            WikipediaLink arg = (WikipediaLink) obj;
            return getEntryTitle().equals(arg.getEntryTitle()) &&
                   getAnchorText().equals(arg.getAnchorText());
        }
        else
            return false;
    }
}