package jp.ac.dendai.cdl.mori.wikie.util;

import java.util.*;

/**
 * history処理用のメソッドをあつめたクラス
 * @author Mori
 *
 */
public class WikipediaHistoryUtil {
    /**
     * その日を含めた前方にある最も近い月曜日を取得する
     * @param date 起点となる日
     * @return 引数の日を含めた前方にある最も近い月曜日を取得する
     */
    public static Date getNearestForwardMonday(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        while (true) {
            if (c.get(Calendar.DAY_OF_WEEK) == Calendar.MONDAY) {
                c.set(Calendar.HOUR_OF_DAY, 0);
                c.set(Calendar.MINUTE, 0);
                c.set(Calendar.SECOND, 0);
                return c.getTime();
            }
            c.add(Calendar.DAY_OF_MONTH, 1);
        }
    }

    /**
     * その日を含めない前方にある最も近い月曜日を取得する
     * @param date　起点となる日
     * @return　引数の日を含めない前方にある最も近い月曜日を取得する
     */
    public static Date getForwardMonday(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (c.get(Calendar.DAY_OF_WEEK) == Calendar.MONDAY) {
            c.add(Calendar.WEEK_OF_MONTH, 1);
            return c.getTime();
        }
        while (true) {
            if (c.get(Calendar.DAY_OF_WEEK) == Calendar.MONDAY) {
                c.set(Calendar.HOUR_OF_DAY, 0);
                c.set(Calendar.MINUTE, 0);
                c.set(Calendar.SECOND, 0);
                return c.getTime();
            }
            c.add(Calendar.DAY_OF_MONTH, 1);
        }
    }

    /**
     * その日を含めない後方にある最も近い月曜日を取得する
     * @param date　起点となる日
     * @return　引数の日を含めない後方にある最も近い月曜日を取得する
     */
    public static Date getBackwardMonday(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        while (true) {
            if (c.get(Calendar.DAY_OF_WEEK) == Calendar.MONDAY) {
                c.set(Calendar.HOUR_OF_DAY, 0);
                c.set(Calendar.MINUTE, 0);
                c.set(Calendar.SECOND, 0);
                return c.getTime();
            }
            c.add(Calendar.DAY_OF_MONTH, -1);
        }
    }

    /**
     * その日を含めた後方にある最も近い月曜日を取得する
     * @param date　起点となる日
     * @return　引数の日を含めない後方にある最も近い月曜日を取得する
     */
    public static Date getNearestBackwardMonday(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        while (true) {
            if (c.get(Calendar.DAY_OF_WEEK) == Calendar.MONDAY) {
                c.set(Calendar.HOUR_OF_DAY, 0);
                c.set(Calendar.MINUTE, 0);
                c.set(Calendar.SECOND, 0);
                return c.getTime();
            }
            c.add(Calendar.DAY_OF_MONTH, -1);
        }
    }
}
