package jp.ac.dendai.cdl.mori.wikie.reducer;

import java.io.*;
import java.util.*;

import jp.ac.dendai.cdl.mori.wikie.util.*;

import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

public class VariationReducer extends MapReduceBase
        implements Reducer<Text, Text, Text, Text> {
    @Override
    public void reduce(Text key, Iterator<Text> inputValueItr, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        ArrayList<WikipediaLink> exist = new ArrayList<WikipediaLink>();
        String entry = key.toString();
        while (inputValueItr.hasNext()) {
            String anchor = inputValueItr.next().toString();
            WikipediaLink link = new WikipediaLink(entry, anchor);
            if (!exist.contains(link)) {
                output.collect(new Text(link.getEntryTitle()), new Text(link.getAnchorText()));
                exist.add(link);
            }
        }

    }

}
