package jp.ac.dendai.cdl.mori.wikie.reducer;

import java.io.*;
import java.util.*;

import jp.ac.dendai.cdl.mori.wikie.main.*;

import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

/**
 * pageLink処理用Reducer
 * @author Mori
 *
 */
public class PageLinkReducer extends MapReduceBase
        implements Reducer<Text, Text, Text, Text> {
    @Override
    public void reduce(Text key, Iterator<Text> inputValueItr, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        ArrayList<String> inputValueArrayList = new ArrayList<String>();
        String entryId = new String("-1");

        while (inputValueItr.hasNext()) {
            String inputValue = inputValueItr.next().toString();
            String[] status = inputValue.split("\t");
            if (status[0].equals(WikIE.ENTRY)) {
                entryId = status[1];
            }
            else {
                inputValueArrayList.add(inputValue);
            }
        }

        Iterator<String> inputValueIterator = inputValueArrayList.iterator();
        while (inputValueIterator.hasNext()) {
            String inputValue = inputValueIterator.next();
            String[] status = inputValue.split("\t");
            //output.collect(new Text(entryId), new Text(key.toString() + "\t" + status[2] + "\t" + status[1]));
            output.collect(new Text(status[1]), new Text(status[0] + "\t" + key.toString() + "\t" + entryId));
        }

    }

}
